/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIReader;

public class EDIUtil {
    private static final DecimalFormat EIGHT_HASH_FORMATTER = new DecimalFormat("0.########E0");
    private static final DecimalFormat NINE_HASH_FORMATTER = new DecimalFormat("0.#########E0");
    private static final DecimalFormat TEN_HASH_FORMATTER = new DecimalFormat("0.##########E0");
    private static String siblingGroupId = "Sibling";
    private static boolean truncateLongValues = false;

    public static int parseStringAsInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expecting integer value, but was '" + str + "'");
        }
    }

    public static String stringToEdi(String inputStr) {
        inputStr = inputStr.replaceAll("\\?", "??");
        inputStr = inputStr.replaceAll(":", "?:");
        inputStr = inputStr.replaceAll("\\+", "?+");
        inputStr = inputStr.replaceAll("'", "?'");
        return inputStr;
    }

    public static String stringToEDIWithMaxLength(String inputStr, int maxAllowedLength) {
        if (inputStr == null) {
            return null;
        }
        if (maxAllowedLength < 1 || inputStr.length() <= maxAllowedLength) {
            return EDIUtil.stringToEdi(inputStr);
        }
        String ediForm = EDIUtil.stringToEdi(inputStr.substring(0, maxAllowedLength));
        return ediForm;
    }

    public static String ediToString(String inputStr) {
        inputStr = inputStr.replaceAll("(?<!\\?):", "");
        inputStr = inputStr.replaceAll("\\?:", ":");
        inputStr = inputStr.replaceAll("\\?'", "'");
        inputStr = inputStr.replaceAll("\\?\\+", "+");
        inputStr = inputStr.replaceAll("\\?\\?", "?");
        return inputStr;
    }

    public static String stringToEDIFreeText(String str, int segmentLength, int maxLength) {
        if (str.length() > maxLength) {
            throw new IllegalArgumentException("Error in segment " + EDI_PREFIX.STRING + " - text string exceeds max length of " + maxLength);
        }
        return EDIUtil.stringToEDI(str, segmentLength);
    }

    public static List<String> stringToEDIFreeText(String str, int segmentLength, int lineLength, int maxRows) {
        if (str.length() > lineLength * maxRows) {
            throw new IllegalArgumentException("Error in segment " + EDI_PREFIX.STRING + " - text string exceeds max length of " + lineLength);
        }
        ArrayList<String> returnedStrings = new ArrayList<String>();
        int strLen = str.length();
        for (int rows = 0; rows < strLen; rows += lineLength) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)EDI_PREFIX.STRING);
            String stringPart = str.substring(rows, Math.min(strLen, rows + lineLength));
            returnedStrings.add(EDIUtil.stringToEDI(stringPart, segmentLength));
        }
        if (returnedStrings.size() > maxRows) {
            throw new IllegalArgumentException("Error in segment " + EDI_PREFIX.STRING + " - text string exceeds the maximum permitted rows: " + maxRows + " with " + returnedStrings.size());
        }
        return returnedStrings;
    }

    private static String stringToEDI(String str, int partitionSize) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EDI_PREFIX.STRING);
        int strLen = str.length();
        for (int i = 0; i < strLen; i += partitionSize) {
            String stringPart = str.substring(i, Math.min(strLen, i + partitionSize));
            if (i != 0 && !stringPart.trim().equals("")) {
                sb.append(":");
            }
            sb.append(EDIUtil.stringToEdi(stringPart));
        }
        sb.append("'");
        return sb.toString();
    }

    public static void parseId(String id) {
        if (id.length() > 18) {
            throw new IllegalArgumentException("Illegal id, structure identifiers can not be more then 18 characters in EDI");
        }
    }

    public static String[] splitOnPlus(String str) {
        return EDIUtil.splitOnChar(str, "\\+", -1);
    }

    public static String[] splitOnPlus(String str, int expectedNumbersplits) {
        return EDIUtil.splitOnChar(str, "\\+", expectedNumbersplits);
    }

    public static String[] splitOnColon(String str) {
        return EDIUtil.splitOnChar(str, ":", -1);
    }

    public static String[] splitOnColon(String str, int expectedNumbersplits) {
        return EDIUtil.splitOnChar(str, ":", expectedNumbersplits);
    }

    private static String[] splitOnChar(String str, String character, int expectedNumbersplits) {
        String[] splitOnPlus = str.split("(?<!\\?)" + character);
        if (expectedNumbersplits > 0 && splitOnPlus.length != expectedNumbersplits) {
            throw new IllegalArgumentException("Unexpected number of '" + character + "' characters, expecting " + expectedNumbersplits + " actual '" + splitOnPlus.length + "'");
        }
        return splitOnPlus;
    }

    public static boolean assertPrefix(EDIReader dataReader, EDI_PREFIX prefix, boolean errorOnFail) {
        if (dataReader.getLineType() != prefix) {
            if (errorOnFail) {
                throw new IllegalArgumentException("Expecting prefix : '" + prefix.getPrefix() + "' but got '" + dataReader.getLineType() + "'");
            }
            return false;
        }
        return true;
    }

    public static String truncate(String aStr) {
        if (aStr.length() < 15) {
            if (aStr.contains("E+")) {
                aStr = aStr.replace("E+", "E");
            }
            return aStr;
        }
        String retStr = EDIUtil.convertStringToExponentForm(aStr);
        if (retStr.contains("E+")) {
            retStr = retStr.replace("E+", "E");
        }
        if ((retStr = retStr.replaceAll("\\.0*$", "")).endsWith(".")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        if (retStr.equals("")) {
            return "0";
        }
        return retStr;
    }

    private static String convertStringToExponentForm(String aStr) {
        int intPartLength;
        double aDouble = Double.valueOf(aStr);
        if (aDouble == 0.0) {
            return "0";
        }
        double intPart = (long)aDouble;
        if (intPart == 0.0 || aDouble < 1.0E-5) {
            int ePos;
            DecimalFormat formatter;
            if (aDouble > 0.0) {
                if (!aStr.contains("E")) {
                    aStr = Double.toString(aDouble);
                    if (!aStr.contains("E")) {
                        formatter = TEN_HASH_FORMATTER;
                    } else {
                        ePos = aStr.indexOf("E");
                        formatter = aStr.length() - ePos == 4 ? NINE_HASH_FORMATTER : TEN_HASH_FORMATTER;
                    }
                } else {
                    aStr = Double.toString(aDouble);
                    ePos = aStr.indexOf("E");
                    formatter = aStr.length() - ePos == 4 ? NINE_HASH_FORMATTER : TEN_HASH_FORMATTER;
                }
            } else {
                aStr = Double.toString(aDouble);
                ePos = aStr.indexOf("E");
                formatter = aStr.contains("E-") ? (aStr.length() - ePos == 3 ? NINE_HASH_FORMATTER : EIGHT_HASH_FORMATTER) : (aStr.length() - ePos == 4 ? EIGHT_HASH_FORMATTER : NINE_HASH_FORMATTER);
            }
            String convertedValue = formatter.format(aDouble);
            return convertedValue;
        }
        if (intPart > 0.0) {
            String numberAsString = aStr;
            int dotIndex = numberAsString.indexOf(".");
            intPartLength = dotIndex != -1 ? dotIndex : numberAsString.length();
            if (intPartLength > 15) {
                DecimalFormat formatter = new DecimalFormat("#.##########E00");
                return formatter.format(aDouble);
            }
        } else {
            intPartLength = 0;
        }
        BigDecimal bd = new BigDecimal(aDouble);
        bd = aDouble > 0.0 ? bd.setScale(14 - intPartLength, RoundingMode.HALF_UP) : bd.setScale(13 - intPartLength, RoundingMode.HALF_UP);
        if (bd.toString().length() > 15) {
            DecimalFormat formatter = aDouble > 0.0 ? new DecimalFormat("#.##########E00") : new DecimalFormat("#.#########E00");
            return formatter.format(aDouble);
        }
        return bd.toString();
    }

    public static String getSiblingGroupId() {
        return siblingGroupId;
    }

    public static void setSiblingGroupId(String siblingGroupId) {
        EDIUtil.siblingGroupId = siblingGroupId;
    }

    public static boolean isTruncateLongValues() {
        return truncateLongValues;
    }

    public static void setTruncateLongValues(boolean newValue) {
        truncateLongValues = newValue;
    }
}

