/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.exception.SdmxReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.ProvisionBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.structureretrieval.engine.CrossReferenceResolverEngine;
import org.sdmxsource.sdmx.structureretrieval.engine.MaintainableCrossReferenceRetrieverEngine;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class CrossReferenceResolverEngineImpl
implements CrossReferenceResolverEngine {
    private static final Logger LOG = LogManager.getLogger(CrossReferenceResolverEngineImpl.class);
    private final MaintainableCrossReferenceRetrieverEngine maintainableCrossReferenceRetrieverEngine = null;
    private boolean resolveAgencies;
    private Map<IdentifiableBean, Set<IdentifiableBean>> crossReferences = new HashMap<IdentifiableBean, Set<IdentifiableBean>>();
    private Map<String, IdentifiableBean> allIdentifiables = new HashMap<String, IdentifiableBean>();
    private Map<String, AgencyBean> agencies = new HashMap<String, AgencyBean>();

    public CrossReferenceResolverEngineImpl() {
    }

    public CrossReferenceResolverEngineImpl(SdmxBeans beans) {
        this();
        this.addBeansToMap(beans);
    }

    private void addBeansToMap(SdmxBeans beans) {
        for (MaintainableBean maint : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            this.addMaintainableToMap(maint);
        }
    }

    private void addMaintainableToMap(MaintainableBean maint) {
        this.allIdentifiables.put(maint.getUrn(), (IdentifiableBean)maint);
        for (IdentifiableBean identifiableBean : maint.getIdentifiableComposites()) {
            if (identifiableBean.getStructureType() == SDMX_STRUCTURE_TYPE.AGENCY) {
                AgencyBean acy = (AgencyBean)identifiableBean;
                this.agencies.put(acy.getFullId(), acy);
            }
            this.allIdentifiables.put(identifiableBean.getUrn(), identifiableBean);
        }
    }

    private void resetMaps() {
        this.crossReferences = new HashMap<IdentifiableBean, Set<IdentifiableBean>>();
        this.agencies = new HashMap<String, AgencyBean>();
    }

    @Override
    public Map<IdentifiableBean, Set<CrossReferenceBean>> getMissingCrossReferences(SdmxBeans beans, int numberLevelsDeep, IdentifiableRetrievalManager retrievalManager) {
        HashMap<IdentifiableBean, Set<CrossReferenceBean>> returnMap = new HashMap<IdentifiableBean, Set<CrossReferenceBean>>();
        this.resolveReferences(beans, false, numberLevelsDeep, retrievalManager, returnMap);
        return returnMap;
    }

    @Override
    public Set<IdentifiableBean> resolveReferences(ProvisionAgreementBean provision, IdentifiableRetrievalManager structRetrievalManager) {
        if (structRetrievalManager == null) {
            throw new IllegalArgumentException("StructureRetrievalManager can not be null");
        }
        HashSet<IdentifiableBean> returnSet = new HashSet<IdentifiableBean>();
        if (provision.getStructureUseage() != null) {
            IdentifiableBean structureUseage = structRetrievalManager.getIdentifiableBean(provision.getStructureUseage());
            if (structureUseage == null) {
                throw new CrossReferenceException(provision.getStructureUseage());
            }
            returnSet.add(structureUseage);
        }
        if (provision.getDataproviderRef() != null) {
            IdentifiableBean dataProvider = structRetrievalManager.getIdentifiableBean(provision.getDataproviderRef());
            if (dataProvider == null) {
                throw new CrossReferenceException(provision.getDataproviderRef());
            }
            returnSet.add(dataProvider);
        }
        return returnSet;
    }

    @Override
    public Map<String, Set<MaintainableBean>> getMissingAgencies(SdmxBeans beans, IdentifiableRetrievalManager retrievalManager) {
        HashSet<String> agencyIds = new HashSet<String>();
        for (AgencyBean acy : beans.getAgencies()) {
            agencyIds.add(acy.getFullId());
        }
        HashMap<String, Set<MaintainableBean>> returnMap = new HashMap<String, Set<MaintainableBean>>();
        for (MaintainableBean currentMaint : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            HashSet<MaintainableBean> maintainables;
            String referencedAgencyId = currentMaint.getAgencyId();
            if (agencyIds.contains(referencedAgencyId)) continue;
            if (retrievalManager != null) {
                try {
                    AgencyBean acy = this.resolveAgency(referencedAgencyId, retrievalManager);
                    if (acy != null) {
                        agencyIds.add(acy.getFullId());
                        continue;
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            if ((maintainables = (HashSet<MaintainableBean>)returnMap.get(referencedAgencyId)) == null) {
                maintainables = new HashSet<MaintainableBean>();
                returnMap.put(referencedAgencyId, maintainables);
            }
            maintainables.add(currentMaint);
        }
        return returnMap;
    }

    @Override
    public Set<IdentifiableBean> resolveReferences(RegistrationBean registation, ProvisionBeanRetrievalManager provRetrievalManager) {
        HashSet<IdentifiableBean> returnSet = new HashSet<IdentifiableBean>();
        if (registation.getProvisionAgreementRef() != null) {
            if (provRetrievalManager == null) {
                throw new IllegalArgumentException("ProvisionRetrievalManager can not be null");
            }
            ProvisionAgreementBean provision = provRetrievalManager.getProvision(registation);
            if (provision == null) {
                throw new CrossReferenceException(registation.getProvisionAgreementRef());
            }
            returnSet.add((IdentifiableBean)provision);
        }
        return returnSet;
    }

    @Override
    public Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferences(SdmxBeans beans, boolean resolveAgencies, int numberLevelsDeep, IdentifiableRetrievalManager retrievalManager) throws CrossReferenceException {
        return this.resolveReferences(beans, resolveAgencies, numberLevelsDeep, retrievalManager, null);
    }

    private Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferences(SdmxBeans beans, boolean resolveAgencies, int numberLevelsDeep, IdentifiableRetrievalManager retrievalManager, Map<IdentifiableBean, Set<CrossReferenceBean>> populateMap) throws CrossReferenceException {
        LOG.info("Resolve References, bean retrieval manager: " + retrievalManager);
        this.resetMaps();
        this.resolveAgencies = resolveAgencies;
        Map<IdentifiableBean, Set<IdentifiableBean>> returnMap = null;
        int numberBeansLast = 0;
        int numberReferencesLast = 0;
        int numberBeansCurrent = -1;
        int numberReferencesCurrent = -1;
        SdmxBeans allBeans = beans;
        int currentLevel = 1;
        do {
            numberBeansLast = numberBeansCurrent;
            numberReferencesLast = numberReferencesCurrent;
            LOG.debug("numberBeansLast= " + numberBeansLast);
            LOG.debug("numberReferencesLast= " + numberReferencesLast);
            returnMap = this.resolveReferencesInternal(allBeans, retrievalManager, populateMap);
            numberBeansCurrent = returnMap.size();
            numberReferencesCurrent = this.countValues(returnMap);
            allBeans = new SdmxBeansImpl(new SdmxBeans[]{beans});
            for (Set<IdentifiableBean> currentBeanSet : returnMap.values()) {
                for (IdentifiableBean currentBean : currentBeanSet) {
                    allBeans.addIdentifiable(currentBean);
                }
            }
            LOG.debug("numberBeansLast= " + numberBeansLast);
            LOG.debug("numberReferencesLast= " + numberReferencesLast);
            LOG.debug("numberBeansCurrent= " + numberBeansCurrent);
            LOG.debug("numberReferencesCurrent= " + numberReferencesCurrent);
            LOG.debug("currentLevel= " + currentLevel);
            LOG.debug("numberLevelsDeep= " + numberLevelsDeep);
            if (currentLevel == numberLevelsDeep) break;
            ++currentLevel;
        } while (numberBeansCurrent != numberBeansLast || numberReferencesCurrent != numberReferencesLast);
        return returnMap;
    }

    @Override
    public Set<IdentifiableBean> resolveReferences(MaintainableBean bean, boolean resolveAgencies, int numberLevelsDeep, IdentifiableRetrievalManager retrievalManager) throws CrossReferenceException {
        this.resetMaps();
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable((IdentifiableBean)bean);
        Map<IdentifiableBean, Set<IdentifiableBean>> references = this.resolveReferences((SdmxBeans)beans, resolveAgencies, numberLevelsDeep, retrievalManager);
        HashSet<IdentifiableBean> returnSet = new HashSet<IdentifiableBean>();
        for (IdentifiableBean key : references.keySet()) {
            returnSet.addAll((Collection<IdentifiableBean>)references.get(key));
        }
        return returnSet;
    }

    private int countValues(Map<IdentifiableBean, Set<IdentifiableBean>> map) {
        int numberReferences = 0;
        for (Set<IdentifiableBean> refences : map.values()) {
            numberReferences += refences.size();
        }
        return numberReferences;
    }

    private Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferencesInternal(SdmxBeans beans, IdentifiableRetrievalManager retrievalManager, Map<IdentifiableBean, Set<CrossReferenceBean>> populateMissingMap) throws CrossReferenceException {
        for (AgencyBean currentAgency : beans.getAgencies()) {
            this.agencies.put(currentAgency.getFullId(), currentAgency);
        }
        this.addBeansToMap(beans);
        if (this.resolveAgencies) {
            for (MaintainableBean currentBean : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
                try {
                    this.resolveAgency(currentBean, retrievalManager);
                }
                catch (CrossReferenceException e) {
                    throw new SdmxReferenceException(this.getAgencyRef(currentBean.getAgencyId()));
                }
            }
        }
        HashSet loopSet = new HashSet();
        loopSet.addAll(beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]));
        InMemoryRetrievalManager retMan = new InMemoryRetrievalManager(beans);
        for (MaintainableBean currentMaintainable : loopSet) {
            LOG.debug("Resolving References For : " + currentMaintainable.getUrn());
            Set<CrossReferenceBean> crossReferences = this.maintainableCrossReferenceRetrieverEngine != null ? this.maintainableCrossReferenceRetrieverEngine.getCrossReferences(retMan, currentMaintainable) : currentMaintainable.getCrossReferences();
            LOG.debug("Number of References : " + crossReferences.size());
            int i = 0;
            for (CrossReferenceBean crossReference : crossReferences) {
                ++i;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolving Reference " + i + ": " + crossReference.toString() + " - referenced from -" + crossReference.getReferencedFrom().getStructureType());
                }
                try {
                    this.storeRef(crossReference.getReferencedFrom(), this.resolveCrossReference(crossReference, retrievalManager));
                }
                catch (CrossReferenceException e) {
                    this.handleMissingReference(e, populateMissingMap);
                    if (populateMissingMap != null) continue;
                    throw e;
                }
            }
        }
        return this.crossReferences;
    }

    private void handleMissingReference(CrossReferenceException e, Map<IdentifiableBean, Set<CrossReferenceBean>> populateMissingMap) throws CrossReferenceException {
        if (populateMissingMap != null && e.getCrossReference() != null) {
            CrossReferenceBean crossReference = e.getCrossReference();
            Set<CrossReferenceBean> missingRefences = populateMissingMap.get(crossReference.getReferencedFrom());
            if (missingRefences == null) {
                missingRefences = new HashSet<CrossReferenceBean>();
                if (crossReference.getReferencedFrom().getStructureType().isIdentifiable()) {
                    populateMissingMap.put((IdentifiableBean)crossReference.getReferencedFrom(), missingRefences);
                } else {
                    populateMissingMap.put((IdentifiableBean)crossReference.getReferencedFrom().getParent(IdentifiableBean.class, true), missingRefences);
                }
            }
            missingRefences.add(crossReference);
        }
    }

    private void resolveAgency(MaintainableBean maint, IdentifiableRetrievalManager structRetrievalManager) throws CrossReferenceException {
        if (!this.resolveAgencies) {
            return;
        }
        if (maint.getAgencyId().equals("SDMX")) {
            return;
        }
        AgencyBean agency = this.resolveAgency(maint.getAgencyId(), structRetrievalManager);
        this.agencies.put(agency.getId(), agency);
        this.storeRef((SDMXBean)maint, (IdentifiableBean)agency);
    }

    private AgencyBean resolveAgency(String agencyId, IdentifiableRetrievalManager identifiableRetrievalManager) throws CrossReferenceException {
        if (this.agencies.containsKey(agencyId)) {
            return this.agencies.get(agencyId);
        }
        AgencyBean agency = null;
        if (identifiableRetrievalManager != null) {
            String[] split = agencyId.split("\\.");
            Object parentAgencyId = "SDMX";
            String targetAgencyId = agencyId;
            if (split.length > 1) {
                targetAgencyId = split[split.length - 1];
                split[split.length - 1] = null;
                String concat = "";
                parentAgencyId = "";
                for (String currentSplit : split) {
                    if (currentSplit != null) {
                        parentAgencyId = (String)parentAgencyId + concat + currentSplit;
                    }
                    concat = ".";
                }
            }
            StructureReferenceBeanImpl agencyRef = new StructureReferenceBeanImpl((String)parentAgencyId, "AGENCIES", "1.0", SDMX_STRUCTURE_TYPE.AGENCY, new String[]{targetAgencyId});
            agency = (AgencyBean)identifiableRetrievalManager.getIdentifiableBean((StructureReferenceBean)agencyRef, AgencyBean.class);
        }
        if (agency == null) {
            throw new SdmxReferenceException(this.getAgencyRef(agencyId));
        }
        return agency;
    }

    private StructureReferenceBean getAgencyRef(String agencyId) {
        String parentAgency = "SDMX";
        if (agencyId.contains(".")) {
            parentAgency = agencyId.substring(0, agencyId.indexOf("."));
            agencyId = agencyId.substring(agencyId.indexOf(".") + 1);
        }
        return new StructureReferenceBeanImpl(parentAgency, "SDMX", "1.0", SDMX_STRUCTURE_TYPE.AGENCY, new String[]{agencyId});
    }

    @Override
    public IdentifiableBean resolveCrossReference(CrossReferenceBean crossReference, IdentifiableRetrievalManager structRetrievalManager) throws CrossReferenceException {
        if (crossReference.getTargetReference() == SDMX_STRUCTURE_TYPE.AGENCY) {
            return this.resolveAgency(crossReference.getFullId(), structRetrievalManager);
        }
        IdentifiableBean resolvedIdentifiable = this.resolveMaintainableFromLocalMaps(crossReference);
        if (resolvedIdentifiable != null) {
            return resolvedIdentifiable;
        }
        IdentifiableBean identifiableBean = null;
        if (structRetrievalManager != null) {
            LOG.info("IdentifiableBean '" + crossReference + "' not found locally, check IdentifiableRetrievalManager");
            identifiableBean = structRetrievalManager.getIdentifiableBean(crossReference);
        }
        if (identifiableBean == null) {
            throw new CrossReferenceException(crossReference);
        }
        this.addMaintainableToMap(identifiableBean.getMaintainableParent());
        return identifiableBean;
    }

    private IdentifiableBean resolveMaintainableFromLocalMaps(CrossReferenceBean xsRef) throws CrossReferenceException {
        return this.allIdentifiables.get(xsRef.getTargetUrn());
    }

    private void storeRef(SDMXBean referencedFrom, IdentifiableBean reference) {
        Set<Object> refList;
        IdentifiableBean refFromIdentifiable = referencedFrom.getStructureType().isIdentifiable() ? (IdentifiableBean)referencedFrom : (IdentifiableBean)referencedFrom.getParent(IdentifiableBean.class, true);
        if (this.crossReferences.containsKey(refFromIdentifiable)) {
            refList = this.crossReferences.get(refFromIdentifiable);
        } else {
            refList = new HashSet();
            this.crossReferences.put(refFromIdentifiable, refList);
        }
        refList.add(reference);
    }
}

