/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.ExternalReferenceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.HeaderRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.RegistrationBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencedRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencingRetrievalManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.ItemSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.IdentifiableRetrievalManagerImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.crossreference.BeanCrossReferencedRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public abstract class BaseSdmxBeanRetrievalManager
extends IdentifiableRetrievalManagerImpl
implements SdmxBeanRetrievalManager {
    protected CrossReferencedRetrievalManager crossReferenceRetrievalManager;
    protected CrossReferencingRetrievalManager crossReferencingRetrievalManager;
    protected ServiceRetrievalManager serviceRetrievalManager;
    private Logger LOG = LogManager.getLogger(BaseSdmxBeanRetrievalManager.class);
    private SdmxBeanRetrievalManager proxy;
    private RegistrationBeanRetrievalManager registrationRetrievalManager;
    private HeaderRetrievalManager headerRetrievalManager;
    private ExternalReferenceRetrievalManager externalReferenceRetrievalManager;

    public BaseSdmxBeanRetrievalManager() {
        this.retrievalManager = this;
        ((IdentifiableRetrievalManagerImpl)this).externalReferenceRetrievalManager = this.externalReferenceRetrievalManager;
        if (this.crossReferenceRetrievalManager == null) {
            this.crossReferenceRetrievalManager = new BeanCrossReferencedRetrievalManager(this);
        }
    }

    public BaseSdmxBeanRetrievalManager(SdmxBeanRetrievalManager retrievalManager) {
        super(retrievalManager);
    }

    @Override
    public AgencyBean getAgency(String id) {
        AgencySchemeBean acySch = null;
        String agencyId = id;
        String agencyParentId = "SDMX";
        if (id.contains(".")) {
            int lastDotIdx = id.lastIndexOf(".");
            agencyParentId = id.substring(0, lastDotIdx);
            agencyId = id.substring(lastDotIdx + 1);
        }
        if ((acySch = this.getMaintainableBean(AgencySchemeBean.class, (MaintainableRefBean)new MaintainableRefBeanImpl(agencyParentId, "AGENCIES", "1.0"))) != null) {
            for (AgencyBean acy : acySch.getItems()) {
                if (!acy.getId().equals(agencyId)) continue;
                return acy;
            }
        }
        return null;
    }

    public <T extends MaintainableBean> T getMaintainableBean(Class<T> structureType, MaintainableRefBean ref) {
        return this.getMaintainableBean(structureType, ref, false, false);
    }

    public MaintainableBean getMaintainableBean(StructureReferenceBean sRef) {
        return this.getMaintainableBean(sRef, false, false);
    }

    public SdmxBeans getSdmxBeans(StructureReferenceBean sRef, ResolutionSettings.RESOLVE_CROSS_REFERENCES resolveCrossReferences) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiables(this.getMaintainableBeans(sRef.getMaintainableStructureType().getMaintainableInterface(), sRef.getMaintainableReference()));
        switch (resolveCrossReferences) {
            case DO_NOT_RESOLVE: {
                break;
            }
            case RESOLVE_ALL: {
                this.resolveReferences((SdmxBeans)beans, true);
                break;
            }
            case RESOLVE_EXCLUDE_AGENCIES: {
                this.resolveReferences((SdmxBeans)beans, false);
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Unknown condition encountered for resolveCrossReferences. Value: " + resolveCrossReferences});
            }
        }
        return beans;
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType) {
        return this.getMaintainableBeans(structureType, null);
    }

    public MaintainableBean getMaintainableBean(StructureReferenceBean sRef, boolean returnStub, boolean returnLatest) {
        if (sRef == null) {
            throw new IllegalArgumentException("getMaintainableBean was passed a null StructureReferenceBean this is not allowed");
        }
        return this.extractFromSet(this.getMaintainableBeans(sRef.getMaintainableStructureType().getMaintainableInterface(), sRef.getMaintainableReference(), returnLatest, returnStub));
    }

    public <T extends MaintainableBean> T getMaintainableBean(Class<T> structureType, MaintainableRefBean ref, boolean returnStub, boolean returnLatest) {
        if (!returnLatest) {
            returnLatest = !ObjectUtil.validObject((Object[])new Object[]{ref.getVersion()});
        }
        return this.extractFromSet(this.getMaintainableBeans(structureType, ref, returnLatest, returnStub));
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref) {
        return this.getMaintainableBeans(structureType, ref, false, false);
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        Set<AgencySchemeBean> returnSet;
        if (returnLatest) {
            ref = new MaintainableRefBeanImpl(ref.getAgencyId(), ref.getMaintainableId(), null);
        }
        if (structureType == AgencySchemeBean.class) {
            returnSet = this.getAgencySchemeBeans(ref, returnStub);
        } else if (structureType == AttachmentConstraintBean.class) {
            returnSet = this.getAttachmentConstraints(ref, returnLatest, returnStub);
        } else if (structureType == ContentConstraintBean.class) {
            returnSet = this.getContentConstraints(ref, returnLatest, returnStub);
        } else if (structureType == DataConsumerSchemeBean.class) {
            returnSet = this.getDataConsumerSchemeBeans(ref, returnStub);
        } else if (structureType == DataProviderSchemeBean.class) {
            returnSet = this.getDataProviderSchemeBeans(ref, returnStub);
        } else if (structureType == CategorisationBean.class) {
            returnSet = this.getCategorisationBeans(ref, returnStub);
        } else if (structureType == CategorySchemeBean.class) {
            returnSet = this.getCategorySchemeBeans(ref, returnLatest, returnStub);
        } else if (structureType == CodelistBean.class) {
            returnSet = this.getCodelistBeans(ref, returnLatest, returnStub);
        } else if (structureType == ConceptSchemeBean.class) {
            returnSet = this.getConceptSchemeBeans(ref, returnLatest, returnStub);
        } else if (structureType == DataflowBean.class) {
            returnSet = this.getDataflowBeans(ref, returnLatest, returnStub);
        } else if (structureType == HierarchicalCodelistBean.class) {
            returnSet = this.getHierarchicCodeListBeans(ref, returnLatest, returnStub);
        } else if (structureType == DataStructureBean.class) {
            returnSet = this.getDataStructureBeans(ref, returnLatest, returnStub);
        } else if (structureType == MetadataFlowBean.class) {
            returnSet = this.getMetadataflowBeans(ref, returnLatest, returnStub);
        } else if (structureType == MetadataStructureDefinitionBean.class) {
            returnSet = this.getMetadataStructureBeans(ref, returnLatest, returnStub);
        } else if (structureType == OrganisationUnitSchemeBean.class) {
            returnSet = this.getOrganisationUnitSchemeBeans(ref, returnLatest, returnStub);
        } else if (structureType == ProcessBean.class) {
            returnSet = this.getProcessBeans(ref, returnLatest, returnStub);
        } else if (structureType == ReportingTaxonomyBean.class) {
            returnSet = this.getReportingTaxonomyBeans(ref, returnLatest, returnStub);
        } else if (structureType == StructureSetBean.class) {
            returnSet = this.getStructureSetBeans(ref, returnLatest, returnStub);
        } else if (structureType == ProvisionAgreementBean.class) {
            returnSet = this.getProvisionAgreementBeans(ref, returnLatest, returnStub);
        } else if (structureType == RegistrationBean.class) {
            returnSet = this.getRegistrationBeans(ref);
        } else if (structureType == SubscriptionBean.class) {
            returnSet = this.getSubscriptionBeans(ref, false, false);
        } else if (structureType == null || structureType == MaintainableBean.class) {
            returnSet = this.getAllMaintainables(ref, returnLatest, returnStub);
        } else {
            throw new SdmxNotImplementedException("getMaintainableBean for type: " + structureType);
        }
        if (returnStub && this.serviceRetrievalManager != null) {
            HashSet<AgencySchemeBean> stubSet = new HashSet<AgencySchemeBean>();
            for (MaintainableBean maintainableBean : returnSet) {
                if (maintainableBean.isExternalReference().isTrue()) {
                    stubSet.add((AgencySchemeBean)maintainableBean);
                    continue;
                }
                stubSet.add((AgencySchemeBean)this.serviceRetrievalManager.createStub(maintainableBean));
            }
            returnSet = stubSet;
        }
        return returnSet;
    }

    protected Set<MaintainableBean> getAllMaintainables(MaintainableRefBean ref, boolean returnLatest, boolean returnStubs) {
        HashSet<MaintainableBean> q = new HashSet<MaintainableBean>();
        for (SDMX_STRUCTURE_TYPE currentMaintainable : SDMX_STRUCTURE_TYPE.getMaintainableStructureTypes()) {
            if (currentMaintainable == SDMX_STRUCTURE_TYPE.REGISTRATION || currentMaintainable == SDMX_STRUCTURE_TYPE.SUBSCRIPTION) continue;
            q.addAll(this.getMaintainableBeans(currentMaintainable.getMaintainableInterface(), ref, returnLatest, returnStubs));
        }
        return q;
    }

    public SdmxBeans getMaintainables(RESTStructureQuery complexQuery) {
        HashSet<ItemSchemeBean> queryResultMaintainables;
        this.LOG.info("Query for maintainables: " + complexQuery);
        boolean isAllStubs = complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == STRUCTURE_QUERY_DETAIL.ALL_STUBS;
        boolean isRefStubs = isAllStubs || complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == STRUCTURE_QUERY_DETAIL.REFERENCED_STUBS;
        boolean isLatest = complexQuery.getStructureQueryMetadata().isReturnLatest();
        SDMX_STRUCTURE_TYPE type = complexQuery.getStructureReference().getMaintainableStructureType();
        if (type == null) {
            type = SDMX_STRUCTURE_TYPE.ANY;
        }
        MaintainableRefBean ref = complexQuery.getStructureReference().getMaintainableReference();
        if (type == SDMX_STRUCTURE_TYPE.ANY) {
            queryResultMaintainables = this.getAllMaintainables(ref, isLatest, isAllStubs);
        } else if (type == SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME) {
            SdmxBeansImpl beans = new SdmxBeansImpl();
            beans.addIdentifiables(this.getMaintainableBeans(AgencySchemeBean.class, ref, isLatest, isAllStubs));
            beans.addIdentifiables(this.getMaintainableBeans(DataProviderSchemeBean.class, ref, isLatest, isAllStubs));
            beans.addIdentifiables(this.getMaintainableBeans(OrganisationUnitSchemeBean.class, ref, isLatest, isAllStubs));
            beans.addIdentifiables(this.getMaintainableBeans(DataConsumerSchemeBean.class, ref, isLatest, isAllStubs));
            queryResultMaintainables = beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        } else {
            queryResultMaintainables = new HashSet(this.getMaintainableBeans(type.getMaintainableInterface(), ref, isLatest, isAllStubs));
        }
        HashSet<MaintainableBean> resolvedStubs = new HashSet<MaintainableBean>();
        if (this.externalReferenceRetrievalManager != null && !isAllStubs) {
            for (MaintainableBean maintainableBean : queryResultMaintainables) {
                if (!maintainableBean.isExternalReference().isTrue()) continue;
                MaintainableBean maintainableBean2 = this.externalReferenceRetrievalManager.resolveFullStructure(maintainableBean);
                resolvedStubs.add(maintainableBean2);
            }
        }
        resolvedStubs.addAll(queryResultMaintainables);
        queryResultMaintainables = resolvedStubs;
        boolean isPartial = complexQuery.getStructureReference().getTargetReference() == null ? false : !complexQuery.getStructureReference().getTargetReference().isMaintainable() && complexQuery.getStructureReference().getTargetReference().isIdentifiable();
        HashSet<ItemSchemeBean> hashSet = new HashSet<ItemSchemeBean>();
        if (isPartial) {
            String identifiableId = complexQuery.getStructureReference().getFullId();
            HashSet<String> identSet = new HashSet<String>();
            identSet.add(identifiableId);
            for (MaintainableBean maintainableBean : queryResultMaintainables) {
                ItemSchemeBean isBean = ((ItemSchemeBean)maintainableBean).filterItems(identSet, true);
                if (isBean.getItems().size() <= 0) continue;
                hashSet.add(isBean);
            }
            queryResultMaintainables = hashSet;
        }
        this.LOG.info("Returned " + queryResultMaintainables.size() + " results");
        HeaderBean header = null;
        if (this.headerRetrievalManager != null) {
            header = this.headerRetrievalManager.getHeader();
        }
        SdmxBeansImpl referencedBeans = new SdmxBeansImpl(header);
        SdmxBeansImpl referenceMerge = new SdmxBeansImpl();
        switch (complexQuery.getStructureQueryMetadata().getStructureReferenceDetail()) {
            case NONE: {
                this.LOG.info("Reference detail NONE");
                break;
            }
            case PARENTS: {
                this.LOG.info("Reference detail PARENTS");
                this.resolveParents(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                break;
            }
            case PARENTS_SIBLINGS: {
                this.LOG.info("Reference detail PARENTS_SIBLINGS");
                this.resolveParents(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                this.resolveChildren(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]), (SdmxBeans)referenceMerge, isRefStubs);
                referencedBeans.merge((SdmxBeans)referenceMerge);
                break;
            }
            case CHILDREN: {
                this.LOG.info("Reference detail CHILDREN");
                this.resolveChildren(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                break;
            }
            case DESCENDANTS: {
                this.LOG.info("Reference detail DESCENDANTS");
                this.resolveDescendants(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                break;
            }
            case ALL: {
                this.LOG.info("Reference detail ALL");
                this.resolveParents(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                this.resolveDescendants(queryResultMaintainables, (SdmxBeans)referenceMerge, isRefStubs);
                referencedBeans.merge((SdmxBeans)referenceMerge);
                break;
            }
            case SPECIFIC: {
                this.LOG.info("Reference detail Children");
                this.resolveSpecific(queryResultMaintainables, (SdmxBeans)referencedBeans, complexQuery.getStructureQueryMetadata().getSpecificStructureReference(), isRefStubs);
            }
        }
        referencedBeans.addIdentifiables(queryResultMaintainables);
        if (isAllStubs && referencedBeans != null) {
            if (this.serviceRetrievalManager == null) {
                throw new SdmxNotImplementedException("Cannot return stubs since no ServiceRetrievalManager has been supplied!");
            }
            HashSet<MaintainableBean> hashSet2 = new HashSet<MaintainableBean>();
            for (MaintainableBean currentMaint : referencedBeans.getAllMaintainables(null)) {
                hashSet2.add(this.serviceRetrievalManager.createStub(currentMaint));
            }
            referencedBeans = new SdmxBeansImpl(header);
            referencedBeans.addIdentifiables(hashSet2);
        }
        this.LOG.info("Result Size : " + referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size());
        return referencedBeans;
    }

    private void createPartialBean(MaintainableBean maint, String[] id) {
        switch (maint.getStructureType()) {
            default: 
        }
    }

    private void resolveSpecific(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, SDMX_STRUCTURE_TYPE specificType, boolean returnStub) {
        this.LOG.info("Resolving Child Structures");
        for (MaintainableBean maintainableBean : resolveFor) {
            this.LOG.debug("Resolving Children of " + maintainableBean.getUrn());
            referencedBeans.addIdentifiables((Collection)this.getCrossReferenceRetrievalManager().getCrossReferencedStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[]{specificType}));
            if (this.getCrossReferencingRetrievalManager() == null) continue;
            referencedBeans.addIdentifiables((Collection)this.getCrossReferencingRetrievalManager().getCrossReferencingStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[]{specificType}));
        }
        this.LOG.info(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size() + " children found");
    }

    private void resolveDescendants(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        int numBeans = -2;
        while (numBeans != resolveFor.size()) {
            numBeans = referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size();
            this.resolveChildren(resolveFor, referencedBeans, returnStub);
            resolveFor = referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        }
        this.LOG.info(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size() + " descendants found");
    }

    private void resolveChildren(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        this.LOG.info("Resolving Child Structures");
        for (MaintainableBean maintainableBean : resolveFor) {
            this.LOG.debug("Resolving Children of " + maintainableBean.getUrn());
            referencedBeans.addIdentifiables((Collection)this.getCrossReferenceRetrievalManager().getCrossReferencedStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[0]));
        }
        this.LOG.info(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size() + " children found");
    }

    private void resolveParents(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        this.LOG.info("Resolving Parents Structures");
        for (MaintainableBean maintainableBean : resolveFor) {
            this.LOG.debug("Resolving Parents of " + maintainableBean.getUrn());
            if (this.getCrossReferencingRetrievalManager() == null) {
                throw new SdmxNotImplementedException("Resolve parents not supported");
            }
            referencedBeans.addIdentifiables((Collection)this.getCrossReferencingRetrievalManager().getCrossReferencingStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[0]));
        }
        this.LOG.info(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size() + " parents found");
    }

    private void resolveReferences(SdmxBeans beans, boolean resolveAgencies) {
        CrossReferenceResolverEngineImpl resolver = new CrossReferenceResolverEngineImpl();
        Map<IdentifiableBean, Set<IdentifiableBean>> crossReferenceMap = resolver.resolveReferences(beans, resolveAgencies, 0, (IdentifiableRetrievalManager)this);
        for (IdentifiableBean key : crossReferenceMap.keySet()) {
            beans.addIdentifiable(key);
            for (IdentifiableBean value : crossReferenceMap.get(key)) {
                beans.addIdentifiable(value);
            }
        }
    }

    private <T extends MaintainableBean> T extractFromSet(Set<T> set) {
        if (!ObjectUtil.validCollection(set)) {
            return null;
        }
        if (set.size() == 1) {
            return (T)((MaintainableBean)set.toArray()[0]);
        }
        throw new SdmxException("Did not expect more then 1 structure from query, got " + set.size() + " strutures.");
    }

    protected Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(AttachmentConstraintBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getAttachmentConstraints"});
    }

    protected Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(CategorisationBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getCategorisationBeans"});
    }

    protected Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(CodelistBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getCodelistBeans"});
    }

    protected Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(ConceptSchemeBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getConceptSchemeBeans"});
    }

    protected Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(ContentConstraintBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getContentConstraints"});
    }

    protected Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(CategorySchemeBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getCategorySchemeBeans"});
    }

    protected Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(DataflowBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataflowBeans"});
    }

    protected Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(HierarchicalCodelistBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getHierarchicCodeListBeans"});
    }

    protected Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(MetadataFlowBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getMetadataflowBeans"});
    }

    protected Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(DataStructureBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataStructureBeans"});
    }

    protected Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(MetadataStructureDefinitionBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getMetadataStructureBeans"});
    }

    protected Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(OrganisationUnitSchemeBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getOrganisationUnitSchemeBeans"});
    }

    protected Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(DataProviderSchemeBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataProviderSchemeBeans"});
    }

    protected Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(DataConsumerSchemeBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataConsumerSchemeBeans"});
    }

    protected Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(AgencySchemeBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getAgencySchemeBeans"});
    }

    protected Set<ProcessBean> getProcessBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(ProcessBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getProcessBeans"});
    }

    protected Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(ProvisionAgreementBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getProvisionAgreementBeans"});
    }

    protected Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(ReportingTaxonomyBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getReportingTaxonomyBeans"});
    }

    protected Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(StructureSetBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getStructureSetBeans"});
    }

    protected Set<SubscriptionBean> getSubscriptionBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(SubscriptionBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getSubscriptionBean"});
    }

    protected Set<RegistrationBean> getRegistrationBeans(MaintainableRefBean ref) {
        if (this.registrationRetrievalManager != null) {
            return this.registrationRetrievalManager.getRegistrations(ref);
        }
        if (this.getProxy() != null) {
            return this.getProxy().getMaintainableBeans(RegistrationBean.class, ref, false, false);
        }
        throw new SdmxNotImplementedException("getRegistrationBeans");
    }

    protected CrossReferencedRetrievalManager getCrossReferenceRetrievalManager() {
        return this.crossReferenceRetrievalManager;
    }

    public void setCrossReferenceRetrievalManager(CrossReferencedRetrievalManager crossReferenceRetrievalManager) {
        this.crossReferenceRetrievalManager = crossReferenceRetrievalManager;
    }

    protected CrossReferencingRetrievalManager getCrossReferencingRetrievalManager() {
        return this.crossReferencingRetrievalManager;
    }

    public void setCrossReferencingRetrievalManager(CrossReferencingRetrievalManager crossReferencingRetrievalManager) {
        this.crossReferencingRetrievalManager = crossReferencingRetrievalManager;
    }

    public void setExternalReferenceRetrievalManager(ExternalReferenceRetrievalManager externalReferenceRetrievalManager) {
        this.externalReferenceRetrievalManager = externalReferenceRetrievalManager;
    }

    public void setServiceRetrievalManager(ServiceRetrievalManager serviceRetrievalManager) {
        this.serviceRetrievalManager = serviceRetrievalManager;
    }

    public void setRegistrationRetrievalManager(RegistrationBeanRetrievalManager registrationRetrievalManager) {
        this.registrationRetrievalManager = registrationRetrievalManager;
    }

    public void setHeaderRetrievalManager(HeaderRetrievalManager headerRetrievalManager) {
        this.headerRetrievalManager = headerRetrievalManager;
    }

    protected SdmxBeanRetrievalManager getProxy() {
        return this.proxy;
    }

    public void setProxy(SdmxBeanRetrievalManager proxy) {
        this.proxy = proxy;
    }
}

