/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.exception.SdmxReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.ExternalReferenceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class IdentifiableRetrievalManagerImpl
implements IdentifiableRetrievalManager {
    protected SdmxBeanRetrievalManager retrievalManager;
    protected ExternalReferenceRetrievalManager externalReferenceRetrievalManager;

    public IdentifiableRetrievalManagerImpl() {
    }

    public IdentifiableRetrievalManagerImpl(SdmxBeanRetrievalManager retrievalManager) {
        this(retrievalManager, null);
    }

    public IdentifiableRetrievalManagerImpl(SdmxBeanRetrievalManager retrievalManager, ExternalReferenceRetrievalManager externalReferenceRetrievalManager) {
        this.retrievalManager = retrievalManager;
        this.externalReferenceRetrievalManager = externalReferenceRetrievalManager;
    }

    public AgencyBean getAgency(String id) {
        StructureReferenceBeanImpl sRef;
        AgencySchemeBean acySch = null;
        String agencyId = id;
        String agencyParentId = "SDMX";
        if (id.contains(".")) {
            int lastDotIdx = id.lastIndexOf(".");
            agencyParentId = id.substring(0, lastDotIdx);
            agencyId = id.substring(lastDotIdx + 1);
        }
        if ((acySch = this.getIdentifiableBean((StructureReferenceBean)(sRef = new StructureReferenceBeanImpl(agencyParentId, "AGENCIES", "1.0", SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, new String[0])), AgencySchemeBean.class)) != null) {
            for (AgencyBean acy : acySch.getItems()) {
                if (!acy.getId().equals(agencyId)) continue;
                return acy;
            }
        }
        return null;
    }

    public <T> T getIdentifiableBean(CrossReferenceBean crossRef, Class<T> structureType) throws CrossReferenceException {
        IdentifiableBean bean = this.getIdentifiableBean(crossRef);
        if (structureType.isAssignableFrom(bean.getClass())) {
            return (T)bean;
        }
        throw new CrossReferenceException(crossRef);
    }

    public IdentifiableBean getIdentifiableBean(CrossReferenceBean crossReferenceBean) {
        try {
            IdentifiableBean identifiableBean = this.getIdentifiableBean((StructureReferenceBean)crossReferenceBean);
            if (identifiableBean != null) {
                return identifiableBean;
            }
        }
        catch (CrossReferenceException crossReferenceException) {
            // empty catch block
        }
        throw new CrossReferenceException(crossReferenceBean);
    }

    public IdentifiableBean getIdentifiableBean(StructureReferenceBean sRef) {
        MaintainableBean maint = this.retrievalManager.getMaintainableBean(sRef);
        if (maint == null) {
            return null;
        }
        if (maint.isExternalReference().isTrue() && this.externalReferenceRetrievalManager != null) {
            maint = this.externalReferenceRetrievalManager.resolveFullStructure(maint);
        }
        String targetURN = sRef.getTargetUrn();
        if (maint.getUrn().equals(targetURN)) {
            return maint;
        }
        for (IdentifiableBean currentIdent : maint.getIdentifiableComposites()) {
            if (!currentIdent.getUrn().equals(targetURN)) continue;
            return currentIdent;
        }
        return null;
    }

    public Set<? extends IdentifiableBean> getIdentifiableBeans(StructureReferenceBean sRef) {
        if (sRef.getTargetReference().isMaintainable()) {
            return this.retrievalManager.getMaintainableBeans(sRef.getTargetReference().getMaintainableInterface(), (MaintainableRefBean)sRef);
        }
        HashSet<IdentifiableBean> idents = new HashSet<IdentifiableBean>();
        for (MaintainableBean currentMaint : this.retrievalManager.getMaintainableBeans(sRef.getMaintainableStructureType().getMaintainableInterface(), sRef.getMaintainableReference())) {
            for (IdentifiableBean comp : currentMaint.getIdentifiableComposites()) {
                if (comp.getStructureType() != sRef.getTargetReference()) continue;
                if (sRef.getChildReference() != null && sRef.getChildReference().getId() != null) {
                    if (!comp.getId().equals(sRef.getChildReference().getId())) continue;
                    idents.add(comp);
                    continue;
                }
                idents.add(comp);
            }
        }
        return idents;
    }

    public <T> T getIdentifiableBean(StructureReferenceBean sRef, Class<T> structureType) throws CrossReferenceException {
        IdentifiableBean bean = this.getIdentifiableBean(sRef);
        if (bean == null) {
            return null;
        }
        if (structureType.isAssignableFrom(bean.getClass())) {
            return (T)bean;
        }
        throw new SdmxReferenceException(sRef);
    }
}

