/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.listener.Listener;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.manager.persist.StructurePersistenceManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureretrieval.manager.BaseSdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;

public class InMemoryRetrievalManager
extends BaseSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager,
StructurePersistenceManager,
Listener<ReadableDataLocation> {
    private static Logger LOG = LogManager.getLogger(InMemoryRetrievalManager.class);
    private final StructureParsingManager structureParsingManager;
    protected SdmxBeans beans = new SdmxBeansImpl();
    ResultExtractor<AgencySchemeBean> agencySchemeExtractor = new ResultExtractor();
    ResultExtractor<AttachmentConstraintBean> attachmentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<CategorisationBean> categorisationExtractor = new ResultExtractor();
    ResultExtractor<CodelistBean> codelistExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<ConceptSchemeBean> conceptSchemeExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<ContentConstraintBean> contentConstraintExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<CategorySchemeBean> categorySchemeExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<DataConsumerSchemeBean> dataConsumerSchemeExtractor = new ResultExtractor();
    ResultExtractor<DataflowBean> dataflowExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<DataProviderSchemeBean> dataProviderSchemeExtractor = new ResultExtractor();
    ResultExtractor<HierarchicalCodelistBean> hierarchicalCodelistExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<MetadataFlowBean> metadataFlowExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<DataStructureBean> dataStructureExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<MetadataStructureDefinitionBean> metadataStructureDefinitionExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<OrganisationUnitSchemeBean> organisationUnitSchemeExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<ProcessBean> processBeanExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<ProvisionAgreementBean> provisionAgreementExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<StructureSetBean> structureSetExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<ReportingTaxonomyBean> reportingTaxonomyExtractor = new ResultExtractor(new MaintainableUtil());
    ResultExtractor<SubscriptionBean> subscriptionExtractor = new ResultExtractor(new MaintainableUtil());

    public InMemoryRetrievalManager() {
        this.structureParsingManager = null;
    }

    public InMemoryRetrievalManager(StructureParsingManager structureParsingManager) {
        this.structureParsingManager = structureParsingManager;
    }

    public InMemoryRetrievalManager(ReadableDataLocation seed, StructureParsingManager structureParsingManager) {
        this(structureParsingManager);
        this.invoke(seed);
    }

    public InMemoryRetrievalManager(SdmxBeans beans) {
        this();
        this.beans = beans;
        if (this.beans == null) {
            this.beans = new SdmxBeansImpl();
        }
    }

    public void invoke(ReadableDataLocation seed) {
        this.beans = new SdmxBeansImpl();
        if (seed != null) {
            if (this.structureParsingManager == null) {
                throw new RuntimeException("Can not create an InMemoryRetrievalManager, StructureParsingManager is null.");
            }
            try {
                this.saveStructures(this.structureParsingManager.parseStructures(seed).getStructureBeans(false));
            }
            finally {
                seed.close();
            }
        }
    }

    public void saveStructure(MaintainableBean maintainable) {
        LOG.info("saveStructure:" + maintainable.getUrn());
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable((IdentifiableBean)maintainable);
        this.saveStructures((SdmxBeans)beans);
    }

    public void deleteStructure(MaintainableBean maintainable) {
        LOG.info("deleteStructure:" + maintainable.getUrn());
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable((IdentifiableBean)maintainable);
        this.deleteStructures((SdmxBeans)beans);
    }

    public void saveStructures(SdmxBeans beans) {
        LOG.info("saveStructures:" + beans.toString());
        this.beans.merge(beans);
    }

    public void deleteStructures(SdmxBeans beans) {
        LOG.info("deleteStructures:" + beans.toString());
        for (MaintainableBean currentMaint : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            this.beans.removeMaintainable(currentMaint);
        }
    }

    public SdmxBeans getBeans() {
        return new SdmxBeansImpl(new SdmxBeans[]{this.beans});
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.attachmentConstraintExtractor.filterResults(this.beans.getAttachmentConstraints(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.contentConstraintExtractor.filterResults(this.beans.getContentConstraintBeans(ref), returnLatest, returnStub);
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.organisationUnitSchemeExtractor.filterResults(this.beans.getOrganisationUnitSchemes(ref), returnLatest, returnStub);
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return this.dataProviderSchemeExtractor.filterResults(this.beans.getDataProviderSchemes(ref), false, returnStub);
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return this.dataConsumerSchemeExtractor.filterResults(this.beans.getDataConsumerSchemes(ref), false, returnStub);
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        return this.agencySchemeExtractor.filterResults(this.beans.getAgenciesSchemes(ref), false, returnStub);
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref, boolean returnStub) {
        return this.categorisationExtractor.filterResults(this.beans.getCategorisations(ref), false, returnStub);
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.categorySchemeExtractor.filterResults(this.beans.getCategorySchemes(ref), returnLatest, returnStub);
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.codelistExtractor.filterResults(this.beans.getCodelists(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.conceptSchemeExtractor.filterResults(this.beans.getConceptSchemes(ref), returnLatest, returnStub);
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.dataflowExtractor.filterResults(this.beans.getDataflows(ref), returnLatest, returnStub);
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.hierarchicalCodelistExtractor.filterResults(this.beans.getHierarchicalCodelists(ref), returnLatest, returnStub);
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.dataStructureExtractor.filterResults(this.beans.getDataStructures(ref), returnLatest, returnStub);
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.metadataFlowExtractor.filterResults(this.beans.getMetadataflows(ref), returnLatest, returnStub);
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.metadataStructureDefinitionExtractor.filterResults(this.beans.getMetadataStructures(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.processBeanExtractor.filterResults(this.beans.getProcesses(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.reportingTaxonomyExtractor.filterResults(this.beans.getReportingTaxonomys(ref), returnLatest, returnStub);
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.structureSetExtractor.filterResults(this.beans.getStructureSets(ref), returnLatest, returnStub);
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.provisionAgreementExtractor.filterResults(this.beans.getProvisionAgreements(ref), returnLatest, returnStub);
    }

    @Override
    protected Set<SubscriptionBean> getSubscriptionBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.subscriptionExtractor.filterResults(this.beans.getSubscriptions(ref), returnLatest, returnStub);
    }

    private class ResultExtractor<T extends MaintainableBean> {
        private MaintainableUtil<T> maintainableUtil;

        public ResultExtractor() {
        }

        public ResultExtractor(MaintainableUtil<T> maintainableUtil) {
            this.maintainableUtil = maintainableUtil;
        }

        private Set<T> filterResults(Set<T> results, boolean returnLatest, boolean returnStub) {
            if (returnLatest && this.maintainableUtil != null) {
                results = this.maintainableUtil.filterCollectionGetLatestOfType(results);
            }
            if (returnStub && InMemoryRetrievalManager.this.serviceRetrievalManager != null) {
                HashSet<MaintainableBean> newSet = new HashSet<MaintainableBean>();
                for (MaintainableBean result : results) {
                    newSet.add(InMemoryRetrievalManager.this.serviceRetrievalManager.createStub(result));
                }
                results = newSet;
            }
            return results;
        }
    }
}

