/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.antlr;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASTUtil {
    private static Log log = LogFactory.getLog(ASTUtil.class);
    private static final String PROPERTY_ENABLED_AST_DUMP = "ENABLE_AST_DUMP";

    public static Tree findFirstNode(Tree parent, int type) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Tree child = parent.getChild(i);
            if (child.getType() != type) continue;
            return child;
        }
        return null;
    }

    public static List<Tree> findAllNodes(Tree parent, int type) {
        ArrayList<Tree> result = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Tree child = parent.getChild(i);
            if (child.getType() != type) continue;
            if (result == null) {
                result = new ArrayList<Tree>();
            }
            result.add(child);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public static void dumpAST(Tree ast) {
        if (System.getProperty(PROPERTY_ENABLED_AST_DUMP) != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ASTUtil.renderNode(new char[0], ast, printer);
            ASTUtil.dumpAST(printer, ast, 2);
            log.info((Object)(".dumpAST ANTLR Tree dump follows...\n" + writer.toString()));
        }
    }

    private static void dumpAST(PrintWriter printer, Tree ast, int ident) {
        char[] identChars = new char[ident];
        Arrays.fill(identChars, ' ');
        if (ast == null) {
            ASTUtil.renderNode(identChars, null, printer);
            return;
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            Tree node = ast.getChild(i);
            if (node == null) {
                throw new NullPointerException("Null AST node");
            }
            ASTUtil.renderNode(identChars, node, printer);
            ASTUtil.dumpAST(printer, node, ident + 2);
        }
    }

    public static void printTokens(CommonTokenStream tokens) {
        if (log.isDebugEnabled()) {
            List tokenList = tokens.getTokens();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            for (int i = 0; i < tokens.size(); ++i) {
                Token t = (Token)tokenList.get(i);
                String text = t.getText();
                if (text.trim().length() == 0) {
                    printer.print("'" + text + "'");
                } else {
                    printer.print(text);
                }
                printer.print('[');
                printer.print(t.getType());
                printer.print(']');
                printer.print(" ");
            }
            printer.println();
            log.debug((Object)("Tokens: " + writer.toString()));
        }
    }

    private static void renderNode(char[] ident, Tree node, PrintWriter printer) {
        printer.print(ident);
        if (node == null) {
            printer.print("NULL NODE");
        } else {
            printer.print(node.getText());
            printer.print(" [");
            printer.print(node.getType());
            printer.print("]");
            if (node.getText() == null) {
                printer.print(" (null value in text)");
            } else if (node.getText().contains("\\")) {
                int count = 0;
                for (int i = 0; i < node.getText().length(); ++i) {
                    if (node.getText().charAt(i) != '\\') continue;
                    ++count;
                }
                printer.print(" (" + count + " backlashes)");
            }
        }
        printer.println();
    }
}

