/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.annotation;

import com.espertech.esper.client.annotation.Audit;
import java.lang.annotation.Annotation;

public enum AuditEnum {
    PROPERTY("PROPERTY"),
    EXPRESSION("EXPRESSION"),
    EXPRESSION_NESTED("EXPRESSION-NESTED"),
    EXPRDEF("EXPRDEF"),
    VIEW("VIEW"),
    PATTERN("PATTERN"),
    PATTERNINSTANCES("PATTERN-INSTANCES"),
    STREAM("STREAM"),
    SCHEDULE("SCHEDULE"),
    INSERT("INSERT"),
    DATAFLOW_SOURCE("DATAFLOW-SOURCE"),
    DATAFLOW_OP("DATAFLOW-OP"),
    DATAFLOW_TRANSITION("DATAFLOW-TRANSITION");

    private final String value;
    private final String prettyPrintText;

    private AuditEnum(String value) {
        this.value = value.toUpperCase();
        this.prettyPrintText = value.toLowerCase();
    }

    public String getValue() {
        return this.value;
    }

    public String getPrettyPrintText() {
        return this.prettyPrintText;
    }

    public Audit getAudit(Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Audit)) continue;
            Audit auditAnnotation = (Audit)annotation;
            String auditAnnoValue = auditAnnotation.value();
            if (auditAnnoValue.equals("*")) {
                return auditAnnotation;
            }
            boolean isListed = AuditEnum.isListed(auditAnnoValue, this.value);
            if (!isListed) continue;
            return auditAnnotation;
        }
        return null;
    }

    private static boolean isListed(String list, String lookedForValue) {
        String[] items;
        if (list == null) {
            return false;
        }
        lookedForValue = lookedForValue.trim().toUpperCase();
        if ((list = list.trim().toUpperCase()).toUpperCase().equals(lookedForValue)) {
            return true;
        }
        for (String item : items = list.split(",")) {
            String listItem = item.trim().toUpperCase();
            if (!listItem.equals(lookedForValue)) continue;
            return true;
        }
        return false;
    }
}

