/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.metric;

import com.espertech.esper.client.metric.MetricEvent;
import java.util.concurrent.atomic.AtomicLong;

public class StatementMetric
extends MetricEvent {
    private long timestamp;
    private String statementName;
    private AtomicLong cpuTime;
    private AtomicLong wallTime;
    private AtomicLong numInput;
    private AtomicLong numOutputRStream;
    private AtomicLong numOutputIStream;

    public StatementMetric(String engineURI, String statementName) {
        super(engineURI);
        this.statementName = statementName;
        this.cpuTime = new AtomicLong();
        this.wallTime = new AtomicLong();
        this.numOutputIStream = new AtomicLong();
        this.numOutputRStream = new AtomicLong();
        this.numInput = new AtomicLong();
    }

    public String getStatementName() {
        return this.statementName;
    }

    public long getCpuTime() {
        return this.cpuTime.get();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void addCPUTime(long delta) {
        this.cpuTime.addAndGet(delta);
    }

    public void addWallTime(long wall) {
        this.wallTime.addAndGet(wall);
    }

    public long getWallTime() {
        return this.wallTime.get();
    }

    public long getNumOutputRStream() {
        return this.numOutputRStream.get();
    }

    public long getNumOutputIStream() {
        return this.numOutputIStream.get();
    }

    public void addNumOutputIStream(int numIStream) {
        this.numOutputIStream.addAndGet(numIStream);
    }

    public void addNumOutputRStream(int numRStream) {
        this.numOutputRStream.addAndGet(numRStream);
    }

    public long getNumInput() {
        return this.numInput.get();
    }

    public void addNumInput(long numInputAdd) {
        this.numInput.addAndGet(numInputAdd);
    }
}

