/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.AnnotationAttribute;
import com.espertech.esper.client.soda.EPStatementFormatter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class AnnotationPart
implements Serializable {
    private static final long serialVersionUID = 2404842336644400196L;
    private String treeObjectName;
    private String name;
    private List<AnnotationAttribute> attributes = new ArrayList<AnnotationAttribute>();

    public AnnotationPart() {
    }

    public void copy(AnnotationPart other) {
        this.name = other.name;
        this.attributes = other.attributes;
    }

    public String getTreeObjectName() {
        return this.treeObjectName;
    }

    public void setTreeObjectName(String treeObjectName) {
        this.treeObjectName = treeObjectName;
    }

    public AnnotationPart(String name) {
        this.name = name;
    }

    public AnnotationPart(String name, List<AnnotationAttribute> attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addValue(Object value) {
        this.attributes.add(new AnnotationAttribute("value", value));
    }

    public void addValue(String name, Object value) {
        this.attributes.add(new AnnotationAttribute(name, value));
    }

    public List<AnnotationAttribute> getAttributes() {
        return this.attributes;
    }

    public static void toEPL(StringWriter writer, List<AnnotationPart> annotations, EPStatementFormatter formatter) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        for (AnnotationPart part : annotations) {
            if (part.getName() == null) continue;
            formatter.beginAnnotation(writer);
            part.toEPL(writer);
        }
    }

    public void toEPL(StringWriter writer) {
        writer.append("@");
        writer.append(this.name);
        if (this.attributes.isEmpty()) {
            return;
        }
        if (this.attributes.size() == 1 && (this.attributes.get(0).getName() == null || this.attributes.get(0).getName().equals("value"))) {
            writer.append("(");
            this.toEPL(writer, this.attributes.get(0).getValue());
            writer.append(")");
            return;
        }
        String delimiter = "";
        writer.append("(");
        for (AnnotationAttribute attribute : this.attributes) {
            if (attribute.getValue() == null) {
                return;
            }
            writer.append(delimiter);
            writer.append(attribute.getName());
            writer.append("=");
            this.toEPL(writer, attribute.getValue());
            delimiter = ",";
        }
        writer.append(")");
    }

    private void toEPL(StringWriter writer, Object second) {
        if (second instanceof String) {
            writer.append("'");
            writer.append(second.toString());
            writer.append("'");
        } else if (second instanceof AnnotationPart) {
            ((AnnotationPart)second).toEPL(writer);
        } else if (second.getClass().isEnum()) {
            writer.append(second.getClass().getName());
            writer.append(".");
            writer.append(second.toString());
        } else if (second.getClass().isArray()) {
            String delimiter = "";
            writer.append("{");
            for (int i = 0; i < Array.getLength(second); ++i) {
                writer.append(delimiter);
                this.toEPL(writer, Array.get(second, i));
                delimiter = ",";
            }
            writer.append("}");
        } else {
            writer.append(second.toString());
        }
    }
}

