/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class DotExpressionItem
implements Serializable {
    private static final long serialVersionUID = 4189610785425631920L;
    private String name;
    private List<Expression> parameters;
    private boolean property;

    public DotExpressionItem() {
    }

    public DotExpressionItem(String name, List<Expression> parameters, boolean isProperty) {
        this.name = name;
        this.property = isProperty;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Expression> parameters) {
        this.parameters = parameters;
    }

    public boolean isProperty() {
        return this.property;
    }

    public void setProperty(boolean property) {
        this.property = property;
    }

    protected static void render(List<DotExpressionItem> chain, StringWriter writer, boolean prefixDot) {
        String delimiterOuter = prefixDot ? "." : "";
        for (DotExpressionItem item : chain) {
            writer.write(delimiterOuter);
            writer.write(item.name);
            if (!item.isProperty() || !item.parameters.isEmpty()) {
                writer.write("(");
                if (!item.parameters.isEmpty()) {
                    String delimiter = "";
                    for (Expression param : item.parameters) {
                        writer.write(delimiter);
                        delimiter = ", ";
                        param.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                    }
                }
                writer.write(")");
            }
            delimiterOuter = ".";
        }
    }
}

