/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class ExpressionDeclaration
implements Serializable {
    private static final long serialVersionUID = 8445897497101986441L;
    private String name;
    private List<String> parameterNames;
    private Expression expression;

    public ExpressionDeclaration() {
    }

    public ExpressionDeclaration(String name, List<String> parameterNames, Expression expression) {
        this.name = name;
        this.parameterNames = parameterNames;
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public static void toEPL(StringWriter writer, List<ExpressionDeclaration> expressionDeclarations, EPStatementFormatter formatter) {
        if (expressionDeclarations == null || expressionDeclarations.isEmpty()) {
            return;
        }
        for (ExpressionDeclaration part : expressionDeclarations) {
            if (part.getName() == null) continue;
            formatter.beginExpressionDecl(writer);
            part.toEPL(writer);
        }
    }

    public void toEPL(StringWriter writer) {
        writer.append("expression ");
        writer.append(this.name);
        writer.append(" {");
        if (this.parameterNames != null && this.parameterNames.size() == 1) {
            writer.append(this.parameterNames.get(0));
        } else if (this.parameterNames != null && !this.parameterNames.isEmpty()) {
            String delimiter = "";
            writer.append("(");
            for (String name : this.parameterNames) {
                writer.append(delimiter);
                writer.append(name);
                delimiter = ", ";
            }
            writer.append(")");
        }
        if (this.parameterNames != null && !this.parameterNames.isEmpty()) {
            writer.append(" => ");
        }
        if (this.expression != null) {
            this.expression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.append("}");
    }
}

