/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OnClause;
import com.espertech.esper.client.soda.OnMergeMatchItem;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OnMergeClause
extends OnClause {
    private static final long serialVersionUID = 0L;
    private String windowName;
    private String optionalAsName;
    private List<OnMergeMatchItem> matchItems;

    public OnMergeClause() {
        this.matchItems = new ArrayList<OnMergeMatchItem>();
    }

    public static OnMergeClause create(String windowName, String optionalAsName, List<OnMergeMatchItem> matchItems) {
        return new OnMergeClause(windowName, optionalAsName, matchItems);
    }

    public OnMergeClause(String windowName, String optionalAsName, List<OnMergeMatchItem> matchItems) {
        this.windowName = windowName;
        this.optionalAsName = optionalAsName;
        this.matchItems = matchItems;
    }

    public void toEPL(StringWriter writer, Expression optionalWhereClause, EPStatementFormatter formatter) {
        formatter.beginMerge(writer);
        writer.write("merge ");
        writer.write(this.windowName);
        if (this.optionalAsName != null) {
            writer.write(" as ");
            writer.write(this.optionalAsName);
        }
        if (optionalWhereClause != null) {
            formatter.beginMergeWhere(writer);
            writer.write("where ");
            optionalWhereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        for (OnMergeMatchItem item : this.matchItems) {
            item.toEPL(writer, formatter);
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public String getOptionalAsName() {
        return this.optionalAsName;
    }

    public void setOptionalAsName(String optionalAsName) {
        this.optionalAsName = optionalAsName;
    }

    public OnMergeClause addAction(OnMergeMatchItem action) {
        this.matchItems.add(action);
        return this;
    }

    public List<OnMergeMatchItem> getMatchItems() {
        return this.matchItems;
    }

    public void setMatchItems(List<OnMergeMatchItem> matchItems) {
        this.matchItems = matchItems;
    }
}

