/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternExprBase;
import com.espertech.esper.client.soda.PatternExprPrecedenceEnum;
import java.io.StringWriter;

public class PatternMatchUntilExpr
extends PatternExprBase {
    private Expression low;
    private Expression high;
    private static final long serialVersionUID = -427123340111619016L;

    public PatternMatchUntilExpr() {
    }

    public PatternMatchUntilExpr(Expression low, Expression high) {
        this.low = low;
        this.high = high;
    }

    public PatternMatchUntilExpr(Expression low, Expression high, PatternExpr match, PatternExpr until) {
        this.low = low;
        this.high = high;
        this.addChild(match);
        this.addChild(until);
    }

    public Expression getLow() {
        return this.low;
    }

    public void setLow(Expression low) {
        this.low = low;
    }

    public Expression getHigh() {
        return this.high;
    }

    public void setHigh(Expression high) {
        this.high = high;
    }

    @Override
    public PatternExprPrecedenceEnum getPrecedence() {
        return PatternExprPrecedenceEnum.MATCH_UNTIL;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, EPStatementFormatter formatter) {
        if (this.low != null || this.high != null) {
            writer.write("[");
            if (this.low != null && this.high != null) {
                if (this.low == this.high) {
                    this.low.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                } else {
                    this.low.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                    writer.write(":");
                    this.high.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                }
            } else if (this.low != null) {
                this.low.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                writer.write(":");
            } else {
                writer.write(":");
                this.high.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            }
            writer.write("] ");
        }
        PatternExprPrecedenceEnum precedence = this.getPrecedence();
        if (this.getChildren().get(0) instanceof PatternMatchUntilExpr) {
            precedence = PatternExprPrecedenceEnum.MAXIMIM;
        }
        this.getChildren().get(0).toEPL(writer, precedence, formatter);
        if (this.getChildren().size() > 1) {
            writer.write(" until ");
            this.getChildren().get(1).toEPL(writer, this.getPrecedence(), formatter);
        }
    }
}

