/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.util;

import com.espertech.esper.client.EventType;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Method;
import java.util.Collection;

public class ExpressionReturnType {
    private final Class singleValueType;
    private final Class componentType;
    private final EventType singleEventEventType;
    private final EventType collOfEventEventType;

    private ExpressionReturnType(Class singleValueType, Class componentType, EventType singleEventEventType, EventType collOfEventEventType) {
        this.singleValueType = singleValueType;
        this.componentType = componentType;
        this.singleEventEventType = singleEventEventType;
        this.collOfEventEventType = collOfEventEventType;
    }

    public static ExpressionReturnType array(Class arrayComponentType) {
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("Invalid null array component type");
        }
        return new ExpressionReturnType(JavaClassHelper.getArrayType(arrayComponentType), arrayComponentType, null, null);
    }

    public static ExpressionReturnType singleValue(Class singleValueType) {
        return new ExpressionReturnType(singleValueType, null, null, null);
    }

    public static ExpressionReturnType collectionOfSingleValue(Class collectionComponentType) {
        if (collectionComponentType == null) {
            throw new IllegalArgumentException("Invalid null collection component type");
        }
        return new ExpressionReturnType(Collection.class, collectionComponentType, null, null);
    }

    public static ExpressionReturnType collectionOfEvents(EventType eventTypeOfCollectionEvents) {
        if (eventTypeOfCollectionEvents == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new ExpressionReturnType(JavaClassHelper.getArrayType(eventTypeOfCollectionEvents.getUnderlyingType()), null, null, eventTypeOfCollectionEvents);
    }

    public static ExpressionReturnType singleEvent(EventType eventTypeOfSingleEvent) {
        if (eventTypeOfSingleEvent == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new ExpressionReturnType(eventTypeOfSingleEvent.getUnderlyingType(), null, eventTypeOfSingleEvent, null);
    }

    public Class getSingleValueType() {
        return this.singleValueType;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public EventType getSingleEventEventType() {
        return this.singleEventEventType;
    }

    public EventType getCollOfEventEventType() {
        return this.collOfEventEventType;
    }

    public boolean isSingleValueNonNull() {
        return this.collOfEventEventType == null && this.singleEventEventType == null && this.singleValueType != null;
    }

    public static ExpressionReturnType fromMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (JavaClassHelper.isImplementsInterface(returnType, Collection.class)) {
            Class componentType = JavaClassHelper.getGenericReturnType(method, true);
            return ExpressionReturnType.collectionOfSingleValue(componentType);
        }
        return ExpressionReturnType.singleValue(method.getReturnType());
    }

    public String toTypeDescriptive() {
        if (this.singleEventEventType != null) {
            return "event type '" + this.singleEventEventType.getName() + "'";
        }
        if (this.collOfEventEventType != null) {
            return "collection of events of type '" + this.collOfEventEventType.getName() + "'";
        }
        if (this.componentType != null && this.singleValueType == Collection.class) {
            return "collection of " + this.componentType.getSimpleName();
        }
        if (this.componentType != null) {
            return "array of " + JavaClassHelper.getClassNameFullyQualPretty(this.singleValueType);
        }
        if (this.singleValueType != null) {
            return "class " + JavaClassHelper.getClassNameFullyQualPretty(this.singleValueType);
        }
        return "an incompatible type";
    }
}

