/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IterablesArrayIterator
implements Iterator<EventBean> {
    private final Iterable<EventBean>[] array;
    private int index;
    private Iterator<EventBean> currentIterator;

    public IterablesArrayIterator(Iterable<EventBean>[] iterables) {
        this.array = iterables;
        this.nextIterable();
    }

    @Override
    public EventBean next() {
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        if (this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        this.nextIterable();
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        if (this.currentIterator.hasNext()) {
            return true;
        }
        this.nextIterable();
        return this.currentIterator != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void nextIterable() {
        while (this.index < this.array.length) {
            Iterable<EventBean> iterable = this.array[this.index];
            this.currentIterator = iterable.iterator();
            ++this.index;
            if (!this.currentIterator.hasNext()) continue;
            return;
        }
        this.currentIterator = null;
    }
}

