/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.Arrays;

public final class MultiKeyUntypedEventPair
implements MetaDefItem,
Serializable {
    private final transient Object[] keys;
    private transient EventBean eventBean = null;
    private final int hashCode;
    private static final long serialVersionUID = -3890626073105861216L;

    public MultiKeyUntypedEventPair(Object[] keys, EventBean eventBean) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        int total = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            total *= 31;
            total ^= keys[i].hashCode();
        }
        this.hashCode = total;
        this.keys = keys;
        this.eventBean = eventBean;
    }

    public EventBean getEventBean() {
        return this.eventBean;
    }

    public final int size() {
        return this.keys.length;
    }

    public final Object get(int index) {
        return this.keys[index];
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKeyUntypedEventPair) {
            MultiKeyUntypedEventPair otherKeys = (MultiKeyUntypedEventPair)other;
            return Arrays.equals(this.keys, otherKeys.keys);
        }
        return false;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "MultiKeyUntyped" + Arrays.asList(this.keys).toString();
    }
}

