/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;

public class RollingEventBuffer {
    private EventBean[] buffer;
    private int nextFreeIndex;

    public RollingEventBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Minimum buffer size is 1");
        }
        this.nextFreeIndex = 0;
        this.buffer = new EventBean[size];
    }

    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (int i = 0; i < events.length; ++i) {
            this.add(events[i]);
        }
    }

    public void add(EventBean theEvent) {
        this.buffer[this.nextFreeIndex] = theEvent;
        ++this.nextFreeIndex;
        if (this.nextFreeIndex == this.buffer.length) {
            this.nextFreeIndex = 0;
        }
    }

    public EventBean get(int index) {
        if (index >= this.buffer.length) {
            throw new IllegalArgumentException("Invalid index " + index + " for size " + this.buffer.length);
        }
        int newest = this.nextFreeIndex - 1;
        int relative = newest - index;
        if (relative < 0) {
            relative += this.buffer.length;
        }
        return this.buffer[relative];
    }

    public int getSize() {
        return this.buffer.length;
    }

    public EventBean[] getBuffer() {
        return this.buffer;
    }

    public int getNextFreeIndex() {
        return this.nextFreeIndex;
    }

    public void setBuffer(EventBean[] buffer) {
        this.buffer = buffer;
    }

    public void setNextFreeIndex(int nextFreeIndex) {
        this.nextFreeIndex = nextFreeIndex;
    }
}

