/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.activator;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.activator.ViewableActivatorFilterProxyStopCallback;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.ZeroDepthStream;
import com.espertech.esper.view.stream.EventStreamProxy;
import java.lang.annotation.Annotation;
import java.util.Collection;

public class ViewableActivatorFilterProxy
implements ViewableActivator {
    private final EPServicesContext services;
    private final FilterSpecCompiled filterSpec;
    private final Annotation[] annotations;
    private final boolean isSubSelect;

    public ViewableActivatorFilterProxy(EPServicesContext services, FilterSpecCompiled filterSpec, Annotation[] annotations, boolean subSelect) {
        this.services = services;
        this.filterSpec = filterSpec;
        this.annotations = annotations;
        this.isSubSelect = subSelect;
    }

    @Override
    public ViewableActivationResult activate(final AgentInstanceContext agentInstanceContext, boolean isSubselect, boolean isRecoveringResilient) {
        EventStream inputStream;
        EventType resultEventType = this.filterSpec.getResultEventType();
        ZeroDepthStream zeroDepthStream = new ZeroDepthStream(resultEventType);
        final EventStream eventStream = inputStream = EventStreamProxy.getAuditProxy(agentInstanceContext.getStatementContext().getEngineURI(), agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementHandle().getStatementName(), this.annotations, this.filterSpec, zeroDepthStream);
        final String statementId = agentInstanceContext.getStatementContext().getStatementId();
        FilterHandleCallback filterCallback = this.filterSpec.getOptionalPropertyEvaluator() != null ? new FilterHandleCallback(){

            @Override
            public String getStatementId() {
                return statementId;
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                EventBean[] result = ViewableActivatorFilterProxy.this.filterSpec.getOptionalPropertyEvaluator().getProperty(theEvent, agentInstanceContext);
                if (result == null) {
                    return;
                }
                eventStream.insert(result);
            }

            @Override
            public boolean isSubSelect() {
                return ViewableActivatorFilterProxy.this.isSubSelect;
            }
        } : new FilterHandleCallback(){

            @Override
            public String getStatementId() {
                return statementId;
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                eventStream.insert(theEvent);
            }

            @Override
            public boolean isSubSelect() {
                return ViewableActivatorFilterProxy.this.isSubSelect;
            }
        };
        EPStatementHandleCallback filterHandle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), filterCallback);
        FilterValueSetParam[] addendum = null;
        if (agentInstanceContext.getAgentInstanceFilterProxy() != null) {
            addendum = agentInstanceContext.getAgentInstanceFilterProxy().getAddendumFilters(this.filterSpec);
        }
        FilterValueSet filterValueSet = this.filterSpec.getValueSet(null, agentInstanceContext, addendum);
        this.services.getFilterService().add(filterValueSet, filterHandle);
        ViewableActivatorFilterProxyStopCallback stopCallback = new ViewableActivatorFilterProxyStopCallback(this, filterHandle);
        return new ViewableActivationResult(inputStream, stopCallback, null, null);
    }

    public EPServicesContext getServices() {
        return this.services;
    }
}

