/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.activator;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.EvalRootState;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternMatchCallback;
import com.espertech.esper.view.ZeroDepthStream;
import java.util.Map;

public class ViewableActivatorPattern
implements ViewableActivator {
    private final PatternContext patternContext;
    private final EvalRootFactoryNode rootFactoryNode;
    private final EventType eventType;
    private final boolean hasConsumingFilter;

    public ViewableActivatorPattern(PatternContext patternContext, EvalRootFactoryNode rootFactoryNode, EventType eventType, boolean hasConsumingFilter) {
        this.patternContext = patternContext;
        this.rootFactoryNode = rootFactoryNode;
        this.eventType = eventType;
        this.hasConsumingFilter = hasConsumingFilter;
    }

    @Override
    public ViewableActivationResult activate(AgentInstanceContext agentInstanceContext, boolean isSubselect, boolean isRecoveringResilient) {
        PatternAgentInstanceContext patternAgentInstanceContext = agentInstanceContext.getStatementContext().getPatternContextFactory().createPatternAgentContext(this.patternContext, agentInstanceContext, this.hasConsumingFilter);
        EvalRootNode rootNode = EvalNodeUtil.makeRootNodeFromFactory(this.rootFactoryNode, patternAgentInstanceContext);
        final ZeroDepthStream sourceEventStream = new ZeroDepthStream(this.eventType);
        final StatementContext statementContext = this.patternContext.getStatementContext();
        PatternMatchCallback callback = new PatternMatchCallback(){

            @Override
            public void matchFound(Map<String, Object> matchEvent) {
                EventBean compositeEvent = statementContext.getEventAdapterService().adapterForTypedMap(matchEvent, ViewableActivatorPattern.this.eventType);
                sourceEventStream.insert(compositeEvent);
            }
        };
        EvalRootState rootState = rootNode.start(callback, this.patternContext, isRecoveringResilient);
        return new ViewableActivationResult(sourceEventStream, rootState, null, rootState);
    }
}

