/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadSelect;
import com.espertech.esper.core.context.factory.StatementAgentInstancePreload;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrior;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperUtil;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateVerified;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.join.base.JoinExecStrategyDispatchable;
import com.espertech.esper.epl.join.base.JoinExecutionStrategyImpl;
import com.espertech.esper.epl.join.base.JoinPreloadMethod;
import com.espertech.esper.epl.join.base.JoinPreloadMethodImpl;
import com.espertech.esper.epl.join.base.JoinPreloadMethodNull;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetFilter;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.view.FilterExprView;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.pattern.EvalRootState;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewServiceCreateResult;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.internal.BufferView;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import com.espertech.esper.view.internal.SingleStreamDispatchView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceFactorySelect
implements StatementAgentInstanceFactory {
    private static final Log log = LogFactory.getLog(StatementAgentInstanceFactorySelect.class);
    private final int numStreams;
    private final ViewableActivator[] eventStreamParentViewableActivators;
    private final StatementContext statementContext;
    private final StatementSpecCompiled statementSpec;
    private final EPServicesContext services;
    private final StreamTypeService typeService;
    private final ViewFactoryChain[] unmaterializedViewChain;
    private final ResultSetProcessorFactoryDesc resultSetProcessorFactoryDesc;
    private final StreamJoinAnalysisResult joinAnalysisResult;
    private final JoinSetComposerPrototype joinSetComposerPrototype;
    private final SubSelectStrategyCollection subSelectStrategyCollection;
    private final ViewResourceDelegateVerified viewResourceDelegate;
    private final OutputProcessViewFactory outputProcessViewFactory;

    public StatementAgentInstanceFactorySelect(int numStreams, ViewableActivator[] eventStreamParentViewableActivators, StatementContext statementContext, StatementSpecCompiled statementSpec, EPServicesContext services, StreamTypeService typeService, ViewFactoryChain[] unmaterializedViewChain, ResultSetProcessorFactoryDesc resultSetProcessorFactoryDesc, StreamJoinAnalysisResult joinAnalysisResult, boolean recoveringResilient, JoinSetComposerPrototype joinSetComposerPrototype, SubSelectStrategyCollection subSelectStrategyCollection, ViewResourceDelegateVerified viewResourceDelegate, OutputProcessViewFactory outputProcessViewFactory) {
        this.numStreams = numStreams;
        this.eventStreamParentViewableActivators = eventStreamParentViewableActivators;
        this.statementContext = statementContext;
        this.statementSpec = statementSpec;
        this.services = services;
        this.typeService = typeService;
        this.unmaterializedViewChain = unmaterializedViewChain;
        this.resultSetProcessorFactoryDesc = resultSetProcessorFactoryDesc;
        this.joinAnalysisResult = joinAnalysisResult;
        this.joinSetComposerPrototype = joinSetComposerPrototype;
        this.subSelectStrategyCollection = subSelectStrategyCollection;
        this.viewResourceDelegate = viewResourceDelegate;
        this.outputProcessViewFactory = outputProcessViewFactory;
    }

    @Override
    public StatementAgentInstanceFactorySelectResult newContext(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        Viewable finalView;
        AggregationService aggregationService;
        Map<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategies;
        Viewable[] topViews;
        Map<ExprPreviousNode, ExprPreviousEvalStrategy> previousNodeStrategies;
        Map<ExprPriorNode, ExprPriorEvalStrategy> priorNodeStrategies;
        EvalRootState[] patternRoots;
        Viewable[] eventStreamParentViewable;
        if (this.services.getSchedulableAgentInstanceDirectory() != null) {
            this.services.getSchedulableAgentInstanceDirectory().add(agentInstanceContext.getEpStatementAgentInstanceHandle());
        }
        ArrayList<StopCallback> stopCallbacks = new ArrayList<StopCallback>(2);
        ViewableActivationResult[] viewableActivationResult = new ViewableActivationResult[this.eventStreamParentViewableActivators.length];
        ArrayList<StatementAgentInstancePreload> preloadList = new ArrayList<StatementAgentInstancePreload>();
        StatementAgentInstancePostLoadSelect postLoadJoin = null;
        try {
            JoinPreloadMethod joinPreloadMethod;
            int i;
            eventStreamParentViewable = new Viewable[this.numStreams];
            patternRoots = new EvalRootState[this.numStreams];
            for (int stream = 0; stream < this.eventStreamParentViewableActivators.length; ++stream) {
                ViewableActivationResult activationResult;
                viewableActivationResult[stream] = activationResult = this.eventStreamParentViewableActivators[stream].activate(agentInstanceContext, false, isRecoveringResilient);
                stopCallbacks.add(activationResult.getStopCallback());
                eventStreamParentViewable[stream] = activationResult.getViewable();
                patternRoots[stream] = activationResult.getOptionalPatternRoot();
                if (activationResult.getOptionalLock() == null) continue;
                agentInstanceContext.getEpStatementAgentInstanceHandle().setStatementAgentInstanceLock(activationResult.getOptionalLock());
                this.statementContext.setDefaultAgentInstanceLock(activationResult.getOptionalLock());
            }
            List[] viewFactoryChains = new List[this.numStreams];
            for (int i2 = 0; i2 < this.numStreams; ++i2) {
                boolean hasPrior;
                List<ViewFactory> viewFactoryChain = this.unmaterializedViewChain[i2].getViewFactoryChain();
                boolean bl = hasPrior = this.viewResourceDelegate.getPerStream()[i2].getPriorRequests() != null && !this.viewResourceDelegate.getPerStream()[i2].getPriorRequests().isEmpty();
                if (hasPrior) {
                    PriorEventViewFactory priorEventViewFactory = EPStatementStartMethodHelperPrior.getPriorEventViewFactory(agentInstanceContext.getStatementContext(), i2, viewFactoryChain.size() + 1, viewFactoryChain.isEmpty());
                    viewFactoryChain = new ArrayList<ViewFactory>(viewFactoryChain);
                    viewFactoryChain.add(priorEventViewFactory);
                }
                viewFactoryChains[i2] = viewFactoryChain;
            }
            AgentInstanceViewFactoryChainContext[] viewFactoryChainContexts = new AgentInstanceViewFactoryChainContext[this.numStreams];
            for (i = 0; i < this.numStreams; ++i) {
                viewFactoryChainContexts[i] = AgentInstanceViewFactoryChainContext.create(viewFactoryChains[i], agentInstanceContext, this.viewResourceDelegate.getPerStream()[i]);
            }
            priorNodeStrategies = EPStatementStartMethodHelperPrior.compilePriorNodeStrategies(this.viewResourceDelegate, viewFactoryChainContexts);
            previousNodeStrategies = EPStatementStartMethodHelperPrevious.compilePreviousNodeStrategies(this.viewResourceDelegate, viewFactoryChainContexts);
            Viewable[] streamViews = new Viewable[this.numStreams];
            topViews = new Viewable[this.numStreams];
            for (i = 0; i < this.numStreams; ++i) {
                boolean hasPreviousNode = this.viewResourceDelegate.getPerStream()[i].getPreviousRequests() != null && !this.viewResourceDelegate.getPerStream()[i].getPreviousRequests().isEmpty();
                ViewServiceCreateResult createResult = this.services.getViewService().createViews(eventStreamParentViewable[i], viewFactoryChains[i], viewFactoryChainContexts[i], hasPreviousNode);
                topViews[i] = createResult.getTopViewable();
                streamViews[i] = createResult.getFinalViewable();
            }
            subselectStrategies = EPStatementStartMethodHelperSubselect.startSubselects(this.services, this.subSelectStrategyCollection, agentInstanceContext, stopCallbacks);
            Pair<ResultSetProcessor, AggregationService> processorPair = EPStatementStartMethodHelperUtil.startResultSetAndAggregation(this.resultSetProcessorFactoryDesc, agentInstanceContext);
            final ResultSetProcessor resultSetProcessor = processorPair.getFirst();
            aggregationService = processorPair.getSecond();
            JoinSetComposerDesc joinSetComposer = null;
            if (streamViews.length == 1) {
                finalView = this.handleSimpleSelect(streamViews[0], resultSetProcessor, agentInstanceContext);
                joinPreloadMethod = null;
            } else {
                JoinPlanResult joinPlanResult = this.handleJoin(this.typeService.getStreamNames(), streamViews, resultSetProcessor, agentInstanceContext, stopCallbacks, this.joinAnalysisResult);
                finalView = joinPlanResult.getViewable();
                joinPreloadMethod = joinPlanResult.getPreloadMethod();
                joinSetComposer = joinPlanResult.getJoinSetComposerDesc();
            }
            boolean hasNamedWindow = false;
            FilterSpecCompiled[] namedWindowPostloadFilters = new FilterSpecCompiled[this.statementSpec.getStreamSpecs().length];
            NamedWindowTailViewInstance[] namedWindowTailViews = new NamedWindowTailViewInstance[this.statementSpec.getStreamSpecs().length];
            List[] namedWindowFilters = new List[this.statementSpec.getStreamSpecs().length];
            for (int i3 = 0; i3 < this.statementSpec.getStreamSpecs().length; ++i3) {
                final int streamNum = i3;
                StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs()[i3];
                if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
                hasNamedWindow = true;
                final NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(agentInstanceContext);
                if (processorInstance != null) {
                    boolean preload;
                    NamedWindowTailViewInstance consumerView;
                    namedWindowTailViews[i3] = consumerView = processorInstance.getTailViewInstance();
                    final NamedWindowConsumerView view = (NamedWindowConsumerView)viewableActivationResult[i3].getViewable();
                    if (!namedSpec.getFilterExpressions().isEmpty()) {
                        namedWindowFilters[streamNum] = namedSpec.getFilterExpressions();
                        try {
                            StreamTypeServiceImpl types = new StreamTypeServiceImpl(consumerView.getEventType(), consumerView.getEventType().getName(), false, this.services.getEngineURI());
                            LinkedHashMap<String, Pair<EventType, String>> tagged = new LinkedHashMap<String, Pair<EventType, String>>();
                            namedWindowPostloadFilters[i3] = FilterSpecCompiler.makeFilterSpec(types.getEventTypes()[0], types.getStreamNames()[0], namedSpec.getFilterExpressions(), null, tagged, tagged, types, null, this.statementContext, Collections.singleton(0));
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Unexpected exception analyzing filter paths: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    Iterator<EventBean> consumerViewIterator = consumerView.iterator();
                    boolean bl = preload = !consumerView.getTailView().isParentBatchWindow() && consumerViewIterator.hasNext();
                    if (preload && isRecoveringResilient && this.numStreams < 2) {
                        preload = false;
                    }
                    if (preload) {
                        final boolean yesRecoveringResilient = isRecoveringResilient;
                        final FilterSpecCompiled preloadFilterSpec = namedWindowPostloadFilters[i3];
                        preloadList.add(new StatementAgentInstancePreload(){

                            @Override
                            public void executePreload() {
                                Collection<EventBean> snapshot = consumerView.snapshotNoLock(preloadFilterSpec, StatementAgentInstanceFactorySelect.this.statementContext.getAnnotations());
                                ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>(snapshot.size());
                                ExprNodeUtility.applyFilterExpressionsIterable(snapshot, namedSpec.getFilterExpressions(), agentInstanceContext, eventsInWindow);
                                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                                view.update(newEvents, null);
                                if (!yesRecoveringResilient && joinPreloadMethod != null && !joinPreloadMethod.isPreloading() && agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                                    agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute(agentInstanceContext);
                                }
                            }
                        });
                    }
                } else {
                    log.info((Object)("Named window access is out-of-context, the named window '" + namedSpec.getWindowName() + "' has been declared for a different context then the current statement, the aggregation and join state will not be initialized for statement expression [" + this.statementContext.getExpression() + "]"));
                }
                preloadList.add(new StatementAgentInstancePreload(){

                    @Override
                    public void executePreload() {
                        if (joinPreloadMethod != null) {
                            joinPreloadMethod.preloadFromBuffer(streamNum);
                        } else if (agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                            agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute(agentInstanceContext);
                        }
                    }
                });
            }
            if (hasNamedWindow && joinPreloadMethod != null && !isRecoveringResilient && this.resultSetProcessorFactoryDesc.getResultSetProcessorFactory().hasAggregation()) {
                preloadList.add(new StatementAgentInstancePreload(){

                    @Override
                    public void executePreload() {
                        joinPreloadMethod.preloadAggregation(resultSetProcessor);
                    }
                });
            }
            if (isRecoveringResilient) {
                postLoadJoin = new StatementAgentInstancePostLoadSelect(streamViews, joinSetComposer, namedWindowTailViews, namedWindowPostloadFilters, namedWindowFilters, this.statementContext.getAnnotations(), agentInstanceContext);
            }
        }
        catch (RuntimeException ex) {
            StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
            StatementAgentInstanceUtil.stopSafe(stopCallback, this.statementContext);
            throw ex;
        }
        StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
        return new StatementAgentInstanceFactorySelectResult(finalView, stopCallback, agentInstanceContext, aggregationService, subselectStrategies, priorNodeStrategies, previousNodeStrategies, preloadList, patternRoots, postLoadJoin, topViews, eventStreamParentViewable);
    }

    private Viewable handleSimpleSelect(Viewable view, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        Viewable finalView = view;
        if (this.statementSpec.getFilterRootNode() != null) {
            FilterExprView filterView = new FilterExprView(this.statementSpec.getFilterRootNode().getExprEvaluator(), agentInstanceContext);
            finalView.addView(filterView);
            finalView = filterView;
        }
        if (this.statementSpec.getOrderByList().length > 0 && this.statementSpec.getOutputLimitSpec() == null) {
            SingleStreamDispatchView bf = new SingleStreamDispatchView();
            agentInstanceContext.getEpStatementAgentInstanceHandle().setOptionalDispatchable(bf);
            finalView.addView(bf);
            finalView = bf;
        }
        OutputProcessViewBase selectView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        finalView.addView(selectView);
        finalView = selectView;
        return finalView;
    }

    private JoinPlanResult handleJoin(String[] streamNames, Viewable[] streamViews, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbacks, StreamJoinAnalysisResult joinAnalysisResult) {
        final JoinSetComposerDesc joinSetComposerDesc = this.joinSetComposerPrototype.create(streamViews, false);
        stopCallbacks.add(new StopCallback(){

            @Override
            public void stop() {
                joinSetComposerDesc.getJoinSetComposer().destroy();
            }
        });
        JoinSetFilter filter = new JoinSetFilter(joinSetComposerDesc.getPostJoinFilterEvaluator());
        OutputProcessViewBase indicatorView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        JoinExecutionStrategyImpl execution = new JoinExecutionStrategyImpl(joinSetComposerDesc.getJoinSetComposer(), filter, indicatorView, agentInstanceContext);
        indicatorView.setJoinExecutionStrategy(execution);
        JoinExecStrategyDispatchable joinStatementDispatch = new JoinExecStrategyDispatchable(execution, this.statementSpec.getStreamSpecs().length);
        agentInstanceContext.getEpStatementAgentInstanceHandle().setOptionalDispatchable(joinStatementDispatch);
        JoinPreloadMethod preloadMethod = joinAnalysisResult.getUnidirectionalStreamNumber() >= 0 ? new JoinPreloadMethodNull() : new JoinPreloadMethodImpl(streamNames.length, joinSetComposerDesc.getJoinSetComposer());
        for (int i = 0; i < this.statementSpec.getStreamSpecs().length; ++i) {
            BufferView buffer = new BufferView(i);
            streamViews[i].addView(buffer);
            buffer.setObserver(joinStatementDispatch);
            preloadMethod.setBuffer(buffer, i);
        }
        return new JoinPlanResult(indicatorView, preloadMethod, joinSetComposerDesc);
    }

    private static class JoinPlanResult {
        private final Viewable viewable;
        private final JoinPreloadMethod preloadMethod;
        private final JoinSetComposerDesc joinSetComposerDesc;

        private JoinPlanResult(Viewable viewable, JoinPreloadMethod preloadMethod, JoinSetComposerDesc joinSetComposerDesc) {
            this.viewable = viewable;
            this.preloadMethod = preloadMethod;
            this.joinSetComposerDesc = joinSetComposerDesc;
        }

        public Viewable getViewable() {
            return this.viewable;
        }

        public JoinPreloadMethod getPreloadMethod() {
            return this.preloadMethod;
        }

        public JoinSetComposerDesc getJoinSetComposerDesc() {
            return this.joinSetComposerDesc;
        }
    }
}

