/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierCategory;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerCategory;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryBase;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCacheFilters;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStateCache;
import com.espertech.esper.core.context.mgr.ContextStatePathValueBinding;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.util.CollectionUtil;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ContextControllerCategoryFactory
extends ContextControllerFactoryBase
implements ContextControllerFactory {
    private final ContextDetailCategory categorySpec;
    private final List<FilterSpecCompiled> filtersSpecsNestedContexts;
    private final ContextStateCache stateCache;
    private final ContextStatePathValueBinding binding;
    private Map<String, Object> contextBuiltinProps;

    public ContextControllerCategoryFactory(ContextControllerFactoryContext factoryContext, ContextDetailCategory categorySpec, List<FilterSpecCompiled> filtersSpecsNestedContexts, ContextStateCache stateCache) {
        super(factoryContext);
        this.categorySpec = categorySpec;
        this.filtersSpecsNestedContexts = filtersSpecsNestedContexts;
        this.stateCache = stateCache;
        this.binding = stateCache.getBinding(Integer.class);
    }

    public boolean hasFiltersSpecsNestedContexts() {
        return this.filtersSpecsNestedContexts != null && !this.filtersSpecsNestedContexts.isEmpty();
    }

    @Override
    public void validateFactory() throws ExprValidationException {
        if (this.categorySpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of partition items");
        }
        this.contextBuiltinProps = ContextPropertyEventType.getCategorizedType();
    }

    @Override
    public ContextControllerStatementCtxCache validateStatement(ContextControllerStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        this.validateStatementForContext(statement, streamAnalysis);
        return new ContextControllerStatementCtxCacheFilters(streamAnalysis.getFilters());
    }

    @Override
    public void populateFilterAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[]> filterAddendum, ContextControllerStatementDesc statement, Object categoryLabel, int contextId) {
        ContextControllerStatementCtxCacheFilters statementInfo = (ContextControllerStatementCtxCacheFilters)statement.getCaches()[this.factoryContext.getNestingLevel() - 1];
        ContextDetailCategoryItem category = this.findCategoryForName((String)categoryLabel);
        ContextControllerCategoryFactory.getAddendumFilters(filterAddendum, category, this.categorySpec, statementInfo.getFilterSpecs(), statement);
    }

    public void populateContextInternalFilterAddendums(ContextInternalFilterAddendum filterAddendum, Object categoryLabel) {
        ContextDetailCategoryItem category = this.findCategoryForName((String)categoryLabel);
        ContextControllerCategoryFactory.getAddendumFilters(filterAddendum.getFilterAddendum(), category, this.categorySpec, this.filtersSpecsNestedContexts, null);
    }

    @Override
    public FilterSpecLookupable getFilterLookupable(EventType eventType) {
        return null;
    }

    @Override
    public boolean isSingleInstanceContext() {
        return false;
    }

    @Override
    public StatementAIResourceRegistryFactory getStatementAIResourceRegistryFactory() {
        return new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
    }

    @Override
    public List<ContextDetailPartitionItem> getContextDetailPartitionItems() {
        return Collections.emptyList();
    }

    @Override
    public ContextDetail getContextDetail() {
        return this.categorySpec;
    }

    public ContextDetailCategory getCategorySpec() {
        return this.categorySpec;
    }

    @Override
    public Map<String, Object> getContextBuiltinProps() {
        return this.contextBuiltinProps;
    }

    public ContextStatePathValueBinding getBinding() {
        return this.binding;
    }

    @Override
    public ContextStateCache getStateCache() {
        return this.stateCache;
    }

    @Override
    public ContextController createNoCallback(int pathId, ContextControllerLifecycleCallback callback) {
        return new ContextControllerCategory(pathId, callback, this);
    }

    @Override
    public ContextPartitionIdentifier keyPayloadToIdentifier(Object payload) {
        int index = (Integer)payload;
        return new ContextPartitionIdentifierCategory(this.categorySpec.getItems().get(index).getName());
    }

    private void validateStatementForContext(ContextControllerStatementBase statement, StatementSpecCompiledAnalyzerResult streamAnalysis) throws ExprValidationException {
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean isCreateWindow = statement.getStatementSpec().getCreateWindowDesc() != null;
        String message = "Category context '" + this.factoryContext.getContextName() + "' requires that any of the events types that are listed in the category context also appear in any of the filter expressions of the statement";
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                EventType contextType;
                EventType stmtFilterType = filter.getFilterForEventType();
                if (stmtFilterType == (contextType = this.categorySpec.getFilterSpecCompiled().getFilterForEventType())) {
                    return;
                }
                if (!EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, contextType)) continue;
                return;
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(message);
            }
            return;
        }
        String declaredAsName = statement.getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            if (this.categorySpec.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) {
                return;
            }
            throw new ExprValidationException(message);
        }
    }

    private static void getAddendumFilters(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[]> addendums, ContextDetailCategoryItem category, ContextDetailCategory categorySpec, List<FilterSpecCompiled> filters, ContextControllerStatementDesc statement) {
        block3: {
            block2: {
                boolean isCreateWindow;
                boolean bl = isCreateWindow = statement != null && statement.getStatement().getStatementSpec().getCreateWindowDesc() != null;
                if (isCreateWindow) break block2;
                for (FilterSpecCompiled filtersSpec : filters) {
                    boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filtersSpec.getFilterForEventType(), categorySpec.getFilterSpecCompiled().getFilterForEventType());
                    if (!typeOrSubtype) continue;
                    ContextControllerCategoryFactory.addAddendums(addendums, filtersSpec, category, categorySpec);
                }
                break block3;
            }
            String declaredAsName = statement.getStatement().getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
            if (declaredAsName == null) break block3;
            for (FilterSpecCompiled filtersSpec : filters) {
                ContextControllerCategoryFactory.addAddendums(addendums, filtersSpec, category, categorySpec);
            }
        }
    }

    private static void addAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[]> addendums, FilterSpecCompiled filtersSpec, ContextDetailCategoryItem category, ContextDetailCategory categorySpec) {
        Object[] addendumFilters = new FilterValueSetParam[category.getCompiledFilterParam().length + categorySpec.getFilterParamsCompiled().length];
        System.arraycopy(category.getCompiledFilterParam(), 0, addendumFilters, 0, category.getCompiledFilterParam().length);
        System.arraycopy(categorySpec.getFilterParamsCompiled(), 0, addendumFilters, category.getCompiledFilterParam().length, categorySpec.getFilterParamsCompiled().length);
        FilterValueSetParam[] existing = addendums.get(filtersSpec);
        if (existing == null) {
            addendums.put(filtersSpec, (FilterValueSetParam[])addendumFilters);
        } else {
            existing = (FilterValueSetParam[])CollectionUtil.arrayExpandAddElements((Object)existing, addendumFilters);
            addendums.put(filtersSpec, existing);
        }
    }

    private ContextDetailCategoryItem findCategoryForName(String categoryLabel) {
        for (ContextDetailCategoryItem item : this.categorySpec.getItems()) {
            if (!item.getName().equals(categoryLabel)) continue;
            return item;
        }
        throw new IllegalStateException("Failed to find category '" + categoryLabel + "'");
    }
}

