/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ContextControllerConditionFilter
implements ContextControllerCondition {
    private final EPServicesContext servicesContext;
    private final AgentInstanceContext agentInstanceContext;
    private final ContextDetailConditionFilter endpointFilterSpec;
    private final ContextControllerConditionCallback callback;
    private final ContextInternalFilterAddendum filterAddendum;
    private EPStatementHandleCallback filterHandle;

    public ContextControllerConditionFilter(EPServicesContext servicesContext, AgentInstanceContext agentInstanceContext, ContextDetailConditionFilter endpointFilterSpec, ContextControllerConditionCallback callback, ContextInternalFilterAddendum filterAddendum) {
        this.servicesContext = servicesContext;
        this.agentInstanceContext = agentInstanceContext;
        this.endpointFilterSpec = endpointFilterSpec;
        this.callback = callback;
        this.filterAddendum = filterAddendum;
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, MatchedEventMap priorMatches, long timeOffset, boolean isRecoveringResilient) {
        boolean match;
        FilterHandleCallback filterCallback = new FilterHandleCallback(){

            @Override
            public String getStatementId() {
                return ContextControllerConditionFilter.this.agentInstanceContext.getStatementContext().getStatementId();
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                ContextControllerConditionFilter.this.filterMatchFound(theEvent);
            }

            @Override
            public boolean isSubSelect() {
                return false;
            }
        };
        FilterValueSetParam[] addendum = null;
        if (this.filterAddendum != null) {
            addendum = this.filterAddendum.getFilterAddendum(this.endpointFilterSpec.getFilterSpecCompiled());
        }
        this.filterHandle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), filterCallback);
        FilterValueSet filterValueSet = this.endpointFilterSpec.getFilterSpecCompiled().getValueSet(null, null, addendum);
        this.servicesContext.getFilterService().add(filterValueSet, this.filterHandle);
        if (optionalTriggeringEvent != null && (match = StatementAgentInstanceUtil.evaluateFilterForStatement(this.servicesContext, optionalTriggeringEvent, this.agentInstanceContext, this.filterHandle))) {
            this.filterMatchFound(optionalTriggeringEvent);
        }
    }

    private void filterMatchFound(EventBean theEvent) {
        Map<String, Object> props = Collections.emptyMap();
        if (this.endpointFilterSpec.getOptionalFilterAsName() != null) {
            props = Collections.singletonMap(this.endpointFilterSpec.getOptionalFilterAsName(), theEvent);
        }
        this.callback.rangeNotification(props, this, theEvent, null, this.filterAddendum);
    }

    @Override
    public void deactivate() {
        if (this.filterHandle != null) {
            this.servicesContext.getFilterService().remove(this.filterHandle);
            this.filterHandle = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.filterHandle != null;
    }

    @Override
    public Long getExpectedEndTime() {
        return null;
    }
}

