/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.epl.spec.ContextDetailConditionTimePeriod;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextControllerConditionTimePeriod
implements ContextControllerCondition {
    private static final Log log = LogFactory.getLog(ContextControllerConditionTimePeriod.class);
    private final String contextName;
    private final AgentInstanceContext agentInstanceContext;
    private final ScheduleSlot scheduleSlot;
    private final ContextDetailConditionTimePeriod spec;
    private final ContextControllerConditionCallback callback;
    private final ContextInternalFilterAddendum filterAddendum;
    private EPStatementHandleCallback scheduleHandle;

    public ContextControllerConditionTimePeriod(String contextName, AgentInstanceContext agentInstanceContext, ScheduleSlot scheduleSlot, ContextDetailConditionTimePeriod spec, ContextControllerConditionCallback callback, ContextInternalFilterAddendum filterAddendum) {
        this.contextName = contextName;
        this.agentInstanceContext = agentInstanceContext;
        this.scheduleSlot = scheduleSlot;
        this.spec = spec;
        this.callback = callback;
        this.filterAddendum = filterAddendum;
    }

    @Override
    public void activate(EventBean optionalTriggerEvent, MatchedEventMap priorMatches, long timeOffset, boolean isRecoveringResilient) {
        this.startContextCallback(timeOffset);
    }

    @Override
    public void deactivate() {
        this.endContextCallback();
    }

    @Override
    public boolean isRunning() {
        return this.scheduleHandle != null;
    }

    private void startContextCallback(long timeOffset) {
        ScheduleHandleCallback scheduleCallback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                ContextControllerConditionTimePeriod.this.scheduleHandle = null;
                ContextControllerConditionTimePeriod.this.callback.rangeNotification(Collections.<String, Object>emptyMap(), ContextControllerConditionTimePeriod.this, null, null, ContextControllerConditionTimePeriod.this.filterAddendum);
            }
        };
        EPStatementAgentInstanceHandle agentHandle = new EPStatementAgentInstanceHandle(this.agentInstanceContext.getStatementContext().getEpStatementHandle(), this.agentInstanceContext.getStatementContext().getDefaultAgentInstanceLock(), -1, new StatementAgentInstanceFilterVersion());
        this.scheduleHandle = new EPStatementHandleCallback(agentHandle, scheduleCallback);
        Double interval = (Double)this.spec.getTimePeriod().evaluate(null, true, this.agentInstanceContext);
        if (interval == null) {
            log.warn((Object)("Time period expression in context '" + this.contextName + "' returned a null value, not scheduling time period"));
        } else {
            long msec = (long)(interval * 1000.0) - timeOffset;
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(msec, this.scheduleHandle, this.scheduleSlot);
        }
    }

    private void endContextCallback() {
        if (this.scheduleHandle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.scheduleHandle = null;
    }

    @Override
    public Long getExpectedEndTime() {
        Double interval = (Double)this.spec.getTimePeriod().evaluate(null, true, this.agentInstanceContext);
        if (interval != null) {
            return this.agentInstanceContext.getStatementContext().getTimeProvider().getTime() + (long)(interval * 1000.0);
        }
        return null;
    }
}

