/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierInitiatedTerminated;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextControllerConditionFactory;
import com.espertech.esper.core.context.mgr.ContextControllerConditionTimePeriod;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerInitTermFactory;
import com.espertech.esper.core.context.mgr.ContextControllerInitTermInstance;
import com.espertech.esper.core.context.mgr.ContextControllerInitTermState;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStateUtil;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.util.ContextControllerSelectorUtil;
import com.espertech.esper.epl.spec.ContextDetailCondition;
import com.espertech.esper.epl.spec.ContextDetailConditionCrontab;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.MatchedEventMapImpl;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.type.NumberSetParameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ContextControllerInitTerm
implements ContextController,
ContextControllerConditionCallback {
    protected final int pathId;
    protected final ContextControllerLifecycleCallback activationCallback;
    protected final ContextControllerInitTermFactory factory;
    protected ContextControllerCondition startCondition;
    protected Map<ContextControllerCondition, ContextControllerInitTermInstance> endConditions = new LinkedHashMap<ContextControllerCondition, ContextControllerInitTermInstance>();
    protected int currentSubpathId;

    public ContextControllerInitTerm(int pathId, ContextControllerLifecycleCallback lifecycleCallback, ContextControllerInitTermFactory factory) {
        this.pathId = pathId;
        this.activationCallback = lifecycleCallback;
        this.factory = factory;
    }

    @Override
    public void importContextPartitions(ContextControllerState state, int pathIdToUse, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector) {
        this.initializeFromState(null, null, filterAddendum, state, pathIdToUse, agentInstanceSelector);
    }

    @Override
    public void deletePath(ContextPartitionIdentifier identifier) {
        ContextPartitionIdentifierInitiatedTerminated initterm = (ContextPartitionIdentifierInitiatedTerminated)identifier;
        for (Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> entry : this.endConditions.entrySet()) {
            if (!ContextControllerInitTerm.compare(initterm.getStartTime(), initterm.getProperties(), initterm.getEndTime(), entry.getValue().getStartTime(), entry.getValue().getStartProperties(), entry.getValue().getEndTime())) continue;
            entry.getKey().deactivate();
            this.endConditions.remove(entry.getKey());
            break;
        }
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerState controllerState, ContextInternalFilterAddendum filterAddendum, Integer importPathId) {
        if (this.factory.getFactoryContext().getNestingLevel() == 1) {
            controllerState = ContextControllerStateUtil.getRecoveryStates(this.factory.getStateCache(), this.factory.getFactoryContext().getOutermostContextName());
        }
        if (controllerState == null) {
            this.startCondition = this.makeEndpoint(this.factory.getContextDetail().getStart(), filterAddendum, true, 0);
            boolean currentlyRunning = false;
            if (!this.factory.getContextDetail().isOverlapping()) {
                currentlyRunning = this.determineCurrentlyRunning(this.startCondition);
            }
            if (currentlyRunning) {
                ++this.currentSubpathId;
                ContextControllerCondition endEndpoint = this.makeEndpoint(this.factory.getContextDetail().getEnd(), filterAddendum, false, this.currentSubpathId);
                endEndpoint.activate(optionalTriggeringEvent, null, 0L, this.factory.getFactoryContext().isRecoveringResilient());
                long startTime = this.factory.getSchedulingService().getTime();
                Long endTime = endEndpoint.getExpectedEndTime();
                Map<String, Object> builtinProps = ContextControllerInitTerm.getBuiltinProperties(this.factory, startTime, endTime, Collections.<String, Object>emptyMap());
                ContextControllerInstanceHandle instanceHandle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, optionalTriggeringEvent, optionalTriggeringPattern, null, builtinProps, controllerState, filterAddendum, this.factory.getFactoryContext().isRecoveringResilient(), ContextPartitionState.STARTED);
                this.endConditions.put(endEndpoint, new ContextControllerInitTermInstance(instanceHandle, null, startTime, endTime, this.currentSubpathId));
                ContextControllerInitTermState state = new ContextControllerInitTermState(this.factory.getFactoryContext().getServicesContext().getSchedulingService().getTime(), builtinProps);
                this.factory.getStateCache().addContextPath(this.factory.getFactoryContext().getOutermostContextName(), this.factory.getFactoryContext().getNestingLevel(), this.pathId, this.currentSubpathId, instanceHandle.getContextPartitionOrPathId(), state, this.factory.getBinding());
            } else {
                this.startCondition.activate(optionalTriggeringEvent, null, 0L, this.factory.getFactoryContext().isRecoveringResilient());
            }
            return;
        }
        this.startCondition = this.makeEndpoint(this.factory.getContextDetail().getStart(), filterAddendum, true, 0);
        boolean currentlyRunning = false;
        if (!this.factory.getContextDetail().isOverlapping()) {
            currentlyRunning = this.determineCurrentlyRunning(this.startCondition);
        }
        if (!currentlyRunning) {
            this.startCondition.activate(optionalTriggeringEvent, null, 0L, this.factory.getFactoryContext().isRecoveringResilient());
        }
        int pathIdToUse = importPathId != null ? importPathId : this.pathId;
        this.initializeFromState(optionalTriggeringEvent, optionalTriggeringPattern, filterAddendum, controllerState, pathIdToUse, null);
    }

    protected ContextControllerCondition makeEndpoint(ContextDetailCondition endpoint, ContextInternalFilterAddendum filterAddendum, boolean isStartEndpoint, int subPathId) {
        return ContextControllerConditionFactory.getEndpoint(this.factory.getFactoryContext().getContextName(), this.factory.getFactoryContext().getServicesContext(), this.factory.getFactoryContext().getAgentInstanceContextCreate(), endpoint, this, filterAddendum, isStartEndpoint, this.factory.getFactoryContext().getNestingLevel(), this.pathId, subPathId);
    }

    @Override
    public void visitSelectedPartitions(ContextPartitionSelector contextPartitionSelector, ContextPartitionVisitor visitor) {
        int nestingLevel = this.factory.getFactoryContext().getNestingLevel();
        if (contextPartitionSelector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filter = (ContextPartitionSelectorFiltered)contextPartitionSelector;
            ContextPartitionIdentifierInitiatedTerminated identifier = new ContextPartitionIdentifierInitiatedTerminated();
            for (Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> entry : this.endConditions.entrySet()) {
                identifier.setEndTime(entry.getValue().getEndTime());
                identifier.setStartTime(entry.getValue().getStartTime());
                identifier.setProperties(entry.getValue().getStartProperties());
                identifier.setContextPartitionId(entry.getValue().getInstanceHandle().getContextPartitionOrPathId());
                if (!filter.filter(identifier)) continue;
                ContextControllerInitTermState state = new ContextControllerInitTermState(this.factory.getFactoryContext().getServicesContext().getSchedulingService().getTime(), entry.getValue().getStartProperties());
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), state, this, entry.getValue().getInstanceHandle());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById filter = (ContextPartitionSelectorById)contextPartitionSelector;
            for (Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> entry : this.endConditions.entrySet()) {
                if (!filter.getContextPartitionIds().contains(entry.getValue().getInstanceHandle().getContextPartitionOrPathId())) continue;
                ContextControllerInitTermState state = new ContextControllerInitTermState(this.factory.getFactoryContext().getServicesContext().getSchedulingService().getTime(), entry.getValue().getStartProperties());
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), state, this, entry.getValue().getInstanceHandle());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorAll) {
            for (Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> entry : this.endConditions.entrySet()) {
                ContextControllerInitTermState state = new ContextControllerInitTermState(this.factory.getFactoryContext().getServicesContext().getSchedulingService().getTime(), entry.getValue().getStartProperties());
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), state, this, entry.getValue().getInstanceHandle());
            }
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[0], contextPartitionSelector);
    }

    @Override
    public void rangeNotification(Map<String, Object> builtinProperties, ContextControllerCondition originCondition, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextInternalFilterAddendum filterAddendum) {
        if (originCondition == this.startCondition) {
            if (!this.factory.getContextDetail().isOverlapping()) {
                if (this.startCondition.isRunning()) {
                    this.startCondition.deactivate();
                }
            } else if (!this.startCondition.isRunning()) {
                this.startCondition.activate(null, null, 0L, this.factory.getFactoryContext().isRecoveringResilient());
            }
            ++this.currentSubpathId;
            ContextControllerCondition endEndpoint = this.makeEndpoint(this.factory.getContextDetail().getEnd(), filterAddendum, false, this.currentSubpathId);
            MatchedEventMap matchedEventMap = this.getMatchedEventMap(builtinProperties);
            endEndpoint.activate(null, matchedEventMap, 0L, false);
            long startTime = this.factory.getSchedulingService().getTime();
            Long endTime = endEndpoint.getExpectedEndTime();
            Map<String, Object> builtinProps = ContextControllerInitTerm.getBuiltinProperties(this.factory, startTime, endTime, builtinProperties);
            ContextControllerInstanceHandle instanceHandle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, optionalTriggeringEvent, optionalTriggeringPattern, matchedEventMap, builtinProps, null, filterAddendum, this.factory.getFactoryContext().isRecoveringResilient(), ContextPartitionState.STARTED);
            this.endConditions.put(endEndpoint, new ContextControllerInitTermInstance(instanceHandle, builtinProperties, startTime, endTime, this.currentSubpathId));
            ContextControllerInitTermState state = new ContextControllerInitTermState(this.factory.getFactoryContext().getServicesContext().getSchedulingService().getTime(), builtinProperties);
            this.factory.getStateCache().addContextPath(this.factory.getFactoryContext().getOutermostContextName(), this.factory.getFactoryContext().getNestingLevel(), this.pathId, this.currentSubpathId, instanceHandle.getContextPartitionOrPathId(), state, this.factory.getBinding());
        } else {
            ContextControllerInitTermInstance instance;
            if (originCondition.isRunning()) {
                originCondition.deactivate();
            }
            if ((instance = this.endConditions.remove(originCondition)) == null) {
                return;
            }
            this.activationCallback.contextPartitionTerminate(instance.getInstanceHandle(), builtinProperties);
            if (!this.factory.getContextDetail().isOverlapping()) {
                this.startCondition.activate(optionalTriggeringEvent, null, 0L, false);
            }
            this.factory.getStateCache().removeContextPath(this.factory.getFactoryContext().getOutermostContextName(), this.factory.getFactoryContext().getNestingLevel(), this.pathId, instance.getSubPathId());
        }
    }

    protected MatchedEventMap getMatchedEventMap(Map<String, Object> builtinProperties) {
        Object[] props = new Object[this.factory.getMatchedEventMapMeta().getTagsPerIndex().length];
        int count = 0;
        for (String name : this.factory.getMatchedEventMapMeta().getTagsPerIndex()) {
            props[count++] = builtinProperties.get(name);
        }
        return new MatchedEventMapImpl(this.factory.getMatchedEventMapMeta(), props);
    }

    @Override
    public void setContextPartitionRange(List<NumberSetParameter> partitionRanges) {
        throw new UnsupportedOperationException();
    }

    protected boolean determineCurrentlyRunning(ContextControllerCondition startCondition) {
        ContextControllerConditionTimePeriod condition;
        Long endTime;
        if (this.factory.getContextDetail().getStart() instanceof ContextDetailConditionCrontab && this.factory.getContextDetail().getEnd() instanceof ContextDetailConditionCrontab) {
            long nextScheduledEndTime;
            ScheduleSpec scheduleStart = ((ContextDetailConditionCrontab)this.factory.getContextDetail().getStart()).getSchedule();
            ScheduleSpec scheduleEnd = ((ContextDetailConditionCrontab)this.factory.getContextDetail().getEnd()).getSchedule();
            long nextScheduledStartTime = ScheduleComputeHelper.computeNextOccurance(scheduleStart, this.factory.getTimeProvider().getTime());
            return nextScheduledStartTime >= (nextScheduledEndTime = ScheduleComputeHelper.computeNextOccurance(scheduleEnd, this.factory.getTimeProvider().getTime()));
        }
        return startCondition instanceof ContextControllerConditionTimePeriod && (endTime = (condition = (ContextControllerConditionTimePeriod)startCondition).getExpectedEndTime()) != null && endTime <= 0L;
    }

    @Override
    public ContextControllerFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getPathId() {
        return this.pathId;
    }

    @Override
    public void deactivate() {
        if (this.startCondition != null && this.startCondition.isRunning()) {
            this.startCondition.deactivate();
        }
        for (Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> entry : this.endConditions.entrySet()) {
            if (!entry.getKey().isRunning()) continue;
            entry.getKey().deactivate();
        }
        this.endConditions.clear();
        this.factory.getStateCache().removeContextParentPath(this.factory.getFactoryContext().getOutermostContextName(), this.factory.getFactoryContext().getNestingLevel(), this.pathId);
    }

    protected static Map<String, Object> getBuiltinProperties(ContextControllerInitTermFactory factory, long startTime, Long endTime, Map<String, Object> startEndpointData) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", factory.getFactoryContext().getContextName());
        props.put("startTime", startTime);
        props.put("endTime", endTime);
        props.putAll(startEndpointData);
        return props;
    }

    private void initializeFromState(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextInternalFilterAddendum filterAddendum, ContextControllerState controllerState, int pathIdToUse, AgentInstanceSelector agentInstanceSelector) {
        TreeMap<ContextStatePathKey, ContextStatePathValue> states = controllerState.getStates();
        NavigableMap<ContextStatePathKey, ContextStatePathValue> childContexts = ContextControllerStateUtil.getChildContexts(this.factory.getFactoryContext(), pathIdToUse, states);
        EventAdapterService eventAdapterService = this.factory.getFactoryContext().getServicesContext().getEventAdapterService();
        int maxSubpathId = Integer.MIN_VALUE;
        for (Map.Entry entry : childContexts.entrySet()) {
            int n;
            ContextControllerInitTermState state = (ContextControllerInitTermState)this.factory.getBinding().byteArrayToObject(((ContextStatePathValue)entry.getValue()).getBlob(), eventAdapterService);
            if (controllerState.isImported()) {
                ContextControllerInstanceHandle existingHandle;
                Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> existing = null;
                for (Map.Entry<ContextControllerCondition, ContextControllerInitTermInstance> entryExisting : this.endConditions.entrySet()) {
                    if (!ContextControllerInitTerm.compare(state.getStartTime(), state.getPatternData(), null, entryExisting.getValue().getStartTime(), entryExisting.getValue().getStartProperties(), null)) continue;
                    existing = entryExisting;
                    break;
                }
                if (existing != null && (existingHandle = ((ContextControllerInitTermInstance)existing.getValue()).getInstanceHandle()) != null) {
                    this.activationCallback.contextPartitionNavigate(existingHandle, this, controllerState, ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), filterAddendum, agentInstanceSelector, ((ContextStatePathValue)entry.getValue()).getBlob());
                    continue;
                }
            }
            ContextControllerCondition endEndpoint = this.makeEndpoint(this.factory.getContextDetail().getEnd(), filterAddendum, false, ((ContextStatePathKey)entry.getKey()).getSubPath());
            long timeOffset = this.factory.getFactoryContext().getServicesContext().getSchedulingService().getTime() - state.getStartTime();
            endEndpoint.activate(optionalTriggeringEvent, null, timeOffset, this.factory.getFactoryContext().isRecoveringResilient());
            long startTime = state.getStartTime();
            Long endTime = endEndpoint.getExpectedEndTime();
            Map<String, Object> builtinProps = ContextControllerInitTerm.getBuiltinProperties(this.factory, startTime, endTime, state.getPatternData());
            int contextPartitionId = ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId();
            if (!controllerState.isImported()) {
                n = ((ContextStatePathKey)entry.getKey()).getSubPath();
            } else {
                n = this.currentSubpathId + 1;
                this.currentSubpathId = this.currentSubpathId;
            }
            int assignedSubPathId = n;
            ContextControllerInstanceHandle instanceHandle = this.activationCallback.contextPartitionInstantiate(contextPartitionId, assignedSubPathId, ((ContextStatePathKey)entry.getKey()).getSubPath(), this, optionalTriggeringEvent, optionalTriggeringPattern, null, builtinProps, controllerState, filterAddendum, this.factory.getFactoryContext().isRecoveringResilient(), ((ContextStatePathValue)entry.getValue()).getState());
            this.endConditions.put(endEndpoint, new ContextControllerInitTermInstance(instanceHandle, state.getPatternData(), startTime, endTime, assignedSubPathId));
            if (((ContextStatePathKey)entry.getKey()).getSubPath() <= maxSubpathId) continue;
            maxSubpathId = assignedSubPathId;
        }
        if (!controllerState.isImported()) {
            this.currentSubpathId = maxSubpathId != Integer.MIN_VALUE ? maxSubpathId : 0;
        }
    }

    public static boolean compare(long savedStartTime, Map<String, Object> savedProperties, Long savedEndTime, long existingStartTime, Map<String, Object> existingProperties, Long existingEndTime) {
        if (savedStartTime != existingStartTime) {
            return false;
        }
        if (savedEndTime != null && existingEndTime != null && !savedEndTime.equals(existingEndTime)) {
            return false;
        }
        for (Map.Entry<String, Object> savedEntry : savedProperties.entrySet()) {
            Object existingValue = existingProperties.get(savedEntry.getKey());
            Object savedValue = savedEntry.getValue();
            if (savedValue == null && existingValue == null) continue;
            if (savedValue == null || existingValue == null) {
                return false;
            }
            if (existingValue.equals(savedValue) || existingValue instanceof EventBean && savedValue instanceof EventBean && ((EventBean)existingValue).getUnderlying().equals(((EventBean)savedValue).getUnderlying())) continue;
            return false;
        }
        return true;
    }
}

