/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierPartitioned;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.client.context.ContextPartitionSelectorSegmented;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedFactory;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedFilterCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedInstanceCreateCallback;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStateUtil;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.util.ContextControllerSelectorUtil;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.type.NumberSetParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ContextControllerPartitioned
implements ContextController,
ContextControllerPartitionedInstanceCreateCallback {
    protected final int pathId;
    protected final ContextControllerLifecycleCallback activationCallback;
    protected final ContextControllerPartitionedFactory factory;
    protected final List<ContextControllerPartitionedFilterCallback> filterCallbacks = new ArrayList<ContextControllerPartitionedFilterCallback>();
    protected final HashMap<Object, ContextControllerInstanceHandle> partitionKeys = new HashMap();
    private ContextInternalFilterAddendum activationFilterAddendum;
    protected int currentSubpathId;

    public ContextControllerPartitioned(int pathId, ContextControllerLifecycleCallback activationCallback, ContextControllerPartitionedFactory factory) {
        this.pathId = pathId;
        this.activationCallback = activationCallback;
        this.factory = factory;
    }

    @Override
    public void importContextPartitions(ContextControllerState state, int pathIdToUse, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector) {
        this.initializeFromState(null, null, filterAddendum, state, pathIdToUse, agentInstanceSelector);
    }

    @Override
    public void deletePath(ContextPartitionIdentifier identifier) {
        ContextPartitionIdentifierPartitioned partitioned = (ContextPartitionIdentifierPartitioned)identifier;
        this.partitionKeys.remove(this.getKeyObjectForLookup(partitioned.getKeys()));
    }

    @Override
    public void visitSelectedPartitions(ContextPartitionSelector contextPartitionSelector, ContextPartitionVisitor visitor) {
        int nestingLevel = this.factory.getFactoryContext().getNestingLevel();
        if (contextPartitionSelector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filtered = (ContextPartitionSelectorFiltered)contextPartitionSelector;
            ContextPartitionIdentifierPartitioned identifier = new ContextPartitionIdentifierPartitioned();
            for (Map.Entry<Object, ContextControllerInstanceHandle> entry : this.partitionKeys.entrySet()) {
                identifier.setContextPartitionId(entry.getValue().getContextPartitionOrPathId());
                Object[] identifierOA = this.getKeyObjectsAccountForMultikey(entry.getKey());
                identifier.setKeys(identifierOA);
                if (!filtered.filter(identifier)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), identifierOA, this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorSegmented) {
            ContextPartitionSelectorSegmented partitioned = (ContextPartitionSelectorSegmented)contextPartitionSelector;
            if (partitioned.getPartitionKeys() == null || partitioned.getPartitionKeys().isEmpty()) {
                return;
            }
            for (Object[] keyObjects : partitioned.getPartitionKeys()) {
                Object key = this.getKeyObjectForLookup(keyObjects);
                ContextControllerInstanceHandle instanceHandle = this.partitionKeys.get(key);
                if (instanceHandle == null || instanceHandle.getContextPartitionOrPathId() == null) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), keyObjects, this, instanceHandle);
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById filtered = (ContextPartitionSelectorById)contextPartitionSelector;
            for (Map.Entry<Object, ContextControllerInstanceHandle> entry : this.partitionKeys.entrySet()) {
                if (!filtered.getContextPartitionIds().contains(entry.getValue().getContextPartitionOrPathId())) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), this.getKeyObjectsAccountForMultikey(entry.getKey()), this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorAll) {
            for (Map.Entry<Object, ContextControllerInstanceHandle> entry : this.partitionKeys.entrySet()) {
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), this.getKeyObjectsAccountForMultikey(entry.getKey()), this, entry.getValue());
            }
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorSegmented.class}, contextPartitionSelector);
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerState controllerState, ContextInternalFilterAddendum filterAddendum, Integer importPathId) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        this.activationFilterAddendum = filterAddendum;
        for (ContextDetailPartitionItem item : this.factory.getSegmentedSpec().getItems()) {
            boolean match;
            ContextControllerPartitionedFilterCallback callback = new ContextControllerPartitionedFilterCallback(factoryContext.getServicesContext(), factoryContext.getAgentInstanceContextCreate(), item, this, filterAddendum);
            this.filterCallbacks.add(callback);
            if (optionalTriggeringEvent == null || !(match = StatementAgentInstanceUtil.evaluateFilterForStatement(factoryContext.getServicesContext(), optionalTriggeringEvent, factoryContext.getAgentInstanceContextCreate(), callback.getFilterHandle()))) continue;
            callback.matchFound(optionalTriggeringEvent, null);
        }
        if (factoryContext.getNestingLevel() == 1) {
            controllerState = ContextControllerStateUtil.getRecoveryStates(this.factory.getStateCache(), factoryContext.getOutermostContextName());
        }
        if (controllerState == null) {
            return;
        }
        int pathIdToUse = importPathId != null ? importPathId : this.pathId;
        this.initializeFromState(optionalTriggeringEvent, optionalTriggeringPattern, filterAddendum, controllerState, pathIdToUse, null);
    }

    @Override
    public ContextControllerFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getPathId() {
        return this.pathId;
    }

    @Override
    public void setContextPartitionRange(List<NumberSetParameter> partitionRanges) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void deactivate() {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        for (ContextControllerPartitionedFilterCallback callback : this.filterCallbacks) {
            callback.destroy(factoryContext.getServicesContext().getFilterService());
        }
        this.partitionKeys.clear();
        this.filterCallbacks.clear();
        this.factory.getStateCache().removeContextParentPath(factoryContext.getOutermostContextName(), factoryContext.getNestingLevel(), this.pathId);
    }

    @Override
    public synchronized void create(Object key, EventBean theEvent) {
        boolean exists = this.partitionKeys.containsKey(key);
        if (exists) {
            return;
        }
        ++this.currentSubpathId;
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        Map<String, Object> props = ContextPropertyEventType.getPartitionBean(factoryContext.getContextName(), 0, key, this.factory.getSegmentedSpec().getItems().get(0).getPropertyNames());
        ContextInternalFilterAddendum filterAddendum = this.activationFilterAddendum;
        if (this.factory.hasFiltersSpecsNestedContexts()) {
            filterAddendum = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
            this.factory.populateContextInternalFilterAddendums(filterAddendum, key);
        }
        ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, theEvent, null, key, props, null, filterAddendum, false, ContextPartitionState.STARTED);
        this.partitionKeys.put(key, handle);
        Object[] keyObjectSaved = this.getKeyObjectsAccountForMultikey(key);
        this.factory.getStateCache().addContextPath(factoryContext.getOutermostContextName(), factoryContext.getNestingLevel(), this.pathId, this.currentSubpathId, handle.getContextPartitionOrPathId(), keyObjectSaved, this.factory.getBinding());
    }

    private Object[] getKeyObjectsAccountForMultikey(Object key) {
        if (key instanceof MultiKeyUntyped) {
            return ((MultiKeyUntyped)key).getKeys();
        }
        return new Object[]{key};
    }

    private Object getKeyObjectForLookup(Object[] keyObjects) {
        if (keyObjects.length > 1) {
            return new MultiKeyUntyped(keyObjects);
        }
        return keyObjects[0];
    }

    private void initializeFromState(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextInternalFilterAddendum filterAddendum, ContextControllerState controllerState, int pathIdToUse, AgentInstanceSelector agentInstanceSelector) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        TreeMap<ContextStatePathKey, ContextStatePathValue> states = controllerState.getStates();
        int maxSubpathId = Integer.MIN_VALUE;
        NavigableMap<ContextStatePathKey, ContextStatePathValue> childContexts = ContextControllerStateUtil.getChildContexts(factoryContext, pathIdToUse, states);
        EventAdapterService eventAdapterService = this.factory.getFactoryContext().getServicesContext().getEventAdapterService();
        for (Map.Entry entry : childContexts.entrySet()) {
            int n;
            ContextControllerInstanceHandle existingHandle;
            Object[] keys = (Object[])this.factory.getBinding().byteArrayToObject(((ContextStatePathValue)entry.getValue()).getBlob(), eventAdapterService);
            Object mapKey = this.getKeyObjectForLookup(keys);
            ContextInternalFilterAddendum myFilterAddendum = this.activationFilterAddendum;
            if (this.factory.hasFiltersSpecsNestedContexts()) {
                filterAddendum = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
                this.factory.populateContextInternalFilterAddendums(filterAddendum, mapKey);
            }
            if (controllerState.isImported() && (existingHandle = this.partitionKeys.get(mapKey)) != null) {
                this.activationCallback.contextPartitionNavigate(existingHandle, this, controllerState, ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), myFilterAddendum, agentInstanceSelector, ((ContextStatePathValue)entry.getValue()).getBlob());
                continue;
            }
            Map<String, Object> props = ContextPropertyEventType.getPartitionBean(factoryContext.getContextName(), 0, mapKey, this.factory.getSegmentedSpec().getItems().get(0).getPropertyNames());
            if (!controllerState.isImported()) {
                n = ((ContextStatePathKey)entry.getKey()).getSubPath();
            } else {
                n = this.currentSubpathId + 1;
                this.currentSubpathId = this.currentSubpathId;
            }
            int assignedSubpathId = n;
            ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), assignedSubpathId, ((ContextStatePathKey)entry.getKey()).getSubPath(), this, optionalTriggeringEvent, optionalTriggeringPattern, mapKey, props, controllerState, myFilterAddendum, factoryContext.isRecoveringResilient(), ((ContextStatePathValue)entry.getValue()).getState());
            this.partitionKeys.put(mapKey, handle);
            if (((ContextStatePathKey)entry.getKey()).getSubPath() <= maxSubpathId) continue;
            maxSubpathId = assignedSubpathId;
        }
        if (!controllerState.isImported()) {
            this.currentSubpathId = maxSubpathId != Integer.MIN_VALUE ? maxSubpathId : 0;
        }
    }
}

