/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierPartitioned;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryBase;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitioned;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedState;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedUtil;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCacheFilters;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStateCache;
import com.espertech.esper.core.context.mgr.ContextStatePathValueBinding;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterValueSetParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ContextControllerPartitionedFactory
extends ContextControllerFactoryBase
implements ContextControllerFactory {
    private final ContextDetailPartitioned segmentedSpec;
    private final List<FilterSpecCompiled> filtersSpecsNestedContexts;
    private final ContextStateCache stateCache;
    private final ContextStatePathValueBinding binding;
    private Map<String, Object> contextBuiltinProps;

    public ContextControllerPartitionedFactory(ContextControllerFactoryContext factoryContext, ContextDetailPartitioned segmentedSpec, List<FilterSpecCompiled> filtersSpecsNestedContexts, ContextStateCache stateCache) {
        super(factoryContext);
        this.segmentedSpec = segmentedSpec;
        this.filtersSpecsNestedContexts = filtersSpecsNestedContexts;
        this.stateCache = stateCache;
        this.binding = stateCache.getBinding(ContextControllerPartitionedState.class);
    }

    public boolean hasFiltersSpecsNestedContexts() {
        return this.filtersSpecsNestedContexts != null && !this.filtersSpecsNestedContexts.isEmpty();
    }

    @Override
    public ContextStateCache getStateCache() {
        return this.stateCache;
    }

    public ContextStatePathValueBinding getBinding() {
        return this.binding;
    }

    @Override
    public void validateFactory() throws ExprValidationException {
        Class[] propertyTypes = ContextControllerPartitionedUtil.validateContextDesc(this.factoryContext.getContextName(), this.segmentedSpec);
        this.contextBuiltinProps = ContextPropertyEventType.getPartitionType(this.segmentedSpec, propertyTypes);
    }

    @Override
    public ContextControllerStatementCtxCache validateStatement(ContextControllerStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        ContextControllerPartitionedUtil.validateStatementForContext(this.factoryContext.getContextName(), statement, streamAnalysis, this.getItemEventTypes(this.segmentedSpec), this.factoryContext.getServicesContext().getNamedWindowService());
        return new ContextControllerStatementCtxCacheFilters(streamAnalysis.getFilters());
    }

    @Override
    public void populateFilterAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[]> filterAddendum, ContextControllerStatementDesc statement, Object key, int contextId) {
        ContextControllerStatementCtxCacheFilters statementInfo = (ContextControllerStatementCtxCacheFilters)statement.getCaches()[this.factoryContext.getNestingLevel() - 1];
        ContextControllerPartitionedUtil.populateAddendumFilters(key, statementInfo.getFilterSpecs(), this.segmentedSpec, statement.getStatement().getStatementSpec(), filterAddendum);
    }

    public void populateContextInternalFilterAddendums(ContextInternalFilterAddendum filterAddendum, Object key) {
        if (this.filtersSpecsNestedContexts == null || this.filtersSpecsNestedContexts.isEmpty()) {
            return;
        }
        ContextControllerPartitionedUtil.populateAddendumFilters(key, this.filtersSpecsNestedContexts, this.segmentedSpec, null, filterAddendum.getFilterAddendum());
    }

    @Override
    public FilterSpecLookupable getFilterLookupable(EventType eventType) {
        return null;
    }

    @Override
    public boolean isSingleInstanceContext() {
        return false;
    }

    @Override
    public StatementAIResourceRegistryFactory getStatementAIResourceRegistryFactory() {
        return new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
    }

    @Override
    public List<ContextDetailPartitionItem> getContextDetailPartitionItems() {
        return this.segmentedSpec.getItems();
    }

    @Override
    public ContextDetail getContextDetail() {
        return this.segmentedSpec;
    }

    public ContextDetailPartitioned getSegmentedSpec() {
        return this.segmentedSpec;
    }

    @Override
    public Map<String, Object> getContextBuiltinProps() {
        return this.contextBuiltinProps;
    }

    @Override
    public ContextController createNoCallback(int pathId, ContextControllerLifecycleCallback callback) {
        return new ContextControllerPartitioned(pathId, callback, this);
    }

    @Override
    public ContextPartitionIdentifier keyPayloadToIdentifier(Object payload) {
        if (payload instanceof Object[]) {
            return new ContextPartitionIdentifierPartitioned((Object[])payload);
        }
        if (payload instanceof MultiKeyUntyped) {
            return new ContextPartitionIdentifierPartitioned(((MultiKeyUntyped)payload).getKeys());
        }
        return new ContextPartitionIdentifierPartitioned(new Object[]{payload});
    }

    private Collection<EventType> getItemEventTypes(ContextDetailPartitioned segmentedSpec) {
        ArrayList<EventType> itemEventTypes = new ArrayList<EventType>();
        for (ContextDetailPartitionItem item : segmentedSpec.getItems()) {
            itemEventTypes.add(item.getFilterSpecCompiled().getFilterForEventType());
        }
        return itemEventTypes;
    }
}

