/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.core.context.mgr.ContextControllerFactoryServiceContext;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextManagerImpl;
import com.espertech.esper.core.context.mgr.ContextManagerNested;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailNested;
import com.espertech.esper.epl.spec.CreateContextDesc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextManagementServiceImpl
implements ContextManagementService {
    private static final Log log = LogFactory.getLog(ContextManagementServiceImpl.class);
    private final Map<String, ContextManagerEntry> contexts;
    private final Set<String> destroyedContexts = new HashSet<String>();

    public ContextManagementServiceImpl() {
        this.contexts = new HashMap<String, ContextManagerEntry>();
    }

    @Override
    public void addContextSpec(EPServicesContext servicesContext, AgentInstanceContext agentInstanceContext, CreateContextDesc contextDesc, boolean isRecoveringResilient) throws ExprValidationException {
        ContextManagerEntry mgr = this.contexts.get(contextDesc.getContextName());
        if (mgr != null) {
            if (this.destroyedContexts.contains(contextDesc.getContextName())) {
                throw new ExprValidationException("Context by name '" + contextDesc.getContextName() + "' is still referenced by statements and may not be changed");
            }
            throw new ExprValidationException("Context by name '" + contextDesc.getContextName() + "' already exists");
        }
        ContextControllerFactoryServiceContext factoryServiceContext = new ContextControllerFactoryServiceContext(contextDesc.getContextName(), servicesContext, contextDesc.getContextDetail(), agentInstanceContext, isRecoveringResilient);
        ContextManager contextManager = contextDesc.getContextDetail() instanceof ContextDetailNested ? new ContextManagerNested(factoryServiceContext) : new ContextManagerImpl(factoryServiceContext);
        factoryServiceContext.getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().setFilterFaultHandler(contextManager);
        this.contexts.put(contextDesc.getContextName(), new ContextManagerEntry(contextManager));
    }

    @Override
    public int getContextCount() {
        return this.contexts.size();
    }

    @Override
    public ContextDescriptor getContextDescriptor(String contextName) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            return null;
        }
        return entry.getContextManager().getContextDescriptor();
    }

    @Override
    public ContextManager getContextManager(String contextName) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            return null;
        }
        return entry.getContextManager();
    }

    @Override
    public void addStatement(String contextName, ContextControllerStatementBase statement, boolean isRecoveringResilient) throws ExprValidationException {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            throw new ExprValidationException(this.getNotDecaredText(contextName));
        }
        entry.addStatement(statement.getStatementContext().getStatementId());
        entry.getContextManager().addStatement(statement, isRecoveringResilient);
    }

    @Override
    public void destroyedStatement(String contextName, String statementName, String statementId) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn((Object)("Destroy statement for statement '" + statementName + "' failed to locate corresponding context manager '" + contextName + "'"));
            return;
        }
        entry.removeStatement(statementId);
        entry.getContextManager().destroyStatement(statementName, statementId);
        if (entry.getStatementCount() == 0 && this.destroyedContexts.contains(contextName)) {
            this.destroyContext(contextName, entry);
        }
    }

    @Override
    public void stoppedStatement(String contextName, String statementName, String statementId) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn((Object)("Stop statement for statement '" + statementName + "' failed to locate corresponding context manager '" + contextName + "'"));
            return;
        }
        try {
            entry.getContextManager().stopStatement(statementName, statementId);
        }
        catch (RuntimeException ex) {
            log.warn((Object)("Failed to stop statement '" + statementName + "' as related to context '" + contextName + "': " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void destroyedContext(String contextName) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn((Object)("Destroy for context '" + contextName + "' failed to locate corresponding context manager '" + contextName + "'"));
            return;
        }
        if (entry.getStatementCount() == 0) {
            this.destroyContext(contextName, entry);
        } else {
            this.destroyedContexts.add(contextName);
        }
    }

    private void destroyContext(String contextName, ContextManagerEntry entry) {
        entry.getContextManager().safeDestroy();
        this.contexts.remove(contextName);
        this.destroyedContexts.remove(contextName);
    }

    private String getNotDecaredText(String contextName) {
        return "Context by name '" + contextName + "' has not been declared";
    }

    public static class ContextManagerEntry {
        private final ContextManager contextManager;
        private final Set<String> referringStatements;

        public ContextManagerEntry(ContextManager contextManager) {
            this.contextManager = contextManager;
            this.referringStatements = new HashSet<String>();
        }

        public ContextManager getContextManager() {
            return this.contextManager;
        }

        public void addStatement(String statementId) {
            this.referringStatements.add(statementId);
        }

        public int getStatementCount() {
            return this.referringStatements.size();
        }

        public void removeStatement(String statementId) {
            this.referringStatements.remove(statementId);
        }
    }
}

