/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.stmt;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ArrayWrap;
import com.espertech.esper.core.context.stmt.AIRegistryAggregation;
import com.espertech.esper.core.context.stmt.AIRegistryUtil;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;

public class AIRegistryAggregationMultiPerm
implements AIRegistryAggregation {
    private final ArrayWrap<AggregationService> services = new ArrayWrap(AggregationService.class, 2);
    private int count;

    @Override
    public void assignService(int serviceId, AggregationService aggregationService) {
        AIRegistryUtil.checkExpand(serviceId, this.services);
        this.services.getArray()[serviceId] = aggregationService;
        ++this.count;
    }

    @Override
    public void deassignService(int serviceId) {
        if (serviceId >= this.services.getArray().length) {
            return;
        }
        this.services.getArray()[serviceId] = null;
        --this.count;
    }

    @Override
    public int getInstanceCount() {
        return this.count;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].applyEnter(eventsPerStream, optionalGroupKeyPerRow, exprEvaluatorContext);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].applyLeave(eventsPerStream, optionalGroupKeyPerRow, exprEvaluatorContext);
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId) {
        this.services.getArray()[agentInstanceId].setCurrentAccess(groupKey, agentInstanceId);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.services.getArray()[exprEvaluatorContext.getAgentInstanceId()].clearResults(exprEvaluatorContext);
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        return this.services.getArray()[agentInstanceId].getValue(column, agentInstanceId);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        return this.services.getArray()[context.getAgentInstanceId()].getCollection(column, context);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        return this.services.getArray()[context.getAgentInstanceId()].getEventBean(column, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }
}

