/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxy;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.ExpressionResultCacheService;
import com.espertech.esper.core.service.ExpressionResultCacheServiceAgentInstance;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.script.AgentInstanceScriptContext;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.StopCallback;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;

public class AgentInstanceContext
implements ExprEvaluatorContext {
    private final StatementContext statementContext;
    private final EPStatementAgentInstanceHandle epStatementAgentInstanceHandle;
    private final int agentInstanceId;
    private final AgentInstanceFilterProxy agentInstanceFilterProxy;
    private final MappedEventBean agentInstanceProperties;
    private final AgentInstanceScriptContext agentInstanceScriptContext;
    private final ExpressionResultCacheService expressionResultCacheService;
    private Object terminationCallbacks;

    public AgentInstanceContext(StatementContext statementContext, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, int agentInstanceId, AgentInstanceFilterProxy agentInstanceFilterProxy, MappedEventBean agentInstanceProperties, AgentInstanceScriptContext agentInstanceScriptContext) {
        this.statementContext = statementContext;
        this.epStatementAgentInstanceHandle = epStatementAgentInstanceHandle;
        this.agentInstanceId = agentInstanceId;
        this.agentInstanceFilterProxy = agentInstanceFilterProxy;
        this.agentInstanceProperties = agentInstanceProperties;
        this.agentInstanceScriptContext = agentInstanceScriptContext;
        this.expressionResultCacheService = statementContext.isStatelessSelect() ? statementContext.getExpressionResultCacheServiceSharable() : new ExpressionResultCacheServiceAgentInstance();
        this.terminationCallbacks = null;
    }

    public AgentInstanceFilterProxy getAgentInstanceFilterProxy() {
        return this.agentInstanceFilterProxy;
    }

    @Override
    public AgentInstanceScriptContext getAgentInstanceScriptContext() {
        return this.agentInstanceScriptContext;
    }

    @Override
    public TimeProvider getTimeProvider() {
        return this.statementContext.getTimeProvider();
    }

    @Override
    public ExpressionResultCacheService getExpressionResultCacheService() {
        return this.expressionResultCacheService;
    }

    @Override
    public int getAgentInstanceId() {
        return this.agentInstanceId;
    }

    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    public EPStatementAgentInstanceHandle getEpStatementAgentInstanceHandle() {
        return this.epStatementAgentInstanceHandle;
    }

    @Override
    public MappedEventBean getContextProperties() {
        return this.agentInstanceProperties;
    }

    public Collection<StopCallback> getTerminationCallbackRO() {
        if (this.terminationCallbacks == null) {
            return Collections.emptyList();
        }
        if (this.terminationCallbacks instanceof Collection) {
            return (Collection)this.terminationCallbacks;
        }
        return Collections.singletonList((StopCallback)this.terminationCallbacks);
    }

    public void addTerminationCallback(StopCallback callback) {
        if (this.terminationCallbacks == null) {
            this.terminationCallbacks = callback;
        } else if (this.terminationCallbacks instanceof Collection) {
            ((Collection)this.terminationCallbacks).add(callback);
        } else {
            StopCallback cb = (StopCallback)this.terminationCallbacks;
            ArrayDeque<StopCallback> q = new ArrayDeque<StopCallback>(2);
            q.add(cb);
            q.add(callback);
            this.terminationCallbacks = q;
        }
    }

    public void removeTerminationCallback(StopCallback callback) {
        if (this.terminationCallbacks == null) {
            return;
        }
        if (this.terminationCallbacks instanceof Collection) {
            ((Collection)this.terminationCallbacks).remove(callback);
        } else if (this.terminationCallbacks == callback) {
            this.terminationCallbacks = null;
        }
    }

    @Override
    public String getStatementName() {
        return this.statementContext.getStatementName();
    }

    @Override
    public String getEngineURI() {
        return this.statementContext.getEngineURI();
    }

    @Override
    public String getStatementId() {
        return this.statementContext.getStatementId();
    }

    @Override
    public StatementAgentInstanceLock getAgentInstanceLock() {
        return this.epStatementAgentInstanceHandle.getStatementAgentInstanceLock();
    }
}

