/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.core.service.EPStatementDispatch;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterFaultHandler;

public class EPStatementAgentInstanceHandle {
    private final EPStatementHandle statementHandle;
    private transient StatementAgentInstanceLock statementAgentInstanceLock = null;
    private final int agentInstanceId;
    private final StatementAgentInstanceFilterVersion statementFilterVersion;
    private transient EPStatementDispatch optionalDispatchable;
    private boolean destroyed;
    private final int hashCode;
    private FilterFaultHandler filterFaultHandler;

    public EPStatementAgentInstanceHandle(EPStatementHandle statementHandle, StatementAgentInstanceLock statementAgentInstanceLock, int agentInstanceId, StatementAgentInstanceFilterVersion statementFilterVersion) {
        this.statementHandle = statementHandle;
        this.statementAgentInstanceLock = statementAgentInstanceLock;
        this.agentInstanceId = agentInstanceId;
        this.hashCode = 31 * statementHandle.hashCode() + agentInstanceId;
        this.statementFilterVersion = statementFilterVersion;
    }

    public EPStatementHandle getStatementHandle() {
        return this.statementHandle;
    }

    public StatementAgentInstanceLock getStatementAgentInstanceLock() {
        return this.statementAgentInstanceLock;
    }

    public int getAgentInstanceId() {
        return this.agentInstanceId;
    }

    public int getPriority() {
        return this.statementHandle.getPriority();
    }

    public boolean isPreemptive() {
        return this.statementHandle.isPreemptive();
    }

    public boolean isHasVariables() {
        return this.statementHandle.isHasVariables();
    }

    public boolean isCanSelfJoin() {
        return this.statementHandle.isCanSelfJoin();
    }

    public void setStatementAgentInstanceLock(StatementAgentInstanceLock statementAgentInstanceLock) {
        this.statementAgentInstanceLock = statementAgentInstanceLock;
    }

    public StatementAgentInstanceFilterVersion getStatementFilterVersion() {
        return this.statementFilterVersion;
    }

    public boolean isCurrentFilter(long filterVersion) {
        return this.statementFilterVersion.isCurrentFilter(filterVersion);
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof EPStatementAgentInstanceHandle)) {
            return false;
        }
        EPStatementAgentInstanceHandle other = (EPStatementAgentInstanceHandle)otherObj;
        return other.getStatementHandle().getStatementId().equals(this.getStatementHandle().getStatementId()) && other.agentInstanceId == this.agentInstanceId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setOptionalDispatchable(EPStatementDispatch optionalDispatchable) {
        this.optionalDispatchable = optionalDispatchable;
    }

    public EPStatementDispatch getOptionalDispatchable() {
        return this.optionalDispatchable;
    }

    public void internalDispatch(ExprEvaluatorContext exprEvaluatorContext) {
        if (this.optionalDispatchable != null) {
            this.optionalDispatchable.execute(exprEvaluatorContext);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public String toString() {
        return "EPStatementAgentInstanceHandle{name=" + this.statementHandle.getStatementName() + '}';
    }

    public FilterFaultHandler getFilterFaultHandler() {
        return this.filterFaultHandler;
    }

    public void setFilterFaultHandler(FilterFaultHandler filterFaultHandler) {
        this.filterFaultHandler = filterFaultHandler;
    }

    public String getStatementId() {
        return this.statementHandle.getStatementId();
    }
}

