/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.factory.StatementAgentInstancePreload;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxy;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerTreeAgentInstanceList;
import com.espertech.esper.core.context.stmt.AIRegistryAggregation;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.script.AgentInstanceScriptContext;
import com.espertech.esper.epl.view.OutputProcessViewTerminable;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceUtil {
    private static final Log log = LogFactory.getLog(EPStatementStopMethodImpl.class);

    public static void handleFilterFault(EventBean theEvent, long version, EPServicesContext servicesContext, Map<Integer, ContextControllerTreeAgentInstanceList> agentInstanceListMap) {
        for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> agentInstanceEntry : agentInstanceListMap.entrySet()) {
            if (agentInstanceEntry.getValue().getFilterVersionAfterAllocation() <= version) continue;
            for (AgentInstance context : agentInstanceEntry.getValue().getAgentInstances()) {
                StatementAgentInstanceUtil.evaluateEventForStatement(servicesContext, theEvent, null, context.getAgentInstanceContext());
            }
        }
    }

    public static void stopAgentInstances(List<AgentInstance> agentInstances, Map<String, Object> terminationProperties, EPServicesContext servicesContext, boolean isStatementStop) {
        if (agentInstances == null) {
            return;
        }
        for (AgentInstance instance : agentInstances) {
            StatementAgentInstanceUtil.stopAgentInstance(instance, terminationProperties, servicesContext, isStatementStop);
        }
    }

    public static void stopAgentInstance(AgentInstance agentInstance, Map<String, Object> terminationProperties, EPServicesContext servicesContext, boolean isStatementStop) {
        if (terminationProperties != null) {
            agentInstance.getAgentInstanceContext().getContextProperties().getProperties().putAll(terminationProperties);
        }
        StatementAgentInstanceUtil.stop(agentInstance.getStopCallback(), agentInstance.getAgentInstanceContext(), agentInstance.getFinalView(), servicesContext, isStatementStop);
    }

    public static void stopSafe(Collection<StopCallback> terminationCallbacks, StopCallback[] stopCallbacks, StatementContext statementContext) {
        StopCallback[] terminationArr = terminationCallbacks.toArray(new StopCallback[terminationCallbacks.size()]);
        StatementAgentInstanceUtil.stopSafe(terminationArr, statementContext);
        StatementAgentInstanceUtil.stopSafe(stopCallbacks, statementContext);
    }

    public static void stopSafe(StopCallback[] stopMethods, StatementContext statementContext) {
        for (StopCallback stopCallback : stopMethods) {
            StatementAgentInstanceUtil.stopSafe(stopCallback, statementContext);
        }
    }

    public static void stopSafe(StopCallback stopMethod, StatementContext statementContext) {
        try {
            stopMethod.stop();
        }
        catch (RuntimeException e) {
            log.warn((Object)("Failed to perform statement stop for statement '" + statementContext.getStatementName() + "' expression '" + statementContext.getExpression() + "' : " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(StopCallback stopCallback, AgentInstanceContext agentInstanceContext, Viewable finalView, EPServicesContext servicesContext, boolean isStatementStop) {
        StatementAgentInstanceLock lock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        lock.acquireWriteLock(null);
        try {
            if (finalView instanceof OutputProcessViewTerminable && !isStatementStop) {
                OutputProcessViewTerminable terminable = (OutputProcessViewTerminable)((Object)finalView);
                terminable.terminated();
            }
            StatementAgentInstanceUtil.stopSafe(stopCallback, agentInstanceContext.getStatementContext());
            if (servicesContext.getSchedulableAgentInstanceDirectory() != null) {
                servicesContext.getSchedulableAgentInstanceDirectory().remove(agentInstanceContext.getStatementContext().getStatementId(), agentInstanceContext.getAgentInstanceId());
            }
            agentInstanceContext.getStatementContext().getMethodResolutionService().destroyedAgentInstance(agentInstanceContext.getAgentInstanceId());
            agentInstanceContext.getStatementContext().getStatementAgentInstanceRegistry().deassign(agentInstanceContext.getAgentInstanceId());
            agentInstanceContext.getEpStatementAgentInstanceHandle().setDestroyed(true);
            agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(Long.MAX_VALUE);
            if (agentInstanceContext.getStatementContext().getExtensionServicesContext() != null) {
                agentInstanceContext.getStatementContext().getExtensionServicesContext().endContextPartition(agentInstanceContext.getAgentInstanceId());
            }
        }
        finally {
            lock.releaseWriteLock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatementAgentInstanceFactoryResult start(EPServicesContext servicesContext, ContextControllerStatementBase statement, boolean isSingleInstanceContext, int agentInstanceId, MappedEventBean agentInstanceProperties, AgentInstanceFilterProxy agentInstanceFilterProxy, boolean isRecoveringResilient) {
        StatementContext statementContext = statement.getStatementContext();
        StatementAgentInstanceLock agentInstanceLock = isSingleInstanceContext ? statementContext.getDefaultAgentInstanceLock() : servicesContext.getStatementLockFactory().getStatementLock(statementContext.getStatementName(), statementContext.getExpression(), statementContext.getAnnotations(), statementContext.isStatelessSelect());
        StatementAgentInstanceFilterVersion filterVersion = new StatementAgentInstanceFilterVersion();
        EPStatementAgentInstanceHandle agentInstanceHandle = new EPStatementAgentInstanceHandle(statementContext.getEpStatementHandle(), agentInstanceLock, agentInstanceId, filterVersion);
        AgentInstanceScriptContext agentInstanceScriptContext = null;
        if (statementContext.getDefaultAgentInstanceScriptContext() != null) {
            agentInstanceScriptContext = new AgentInstanceScriptContext();
        }
        AgentInstanceContext agentInstanceContext = new AgentInstanceContext(statementContext, agentInstanceHandle, agentInstanceId, agentInstanceFilterProxy, agentInstanceProperties, agentInstanceScriptContext);
        StatementAgentInstanceLock statementAgentInstanceLock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        statementAgentInstanceLock.acquireWriteLock(null);
        try {
            StatementAgentInstanceFactoryResult startResult = statement.getFactory().newContext(agentInstanceContext, isRecoveringResilient);
            startResult.getFinalView().addView(statement.getMergeView());
            AIRegistryExpr aiExprSvc = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
            AIRegistryAggregation aiAggregationSvc = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceAggregationService();
            if (startResult.getOptionalAggegationService() != null) {
                aiAggregationSvc.assignService(agentInstanceId, startResult.getOptionalAggegationService());
            }
            for (Map.Entry<ExprSubselectNode, SubSelectStrategyHolder> entry : startResult.getSubselectStrategies().entrySet()) {
                ExprSubselectNode node = entry.getKey();
                SubSelectStrategyHolder strategyHolder = entry.getValue();
                aiExprSvc.getSubselectService(node).assignService(agentInstanceId, strategyHolder.getStategy());
                aiExprSvc.getSubselectAggregationService(node).assignService(agentInstanceId, strategyHolder.getSubselectAggregationService());
                for (Map.Entry<ExprPriorNode, ExprPriorEvalStrategy> entry2 : strategyHolder.getPriorStrategies().entrySet()) {
                    aiExprSvc.getPriorServices(entry2.getKey()).assignService(agentInstanceId, entry2.getValue());
                }
                for (Map.Entry<ExprNodeBase, Object> entry3 : strategyHolder.getPreviousNodeStrategies().entrySet()) {
                    aiExprSvc.getPreviousServices((ExprPreviousNode)entry3.getKey()).assignService(agentInstanceId, (ExprPreviousEvalStrategy)entry3.getValue());
                }
            }
            for (Map.Entry<ExprNodeBase, Object> entry : startResult.getPriorNodeStrategies().entrySet()) {
                aiExprSvc.getPriorServices((ExprPriorNode)entry.getKey()).assignService(agentInstanceId, (ExprPriorEvalStrategy)entry.getValue());
            }
            for (Map.Entry<ExprNodeBase, Object> entry : startResult.getPreviousNodeStrategies().entrySet()) {
                aiExprSvc.getPreviousServices((ExprPreviousNode)entry.getKey()).assignService(agentInstanceId, (ExprPreviousEvalStrategy)entry.getValue());
            }
            for (StatementAgentInstancePreload statementAgentInstancePreload : startResult.getPreloadList()) {
                statementAgentInstancePreload.executePreload();
            }
            if (statementContext.getExtensionServicesContext() != null) {
                statementContext.getExtensionServicesContext().startContextPartition(startResult, agentInstanceId);
            }
            StatementAgentInstanceFactoryResult statementAgentInstanceFactoryResult = startResult;
            return statementAgentInstanceFactoryResult;
        }
        finally {
            statementAgentInstanceLock.releaseWriteLock(null);
        }
    }

    public static void evaluateEventForStatement(EPServicesContext servicesContext, EventBean theEvent, Map<String, Object> optionalTriggeringPattern, AgentInstanceContext agentInstanceContext) {
        if (theEvent != null) {
            StatementAgentInstanceUtil.evaluateEventForStatementInternal(servicesContext, theEvent, agentInstanceContext);
        }
        if (optionalTriggeringPattern != null) {
            for (Map.Entry<String, Object> entry : optionalTriggeringPattern.entrySet()) {
                EventBean[] eventsArray;
                if (entry.getValue() instanceof EventBean) {
                    StatementAgentInstanceUtil.evaluateEventForStatementInternal(servicesContext, (EventBean)entry.getValue(), agentInstanceContext);
                    continue;
                }
                if (!(entry.getValue() instanceof EventBean[])) continue;
                for (EventBean eventElement : eventsArray = (EventBean[])entry.getValue()) {
                    StatementAgentInstanceUtil.evaluateEventForStatementInternal(servicesContext, eventElement, agentInstanceContext);
                }
            }
        }
    }

    private static void evaluateEventForStatementInternal(EPServicesContext servicesContext, EventBean theEvent, AgentInstanceContext agentInstanceContext) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>();
        servicesContext.getFilterService().evaluate(theEvent, callbacks, agentInstanceContext.getStatementContext().getStatementId());
        try {
            servicesContext.getVariableService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                EPStatementHandleCallback callback = (EPStatementHandleCallback)handle;
                if (callback.getAgentInstanceHandle() != agentInstanceContext.getEpStatementAgentInstanceHandle()) continue;
                callback.getFilterCallback().matchFound(theEvent, null);
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch(agentInstanceContext);
            servicesContext.getInternalEventEngineRouteDest().dispatch();
        }
        catch (RuntimeException ex) {
            servicesContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle());
        }
    }

    public static boolean evaluateFilterForStatement(EPServicesContext servicesContext, EventBean theEvent, AgentInstanceContext agentInstanceContext, FilterHandle filterHandle) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>();
        servicesContext.getFilterService().evaluate(theEvent, callbacks, agentInstanceContext.getStatementContext().getStatementId());
        try {
            servicesContext.getVariableService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                if (handle != filterHandle) continue;
                return true;
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch(agentInstanceContext);
        }
        catch (RuntimeException ex) {
            servicesContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle());
        }
        return false;
    }

    public static StopCallback getStopCallback(List<StopCallback> stopCallbacks, final AgentInstanceContext agentInstanceContext) {
        final StopCallback[] stopCallbackArr = stopCallbacks.toArray(new StopCallback[stopCallbacks.size()]);
        return new StopCallback(){

            @Override
            public void stop() {
                StatementAgentInstanceUtil.stopSafe(agentInstanceContext.getTerminationCallbackRO(), stopCallbackArr, agentInstanceContext.getStatementContext());
            }
        };
    }
}

