/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.deploy;

import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.deploy.Module;
import com.espertech.esper.client.deploy.ModuleItem;
import com.espertech.esper.client.deploy.ParseException;
import com.espertech.esper.core.deploy.EPDeploymentAdminImpl;
import com.espertech.esper.core.deploy.EPLModuleParseItem;
import com.espertech.esper.core.deploy.ParseNode;
import com.espertech.esper.core.deploy.ParseNodeComment;
import com.espertech.esper.core.deploy.ParseNodeExpression;
import com.espertech.esper.core.deploy.ParseNodeImport;
import com.espertech.esper.core.deploy.ParseNodeModule;
import com.espertech.esper.core.deploy.ParseNodeUses;
import com.espertech.esper.core.service.StatementEventTypeRef;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPLModuleUtil {
    private static Log log = LogFactory.getLog(EPLModuleUtil.class);
    public static final String newline = System.getProperty("line.separator");

    public static Module readInternal(InputStream stream, String resourceName) throws IOException, ParseException {
        String strLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringWriter buffer = new StringWriter();
        while ((strLine = br.readLine()) != null) {
            buffer.append(strLine);
            buffer.append(newline);
        }
        stream.close();
        return EPLModuleUtil.parseInternal(buffer.toString(), resourceName);
    }

    public static Module parseInternal(String buffer, String resourceName) throws IOException, ParseException {
        List<EPLModuleParseItem> semicolonSegments = EPLModuleUtil.parse(buffer.toString());
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
        for (EPLModuleParseItem segment : semicolonSegments) {
            nodes.add(EPLModuleUtil.getModule(segment, resourceName));
        }
        String moduleName = null;
        int count = 0;
        for (ParseNode node : nodes) {
            if (node instanceof ParseNodeComment) continue;
            if (node instanceof ParseNodeModule) {
                if (moduleName != null) {
                    throw new ParseException("Duplicate use of the 'module' keyword for resource '" + resourceName + "'");
                }
                if (count > 0) {
                    throw new ParseException("The 'module' keyword must be the first declaration in the module file for resource '" + resourceName + "'");
                }
                moduleName = ((ParseNodeModule)node).getModuleName();
            }
            ++count;
        }
        LinkedHashSet<String> uses = new LinkedHashSet<String>();
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        count = 0;
        for (ParseNode node : nodes) {
            if (node instanceof ParseNodeComment || node instanceof ParseNodeModule) continue;
            String message = "The 'uses' and 'import' keywords must be the first declaration in the module file or follow the 'module' declaration";
            if (node instanceof ParseNodeUses) {
                if (count > 0) {
                    throw new ParseException(message);
                }
                uses.add(((ParseNodeUses)node).getUses());
                continue;
            }
            if (node instanceof ParseNodeImport) {
                if (count > 0) {
                    throw new ParseException(message);
                }
                imports.add(((ParseNodeImport)node).getImported());
                continue;
            }
            ++count;
        }
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        for (ParseNode node : nodes) {
            if (!(node instanceof ParseNodeComment) && !(node instanceof ParseNodeExpression)) continue;
            boolean isComments = node instanceof ParseNodeComment;
            items.add(new ModuleItem(node.getItem().getExpression(), isComments, node.getItem().getLineNum(), node.getItem().getStartChar(), node.getItem().getEndChar()));
        }
        return new Module(moduleName, resourceName, uses, imports, items, buffer);
    }

    public static List<EventType> undeployTypes(Set<String> referencedTypes, StatementEventTypeRef statementEventTypeRef, EventAdapterService eventAdapterService, FilterService filterService) {
        ArrayList<EventType> undeployedTypes = new ArrayList<EventType>();
        for (String typeName : referencedTypes) {
            EventTypeSPI spi;
            EventType type;
            boolean typeInUse = statementEventTypeRef.isInUse(typeName);
            if (typeInUse) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Event type '" + typeName + "' is in use, not removing type"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event type '" + typeName + "' is no longer in use, removing type"));
            }
            if ((type = eventAdapterService.getExistsTypeByName(typeName)) == null || (spi = (EventTypeSPI)type).getMetadata().isApplicationPreConfigured()) continue;
            eventAdapterService.removeType(typeName);
            undeployedTypes.add(spi);
            filterService.removeType(spi);
        }
        return undeployedTypes;
    }

    public static ParseNode getModule(EPLModuleParseItem item, String resourceName) throws ParseException, IOException {
        NoCaseSensitiveStream input = new NoCaseSensitiveStream(new StringReader(item.getExpression()));
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer((CharStream)input);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lex);
        List tokens = tokenStream.getTokens();
        boolean isMeta = false;
        boolean isModule = false;
        boolean isUses = false;
        boolean isExpression = false;
        for (int beginIndex = 0; beginIndex < tokens.size(); ++beginIndex) {
            Token t = (Token)tokens.get(beginIndex);
            if (t.getType() == 377 || t.getType() == 378 || t.getType() == 379) {
                continue;
            }
            String tokenText = t.getText().trim().toLowerCase();
            if (tokenText.equals("module")) {
                isModule = true;
                isMeta = true;
            } else if (tokenText.equals("uses")) {
                isUses = true;
                isMeta = true;
            } else if (tokenText.equals("import")) {
                isMeta = true;
            } else {
                isExpression = true;
                break;
            }
            ++beginIndex;
            ++beginIndex;
            break;
        }
        if (isExpression) {
            return new ParseNodeExpression(item);
        }
        if (!isMeta) {
            return new ParseNodeComment(item);
        }
        StringWriter buffer = new StringWriter();
        for (int i = beginIndex; i < tokens.size(); ++i) {
            Token t = (Token)tokens.get(i);
            if (t.getType() != 325 && t.getType() != 335 && t.getType() != 336 && !t.getText().matches("[a-zA-Z]*")) {
                throw EPLModuleUtil.getMessage(isModule, isUses, resourceName, t.getType());
            }
            buffer.append(t.getText().trim());
        }
        String result = buffer.toString().trim();
        if (result.length() == 0) {
            throw EPLModuleUtil.getMessage(isModule, isUses, resourceName, -1);
        }
        if (isModule) {
            return new ParseNodeModule(item, result);
        }
        if (isUses) {
            return new ParseNodeUses(item, result);
        }
        return new ParseNodeImport(item, result);
    }

    private static ParseException getMessage(boolean module, boolean uses, String resourceName, int type) {
        String message = "Keyword '";
        message = module ? message + "module" : (uses ? message + "uses" : message + "import");
        message = message + "' must be followed by a name or package name (set of names separated by dots) for resource '" + resourceName + "'";
        if (type != -1) {
            String tokenName = EsperEPL2GrammarParser.getLexerTokenParaphrases().get(type);
            if (tokenName == null) {
                tokenName = EsperEPL2GrammarParser.getParserTokenParaphrases().get(type);
            }
            if (tokenName != null) {
                message = message + ", unexpected reserved keyword " + tokenName + " was encountered as part of the name";
            }
        }
        return new ParseException(message);
    }

    public static List<EPLModuleParseItem> parse(String module) {
        NoCaseSensitiveStream input;
        try {
            input = new NoCaseSensitiveStream(new StringReader(module));
        }
        catch (IOException ex) {
            log.error((Object)("Exception reading model expression: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        ArrayList<EPLModuleParseItem> statements = new ArrayList<EPLModuleParseItem>();
        StringWriter current = new StringWriter();
        Integer lineNum = null;
        int charPosStart = 0;
        int charPos = 0;
        for (Object token : tokens.getTokens()) {
            Token t = (Token)token;
            if (t.getType() == 376) {
                if (current.toString().trim().length() > 0) {
                    statements.add(new EPLModuleParseItem(current.toString().trim(), lineNum == null ? 0 : lineNum, charPosStart, charPos));
                    lineNum = null;
                }
                current = new StringWriter();
                continue;
            }
            if (lineNum == null && t.getType() != 377) {
                lineNum = t.getLine();
                charPosStart = charPos;
            }
            current.append(t.getText());
            charPos += t.getText().length();
        }
        if (current.toString().trim().length() > 0) {
            statements.add(new EPLModuleParseItem(current.toString().trim(), lineNum == null ? 0 : lineNum, 0, 0));
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module readFile(File file) throws IOException, ParseException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Module module = EPLModuleUtil.readInternal(inputStream, file.getAbsolutePath());
            return module;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing input stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module readResource(String resource) throws IOException, ParseException {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = EPDeploymentAdminImpl.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = EPDeploymentAdminImpl.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new IOException("Failed to find resource '" + resource + "' in classpath");
        }
        try {
            Module module = EPLModuleUtil.readInternal(stream, resource);
            return module;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.debug((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }
}

