/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationOperations;
import com.espertech.esper.client.ConfigurationPlugInAggregationFunction;
import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.ConfigurationPlugInView;
import com.espertech.esper.client.ConfigurationPlugInVirtualDataWindow;
import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.StatementEventTypeRef;
import com.espertech.esper.core.service.StatementVariableRef;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineSettingsService;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.spec.PluggableObjectCollection;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableTypeException;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.event.vaevent.VariantEventType;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.XSDSchemaMapper;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolEngineSvc;
import com.espertech.esper.util.JavaClassHelper;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigurationOperationsImpl
implements ConfigurationOperations {
    private final EventAdapterService eventAdapterService;
    private final EventTypeIdGenerator eventTypeIdGenerator;
    private final EngineImportService engineImportService;
    private final VariableService variableService;
    private final EngineSettingsService engineSettingsService;
    private final ValueAddEventService valueAddEventService;
    private final MetricReportingService metricReportingService;
    private final StatementEventTypeRef statementEventTypeRef;
    private final StatementVariableRef statementVariableRef;
    private final PluggableObjectCollection plugInViews;
    private final FilterService filterService;
    private final PatternSubexpressionPoolEngineSvc patternSubexpressionPoolSvc;

    public ConfigurationOperationsImpl(EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator, EngineImportService engineImportService, VariableService variableService, EngineSettingsService engineSettingsService, ValueAddEventService valueAddEventService, MetricReportingService metricReportingService, StatementEventTypeRef statementEventTypeRef, StatementVariableRef statementVariableRef, PluggableObjectCollection plugInViews, FilterService filterService, PatternSubexpressionPoolEngineSvc patternSubexpressionPoolSvc) {
        this.eventAdapterService = eventAdapterService;
        this.eventTypeIdGenerator = eventTypeIdGenerator;
        this.engineImportService = engineImportService;
        this.variableService = variableService;
        this.engineSettingsService = engineSettingsService;
        this.valueAddEventService = valueAddEventService;
        this.metricReportingService = metricReportingService;
        this.statementEventTypeRef = statementEventTypeRef;
        this.statementVariableRef = statementVariableRef;
        this.plugInViews = plugInViews;
        this.filterService = filterService;
        this.patternSubexpressionPoolSvc = patternSubexpressionPoolSvc;
    }

    @Override
    public void addEventTypeAutoName(String javaPackageName) {
        this.eventAdapterService.addAutoNamePackage(javaPackageName);
    }

    @Override
    public void addPlugInView(String namespace, String name, String viewFactoryClass) {
        ConfigurationPlugInView configurationPlugInView = new ConfigurationPlugInView();
        configurationPlugInView.setNamespace(namespace);
        configurationPlugInView.setName(name);
        configurationPlugInView.setFactoryClassName(viewFactoryClass);
        this.plugInViews.addViews(Collections.singletonList(configurationPlugInView), Collections.<ConfigurationPlugInVirtualDataWindow>emptyList());
    }

    @Override
    public void addPlugInAggregationFunction(String functionName, String aggregationClassName) {
        try {
            ConfigurationPlugInAggregationFunction desc = new ConfigurationPlugInAggregationFunction(functionName, aggregationClassName, null);
            this.engineImportService.addAggregation(functionName, desc);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addPlugInAggregationMultiFunction(ConfigurationPlugInAggregationMultiFunction config) throws ConfigurationException {
        try {
            this.engineImportService.addAggregationMultiFunction(config);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addPlugInAggregationFunctionFactory(String functionName, String aggregationFactoryClassName) {
        try {
            ConfigurationPlugInAggregationFunction desc = new ConfigurationPlugInAggregationFunction(functionName, null, aggregationFactoryClassName);
            this.engineImportService.addAggregation(functionName, desc);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName) throws ConfigurationException {
        this.internalAddPlugInSingleRowFunction(functionName, className, methodName, ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED, ConfigurationPlugInSingleRowFunction.FilterOptimizable.ENABLED, false);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache) throws ConfigurationException {
        this.internalAddPlugInSingleRowFunction(functionName, className, methodName, valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable.ENABLED, false);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable) throws ConfigurationException {
        this.internalAddPlugInSingleRowFunction(functionName, className, methodName, ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED, filterOptimizable, false);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable, boolean rethrowExceptions) throws ConfigurationException {
        this.internalAddPlugInSingleRowFunction(functionName, className, methodName, valueCache, filterOptimizable, rethrowExceptions);
    }

    private void internalAddPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable, boolean rethrowExceptions) throws ConfigurationException {
        try {
            this.engineImportService.addSingleRow(functionName, className, methodName, valueCache, filterOptimizable, rethrowExceptions);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addImport(String importName) {
        try {
            this.engineImportService.addImport(importName);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addImport(Class importClass) {
        this.addImport(importClass.getName());
    }

    @Override
    public boolean isEventTypeExists(String eventTypeName) {
        return this.eventAdapterService.getExistsTypeByName(eventTypeName) != null;
    }

    @Override
    public void addEventType(String eventTypeName, String javaEventClassName) {
        try {
            this.eventAdapterService.addBeanType(eventTypeName, javaEventClassName, false, false, true, true);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Class javaEventClass) {
        try {
            this.eventAdapterService.addBeanType(eventTypeName, javaEventClass, false, true, true);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(Class javaEventClass) {
        try {
            this.eventAdapterService.addBeanType(javaEventClass.getSimpleName(), javaEventClass, false, true, true);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Properties typeMap) {
        Map<String, Object> types = JavaClassHelper.getClassObjectFromPropertyTypeNames(typeMap);
        try {
            this.eventAdapterService.addNestableMapType(eventTypeName, types, null, false, true, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap) {
        try {
            Map<String, Object> compiledProperties = EventTypeUtility.compileMapTypeProperties(typeMap, this.eventAdapterService);
            this.eventAdapterService.addNestableMapType(eventTypeName, compiledProperties, null, false, true, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap, String[] superTypes) throws ConfigurationException {
        ConfigurationEventTypeMap optionalConfig = null;
        if (superTypes != null && superTypes.length > 0) {
            optionalConfig = new ConfigurationEventTypeMap();
            optionalConfig.getSuperTypes().addAll(Arrays.asList(superTypes));
        }
        try {
            this.eventAdapterService.addNestableMapType(eventTypeName, typeMap, optionalConfig, false, true, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap, ConfigurationEventTypeMap mapConfig) throws ConfigurationException {
        try {
            this.eventAdapterService.addNestableMapType(eventTypeName, typeMap, mapConfig, false, true, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, String[] propertyNames, Object[] propertyTypes) throws ConfigurationException {
        this.addEventType(eventTypeName, propertyNames, propertyTypes, null);
    }

    @Override
    public void addEventType(String eventTypeName, String[] propertyNames, Object[] propertyTypes, ConfigurationEventTypeObjectArray optionalConfiguration) throws ConfigurationException {
        try {
            LinkedHashMap<String, Object> propertyTypesMap = EventTypeUtility.validateObjectArrayDef(propertyNames, propertyTypes);
            Map<String, Object> compiledProperties = EventTypeUtility.compileMapTypeProperties(propertyTypesMap, this.eventAdapterService);
            this.eventAdapterService.addNestableObjectArrayType(eventTypeName, compiledProperties, optionalConfiguration, false, true, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc) {
        SchemaModel schemaModel = null;
        if (xmlDOMEventTypeDesc.getSchemaResource() != null || xmlDOMEventTypeDesc.getSchemaText() != null) {
            try {
                schemaModel = XSDSchemaMapper.loadAndMap(xmlDOMEventTypeDesc.getSchemaResource(), xmlDOMEventTypeDesc.getSchemaText(), 2);
            }
            catch (Exception ex) {
                throw new ConfigurationException(ex.getMessage(), ex);
            }
        }
        try {
            this.eventAdapterService.addXMLDOMType(eventTypeName, xmlDOMEventTypeDesc, schemaModel, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addVariable(String variableName, Class type, Object initializationValue) throws ConfigurationException {
        this.addVariable(variableName, type.getName(), initializationValue, false);
    }

    @Override
    public void addVariable(String variableName, String eventTypeName, Object initializationValue) throws ConfigurationException {
        this.addVariable(variableName, eventTypeName, initializationValue, false);
    }

    @Override
    public void addVariable(String variableName, String type, Object initializationValue, boolean constant) throws ConfigurationException {
        try {
            Pair<String, Boolean> arrayType = JavaClassHelper.isGetArrayType(type);
            this.variableService.createNewVariable(variableName, arrayType.getFirst(), initializationValue, constant, arrayType.getSecond(), null, this.engineImportService);
            this.statementVariableRef.addConfiguredVariable(variableName);
        }
        catch (VariableExistsException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
        catch (VariableTypeException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
    }

    @Override
    public void addPlugInEventType(String eventTypeName, URI[] resolutionURIs, Serializable initializer) {
        try {
            this.eventAdapterService.addPlugInEventType(eventTypeName, resolutionURIs, initializer);
        }
        catch (EventAdapterException e) {
            throw new ConfigurationException("Error adding plug-in event type: " + e.getMessage(), e);
        }
    }

    @Override
    public void setPlugInEventTypeResolutionURIs(URI[] urisToResolveName) {
        this.engineSettingsService.setPlugInEventTypeResolutionURIs(urisToResolveName);
    }

    @Override
    public void addRevisionEventType(String revisioneventTypeName, ConfigurationRevisionEventType revisionEventTypeConfig) {
        this.valueAddEventService.addRevisionEventType(revisioneventTypeName, revisionEventTypeConfig, this.eventAdapterService);
    }

    @Override
    public void addVariantStream(String varianteventTypeName, ConfigurationVariantStream variantStreamConfig) {
        this.valueAddEventService.addVariantStream(varianteventTypeName, variantStreamConfig, this.eventAdapterService, this.eventTypeIdGenerator);
    }

    @Override
    public void updateMapEventType(String mapeventTypeName, Map<String, Object> typeMap) throws ConfigurationException {
        try {
            this.eventAdapterService.updateMapEventType(mapeventTypeName, typeMap);
        }
        catch (EventAdapterException e) {
            throw new ConfigurationException("Error updating Map event type: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateObjectArrayEventType(String objectArrayEventTypeName, String[] propertyNames, Object[] propertyTypes) throws ConfigurationException {
        try {
            LinkedHashMap<String, Object> typeMap = EventTypeUtility.validateObjectArrayDef(propertyNames, propertyTypes);
            this.eventAdapterService.updateObjectArrayEventType(objectArrayEventTypeName, typeMap);
        }
        catch (EventAdapterException e) {
            throw new ConfigurationException("Error updating Object-array event type: " + e.getMessage(), e);
        }
    }

    @Override
    public void replaceXMLEventType(String xmlEventTypeName, ConfigurationEventTypeXMLDOM config) throws ConfigurationException {
        SchemaModel schemaModel = null;
        if (config.getSchemaResource() != null || config.getSchemaText() != null) {
            try {
                schemaModel = XSDSchemaMapper.loadAndMap(config.getSchemaResource(), config.getSchemaText(), 2);
            }
            catch (Exception ex) {
                throw new ConfigurationException(ex.getMessage(), ex);
            }
        }
        try {
            this.eventAdapterService.replaceXMLEventType(xmlEventTypeName, config, schemaModel);
        }
        catch (EventAdapterException e) {
            throw new ConfigurationException("Error updating XML event type: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingInterval(String stmtGroupName, long newInterval) {
        try {
            this.metricReportingService.setMetricsReportingInterval(stmtGroupName, newInterval);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error updating interval for metric reporting: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingStmtEnabled(String statementName) {
        try {
            this.metricReportingService.setMetricsReportingStmtEnabled(statementName);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting for statement: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingStmtDisabled(String statementName) {
        try {
            this.metricReportingService.setMetricsReportingStmtDisabled(statementName);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting for statement: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingEnabled() {
        try {
            this.metricReportingService.setMetricsReportingEnabled();
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingDisabled() {
        try {
            this.metricReportingService.setMetricsReportingDisabled();
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isVariantStreamExists(String name) {
        ValueAddEventProcessor processor = this.valueAddEventService.getValueAddProcessor(name);
        if (processor == null) {
            return false;
        }
        return processor.getValueAddEventType() instanceof VariantEventType;
    }

    @Override
    public boolean removeEventType(String name, boolean force) throws ConfigurationException {
        Set<String> statements;
        if (!force && (statements = this.statementEventTypeRef.getStatementNamesForType(name)) != null && !statements.isEmpty()) {
            throw new ConfigurationException("Event type '" + name + "' is in use by one or more statements");
        }
        EventType type = this.eventAdapterService.getExistsTypeByName(name);
        if (type == null) {
            return false;
        }
        this.eventAdapterService.removeType(name);
        this.statementEventTypeRef.removeReferencesType(name);
        this.filterService.removeType(type);
        return true;
    }

    @Override
    public boolean removeVariable(String name, boolean force) throws ConfigurationException {
        Set<String> statements;
        if (!force && (statements = this.statementVariableRef.getStatementNamesForVar(name)) != null && !statements.isEmpty()) {
            throw new ConfigurationException("Variable '" + name + "' is in use by one or more statements");
        }
        VariableReader reader = this.variableService.getReader(name);
        if (reader == null) {
            return false;
        }
        this.variableService.removeVariable(name);
        this.statementVariableRef.removeReferencesVariable(name);
        this.statementVariableRef.removeConfiguredVariable(name);
        return true;
    }

    @Override
    public Set<String> getEventTypeNameUsedBy(String name) {
        Set<String> statements = this.statementEventTypeRef.getStatementNamesForType(name);
        if (statements == null || statements.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(statements);
    }

    @Override
    public Set<String> getVariableNameUsedBy(String variableName) {
        Set<String> statements = this.statementVariableRef.getStatementNamesForVar(variableName);
        if (statements == null || statements.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(statements);
    }

    @Override
    public EventType getEventType(String eventTypeName) {
        return this.eventAdapterService.getExistsTypeByName(eventTypeName);
    }

    @Override
    public EventType[] getEventTypes() {
        return this.eventAdapterService.getAllTypes();
    }

    @Override
    public void addEventType(String eventTypeName, String eventClass, ConfigurationEventTypeLegacy legacyEventTypeDesc) {
        try {
            HashMap<String, ConfigurationEventTypeLegacy> map = new HashMap<String, ConfigurationEventTypeLegacy>();
            map.put(eventClass, legacyEventTypeDesc);
            this.eventAdapterService.setClassLegacyConfigs(map);
            this.eventAdapterService.addBeanType(eventTypeName, eventClass, false, false, false, true);
        }
        catch (EventAdapterException ex) {
            throw new ConfigurationException("Failed to add legacy event type definition for type '" + eventTypeName + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public void setPatternMaxSubexpressions(Long maxSubexpressions) {
        this.patternSubexpressionPoolSvc.setPatternMaxSubexpressions(maxSubexpressions);
    }
}

