/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EPStatementSyntaxException;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.declexpr.ExprDeclaredService;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.parse.ParseHelper;
import com.espertech.esper.epl.parse.ParseResult;
import com.espertech.esper.epl.parse.ParseRuleSelector;
import com.espertech.esper.epl.parse.WalkRuleSelector;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.pattern.PatternNodeFactory;
import com.espertech.esper.schedule.SchedulingService;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPAdministratorHelper {
    private static ParseRuleSelector patternParseRule = new ParseRuleSelector(){

        @Override
        public Tree invokeParseRule(EsperEPL2GrammarParser parser) throws RecognitionException {
            EsperEPL2GrammarParser.startPatternExpressionRule_return r = parser.startPatternExpressionRule();
            return (Tree)r.getTree();
        }
    };
    private static ParseRuleSelector eplParseRule;
    private static WalkRuleSelector patternWalkRule;
    private static WalkRuleSelector eplWalkRule;
    private static Log log;

    public static StatementSpecRaw compileEPL(String eplStatement, String eplStatementForErrorMsg, boolean addPleaseCheck, String statementName, EPServicesContext services, SelectClauseStreamSelectorEnum defaultStreamSelector) {
        return EPAdministratorHelper.compileEPL(eplStatement, eplStatementForErrorMsg, addPleaseCheck, statementName, defaultStreamSelector, services.getEngineImportService(), services.getVariableService(), services.getSchedulingService(), services.getEngineURI(), services.getConfigSnapshot(), services.getPatternNodeFactory(), services.getContextManagementService(), services.getExprDeclaredService());
    }

    public static StatementSpecRaw compileEPL(String eplStatement, String eplStatementForErrorMsg, boolean addPleaseCheck, String statementName, SelectClauseStreamSelectorEnum defaultStreamSelector, EngineImportService engineImportService, VariableService variableService, SchedulingService schedulingService, String engineURI, ConfigurationInformation configSnapshot, PatternNodeFactory patternNodeFactory, ContextManagementService contextManagementService, ExprDeclaredService exprDeclaredService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(".createEPLStmt statementName=" + statementName + " eplStatement=" + eplStatement));
        }
        ParseResult parseResult = ParseHelper.parse(eplStatement, eplStatementForErrorMsg, addPleaseCheck, eplParseRule, true);
        Tree ast = parseResult.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        EPLTreeWalker walker = new EPLTreeWalker((TreeNodeStream)nodes, parseResult.getTokenStream(), engineImportService, variableService, schedulingService, defaultStreamSelector, engineURI, configSnapshot, patternNodeFactory, contextManagementService, parseResult.getScripts(), exprDeclaredService);
        try {
            ParseHelper.walk(ast, walker, eplWalkRule, eplStatement, eplStatementForErrorMsg);
        }
        catch (ASTWalkException ex) {
            log.error((Object)".createEPL Error validating expression", (Throwable)ex);
            throw new EPStatementException(ex.getMessage(), ex, eplStatementForErrorMsg);
        }
        catch (EPStatementSyntaxException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            String message = "Error in expression";
            log.debug((Object)message, (Throwable)ex);
            throw new EPStatementException(EPAdministratorHelper.getNullableErrortext(message, ex.getMessage()), ex, eplStatementForErrorMsg);
        }
        if (log.isDebugEnabled()) {
            ASTUtil.dumpAST(ast);
        }
        StatementSpecRaw raw = walker.getStatementSpec();
        raw.setExpressionNoAnnotations(parseResult.getExpressionWithoutAnnotations());
        return raw;
    }

    public static StatementSpecRaw compilePattern(String expression, String expressionForErrorMessage, boolean addPleaseCheck, EPServicesContext services, SelectClauseStreamSelectorEnum defaultStreamSelector) {
        ParseResult parseResult = ParseHelper.parse(expression, expressionForErrorMessage, addPleaseCheck, patternParseRule, true);
        Tree ast = parseResult.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        EPLTreeWalker walker = new EPLTreeWalker((TreeNodeStream)nodes, parseResult.getTokenStream(), services.getEngineImportService(), services.getVariableService(), services.getSchedulingService(), defaultStreamSelector, services.getEngineURI(), services.getConfigSnapshot(), services.getPatternNodeFactory(), services.getContextManagementService(), parseResult.getScripts(), services.getExprDeclaredService());
        try {
            ParseHelper.walk(ast, walker, patternWalkRule, expression, expressionForErrorMessage);
        }
        catch (ASTWalkException ex) {
            log.debug((Object)".createPattern Error validating expression", (Throwable)ex);
            throw new EPStatementException(ex.getMessage(), expression);
        }
        catch (EPStatementSyntaxException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            String message = "Error in expression";
            log.debug((Object)message, (Throwable)ex);
            throw new EPStatementException(EPAdministratorHelper.getNullableErrortext(message, ex.getMessage()), expression);
        }
        if (log.isDebugEnabled()) {
            ASTUtil.dumpAST(ast);
        }
        if (walker.getStatementSpec().getStreamSpecs().size() > 1) {
            throw new IllegalStateException("Unexpected multiple stream specifications encountered");
        }
        PatternStreamSpecRaw patternStreamSpec = (PatternStreamSpecRaw)walker.getStatementSpec().getStreamSpecs().get(0);
        StatementSpecRaw statementSpec = new StatementSpecRaw(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        statementSpec.getStreamSpecs().add(patternStreamSpec);
        statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        statementSpec.getSelectClauseSpec().getSelectExprList().add(new SelectClauseElementWildcard());
        statementSpec.setAnnotations(walker.getStatementSpec().getAnnotations());
        statementSpec.setExpressionNoAnnotations(parseResult.getExpressionWithoutAnnotations());
        return statementSpec;
    }

    private static String getNullableErrortext(String msg, String cause) {
        if (cause == null) {
            return msg;
        }
        return msg + ": " + cause;
    }

    static {
        patternWalkRule = new WalkRuleSelector(){

            @Override
            public void invokeWalkRule(EPLTreeWalker walker) throws RecognitionException {
                walker.startPatternExpressionRule();
            }
        };
        eplParseRule = new ParseRuleSelector(){

            @Override
            public Tree invokeParseRule(EsperEPL2GrammarParser parser) throws RecognitionException {
                EsperEPL2GrammarParser.startEPLExpressionRule_return r = parser.startEPLExpressionRule();
                return (Tree)r.getTree();
            }
        };
        eplWalkRule = new WalkRuleSelector(){

            @Override
            public void invokeWalkRule(EPLTreeWalker walker) throws RecognitionException {
                walker.startEPLExpressionRule();
            }
        };
        log = LogFactory.getLog(EPAdministratorHelper.class);
    }
}

