/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPAdministratorIsolated;
import com.espertech.esper.client.EPRuntimeIsolated;
import com.espertech.esper.core.service.EPAdministratorIsolatedImpl;
import com.espertech.esper.core.service.EPIsolationUnitServices;
import com.espertech.esper.core.service.EPRuntimeIsolatedImpl;
import com.espertech.esper.core.service.EPServiceProviderIsolatedSPI;
import com.espertech.esper.core.service.EPServicesContext;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPServiceProviderIsolatedImpl
implements EPServiceProviderIsolatedSPI {
    private static final Log log = LogFactory.getLog(EPServiceProviderIsolatedImpl.class);
    private final String name;
    private final EPRuntimeIsolatedImpl runtime;
    private final EPAdministratorIsolatedImpl admin;
    private final EPIsolationUnitServices isolatedServices;
    private final Map<String, EPServiceProviderIsolatedImpl> providers;

    public EPServiceProviderIsolatedImpl(String name, EPIsolationUnitServices isolatedServices, EPServicesContext unisolatedSvc, Map<String, EPServiceProviderIsolatedImpl> providers) {
        this.name = name;
        this.providers = providers;
        this.isolatedServices = isolatedServices;
        this.runtime = new EPRuntimeIsolatedImpl(isolatedServices, unisolatedSvc);
        this.admin = new EPAdministratorIsolatedImpl(name, isolatedServices, unisolatedSvc, this.runtime);
    }

    @Override
    public EPIsolationUnitServices getIsolatedServices() {
        return this.isolatedServices;
    }

    @Override
    public EPRuntimeIsolated getEPRuntime() {
        return this.runtime;
    }

    @Override
    public EPAdministratorIsolated getEPAdministrator() {
        return this.admin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void destroy() {
        this.providers.remove(this.name);
        this.admin.removeAllStatements();
    }
}

