/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.StatementAwareUpdateListener;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.util.CollectionUtil;

public class EPStatementListenerSet {
    private static final UpdateListener[] EMPTY_UPDLISTEN_ARRAY = new UpdateListener[0];
    private static final StatementAwareUpdateListener[] EMPTY_UPDLISTENSA_ARRAY = new StatementAwareUpdateListener[0];
    private Object subscriber;
    private volatile UpdateListener[] listeners;
    private volatile StatementAwareUpdateListener[] stmtAwareListeners;

    public EPStatementListenerSet() {
        this.listeners = EMPTY_UPDLISTEN_ARRAY;
        this.stmtAwareListeners = EMPTY_UPDLISTENSA_ARRAY;
    }

    public EPStatementListenerSet(UpdateListener[] listeners, StatementAwareUpdateListener[] stmtAwareListeners) {
        this.listeners = listeners;
        this.stmtAwareListeners = stmtAwareListeners;
    }

    public UpdateListener[] getListeners() {
        return this.listeners;
    }

    public StatementAwareUpdateListener[] getStmtAwareListeners() {
        return this.stmtAwareListeners;
    }

    public void setListeners(EPStatementListenerSet listenerSet) {
        this.listeners = listenerSet.getListeners();
        this.stmtAwareListeners = listenerSet.getStmtAwareListeners();
    }

    public synchronized void addListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        for (UpdateListener existing : this.listeners) {
            if (existing != listener) continue;
            return;
        }
        this.listeners = (UpdateListener[])CollectionUtil.arrayExpandAddSingle(this.listeners, listener);
    }

    public synchronized void removeListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        int index = -1;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != listener) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        this.listeners = (UpdateListener[])CollectionUtil.arrayShrinkRemoveSingle(this.listeners, index);
    }

    public synchronized void removeAllListeners() {
        this.listeners = EMPTY_UPDLISTEN_ARRAY;
        this.stmtAwareListeners = EMPTY_UPDLISTENSA_ARRAY;
    }

    public synchronized void addListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        for (StatementAwareUpdateListener existing : this.stmtAwareListeners) {
            if (existing != listener) continue;
            return;
        }
        this.stmtAwareListeners = (StatementAwareUpdateListener[])CollectionUtil.arrayExpandAddSingle(this.stmtAwareListeners, listener);
    }

    public synchronized void removeListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        int index = -1;
        for (int i = 0; i < this.stmtAwareListeners.length; ++i) {
            if (this.stmtAwareListeners[i] != listener) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        this.stmtAwareListeners = (StatementAwareUpdateListener[])CollectionUtil.arrayShrinkRemoveSingle(this.stmtAwareListeners, index);
    }

    public void setSubscriber(Object subscriber) {
        this.subscriber = subscriber;
    }

    public Object getSubscriber() {
        return this.subscriber;
    }
}

