/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.hook.BaseCondition;
import com.espertech.esper.client.hook.ConditionHandler;
import com.espertech.esper.client.hook.ConditionHandlerContext;
import com.espertech.esper.client.hook.ExceptionHandler;
import com.espertech.esper.client.hook.ExceptionHandlerContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandle;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionHandlingService {
    private static final Log log = LogFactory.getLog(ExceptionHandlingService.class);
    private final String engineURI;
    private final List<ExceptionHandler> exceptionHandlers;
    private final List<ConditionHandler> conditionHandlers;

    public ExceptionHandlingService(String engineURI, List<ExceptionHandler> exceptionHandlers, List<ConditionHandler> conditionHandlers) {
        this.engineURI = engineURI;
        this.exceptionHandlers = exceptionHandlers;
        this.conditionHandlers = conditionHandlers;
    }

    public void handleCondition(BaseCondition condition, EPStatementHandle handle) {
        if (this.conditionHandlers.isEmpty()) {
            log.info((Object)("Condition encountered processing statement '" + handle.getStatementName() + "' statement text '" + handle.getEPL() + "' : " + condition.toString()));
            return;
        }
        ConditionHandlerContext context = new ConditionHandlerContext(this.engineURI, handle.getStatementName(), handle.getEPL(), condition);
        for (ConditionHandler handler : this.conditionHandlers) {
            handler.handle(context);
        }
    }

    public void handleException(RuntimeException ex, EPStatementAgentInstanceHandle handle) {
        if (this.exceptionHandlers.isEmpty()) {
            log.error((Object)("Exception encountered processing statement '" + handle.getStatementHandle().getStatementName() + "' statement text '" + handle.getStatementHandle().getEPL() + "' : " + ex.getMessage()), (Throwable)ex);
            return;
        }
        ExceptionHandlerContext context = new ExceptionHandlerContext(this.engineURI, ex, handle.getStatementHandle().getStatementName(), handle.getStatementHandle().getEPL());
        for (ExceptionHandler handler : this.exceptionHandlers) {
            handler.handle(context);
        }
    }
}

