/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Drop;
import com.espertech.esper.client.annotation.Priority;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.InsertIntoListener;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.core.service.InternalEventRouterDesc;
import com.espertech.esper.core.service.InternalEventRouterEntry;
import com.espertech.esper.core.service.InternalEventRouterPreprocessor;
import com.espertech.esper.core.service.InternalRoutePreprocessView;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.NullableObject;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalEventRouterImpl
implements InternalEventRouter {
    private static final Log log = LogFactory.getLog(InternalEventRouterImpl.class);
    private final ConcurrentHashMap<EventType, NullableObject<InternalEventRouterPreprocessor>> preprocessors = new ConcurrentHashMap();
    private final Map<UpdateDesc, IRDescEntry> descriptors = new LinkedHashMap<UpdateDesc, IRDescEntry>();
    private boolean hasPreprocessing = false;
    private InsertIntoListener insertIntoListener;

    @Override
    public boolean isHasPreprocessing() {
        return this.hasPreprocessing;
    }

    @Override
    public EventBean preprocess(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        return this.getPreprocessedEvent(theEvent, exprEvaluatorContext);
    }

    @Override
    public void setInsertIntoListener(InsertIntoListener insertIntoListener) {
        this.insertIntoListener = insertIntoListener;
    }

    @Override
    public void route(EventBean theEvent, EPStatementHandle statementHandle, InternalEventRouteDest routeDest, ExprEvaluatorContext exprEvaluatorContext, boolean addToFront) {
        if (!this.hasPreprocessing) {
            if (this.insertIntoListener != null) {
                boolean route = this.insertIntoListener.inserted(theEvent, statementHandle);
                if (route) {
                    routeDest.route(theEvent, statementHandle, addToFront);
                }
            } else {
                routeDest.route(theEvent, statementHandle, addToFront);
            }
            return;
        }
        EventBean preprocessed = this.getPreprocessedEvent(theEvent, exprEvaluatorContext);
        if (preprocessed != null) {
            if (this.insertIntoListener != null) {
                boolean route = this.insertIntoListener.inserted(theEvent, statementHandle);
                if (route) {
                    routeDest.route(preprocessed, statementHandle, addToFront);
                }
            } else {
                routeDest.route(preprocessed, statementHandle, addToFront);
            }
        }
    }

    @Override
    public InternalEventRouterDesc getValidatePreprocessing(EventType eventType, UpdateDesc desc, Annotation[] annotations) throws ExprValidationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating route preprocessing for type '" + eventType.getName() + "'"));
        }
        if (!(eventType instanceof EventTypeSPI)) {
            throw new ExprValidationException("Update statements require the event type to implement the " + EventTypeSPI.class + " interface");
        }
        EventTypeSPI eventTypeSPI = (EventTypeSPI)eventType;
        TypeWidener[] wideners = new TypeWidener[desc.getAssignments().size()];
        ArrayList<String> properties = new ArrayList<String>();
        for (int i = 0; i < desc.getAssignments().size(); ++i) {
            OnTriggerSetAssignment assignment = desc.getAssignments().get(i);
            EventPropertyDescriptor writableProperty = eventTypeSPI.getWritableProperty(assignment.getVariableName());
            if (writableProperty == null) {
                throw new ExprValidationException("Property '" + assignment.getVariableName() + "' is not available for write access");
            }
            wideners[i] = TypeWidenerFactory.getCheckPropertyAssignType(assignment.getExpression().toExpressionString(), assignment.getExpression().getExprEvaluator().getType(), writableProperty.getPropertyType(), assignment.getVariableName());
            properties.add(assignment.getVariableName());
        }
        EventBeanCopyMethod copyMethod = eventTypeSPI.getCopyMethod(properties.toArray(new String[properties.size()]));
        if (copyMethod == null) {
            throw new ExprValidationException("The update-clause requires the underlying event representation to support copy (via Serializable by default)");
        }
        return new InternalEventRouterDesc(desc, copyMethod, wideners, eventType, annotations);
    }

    @Override
    public void addPreprocessing(InternalEventRouterDesc internalEventRouterDesc, InternalRoutePreprocessView outputView, StatementAgentInstanceLock agentInstanceLock, boolean hasSubselect) {
        this.descriptors.put(internalEventRouterDesc.getUpdateDesc(), new IRDescEntry(internalEventRouterDesc, outputView, agentInstanceLock, hasSubselect));
        this.removePreprocessors(internalEventRouterDesc.getEventType());
        this.hasPreprocessing = true;
    }

    @Override
    public void removePreprocessing(EventType eventType, UpdateDesc desc) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing route preprocessing for type '" + eventType.getName()));
        }
        this.removePreprocessors(eventType);
        this.descriptors.remove(desc);
        if (this.descriptors.isEmpty()) {
            this.hasPreprocessing = false;
            this.preprocessors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBean getPreprocessedEvent(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        NullableObject<InternalEventRouterPreprocessor> processor = this.preprocessors.get(theEvent.getEventType());
        if (processor == null) {
            InternalEventRouterImpl internalEventRouterImpl = this;
            synchronized (internalEventRouterImpl) {
                processor = this.initialize(theEvent.getEventType());
                this.preprocessors.put(theEvent.getEventType(), processor);
            }
        }
        if (processor.getObject() == null) {
            return theEvent;
        }
        return processor.getObject().process(theEvent, exprEvaluatorContext);
    }

    private void removePreprocessors(EventType eventType) {
        this.preprocessors.remove(eventType);
        for (EventType type : this.preprocessors.keySet()) {
            if (type.getDeepSuperTypes() == null) continue;
            Iterator<EventType> it = type.getDeepSuperTypes();
            while (it.hasNext()) {
                if (it.next() != eventType) continue;
                this.preprocessors.remove(type);
            }
        }
    }

    private NullableObject<InternalEventRouterPreprocessor> initialize(EventType eventType) {
        EventTypeSPI eventTypeSPI = (EventTypeSPI)eventType;
        ArrayList<InternalEventRouterEntry> desc = new ArrayList<InternalEventRouterEntry>();
        HashSet<String> eventPropertiesWritten = new HashSet<String>();
        for (Map.Entry<UpdateDesc, IRDescEntry> entry : this.descriptors.entrySet()) {
            boolean applicable;
            boolean bl = applicable = entry.getValue().getEventType() == eventType;
            if (!applicable && eventType.getDeepSuperTypes() != null) {
                Iterator<EventType> it = eventType.getDeepSuperTypes();
                while (it.hasNext()) {
                    if (it.next() != entry.getValue().getEventType()) continue;
                    applicable = true;
                    break;
                }
            }
            if (!applicable) continue;
            int priority = 0;
            boolean isDrop = false;
            Annotation[] annotations = entry.getValue().getAnnotations();
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] instanceof Priority) {
                    priority = ((Priority)annotations[i]).value();
                }
                if (!(annotations[i] instanceof Drop)) continue;
                isDrop = true;
            }
            ArrayList<String> properties = new ArrayList<String>();
            ExprNode[] expressions = new ExprNode[entry.getKey().getAssignments().size()];
            for (int i = 0; i < entry.getKey().getAssignments().size(); ++i) {
                OnTriggerSetAssignment assignment = entry.getKey().getAssignments().get(i);
                expressions[i] = assignment.getExpression();
                properties.add(assignment.getVariableName());
                eventPropertiesWritten.add(assignment.getVariableName());
            }
            EventBeanWriter writer = eventTypeSPI.getWriter(properties.toArray(new String[properties.size()]));
            desc.add(new InternalEventRouterEntry(priority, isDrop, entry.getKey().getOptionalWhereClause(), expressions, writer, entry.getValue().getWideners(), entry.getValue().getOutputView(), entry.getValue().getAgentInstanceLock(), entry.getValue().hasSubselect));
        }
        EventBeanCopyMethod copyMethod = eventTypeSPI.getCopyMethod(eventPropertiesWritten.toArray(new String[eventPropertiesWritten.size()]));
        if (copyMethod == null) {
            return new NullableObject<Object>(null);
        }
        return new NullableObject<InternalEventRouterPreprocessor>(new InternalEventRouterPreprocessor(copyMethod, desc));
    }

    private static class IRDescEntry {
        private final InternalEventRouterDesc internalEventRouterDesc;
        private final InternalRoutePreprocessView outputView;
        private final StatementAgentInstanceLock agentInstanceLock;
        private final boolean hasSubselect;

        private IRDescEntry(InternalEventRouterDesc internalEventRouterDesc, InternalRoutePreprocessView outputView, StatementAgentInstanceLock agentInstanceLock, boolean hasSubselect) {
            this.internalEventRouterDesc = internalEventRouterDesc;
            this.outputView = outputView;
            this.agentInstanceLock = agentInstanceLock;
            this.hasSubselect = hasSubselect;
        }

        public EventType getEventType() {
            return this.internalEventRouterDesc.getEventType();
        }

        public Annotation[] getAnnotations() {
            return this.internalEventRouterDesc.getAnnotations();
        }

        public TypeWidener[] getWideners() {
            return this.internalEventRouterDesc.getWideners();
        }

        public InternalRoutePreprocessView getOutputView() {
            return this.outputView;
        }

        public StatementAgentInstanceLock getAgentInstanceLock() {
            return this.agentInstanceLock;
        }

        public boolean isHasSubselect() {
            return this.hasSubselect;
        }
    }
}

