/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleHandleCallbackProxy;
import com.espertech.esper.schedule.ScheduleServiceException;
import com.espertech.esper.schedule.ScheduleSet;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.ScheduleVisitor;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;

public class SchedulingServiceAudit
implements SchedulingServiceSPI {
    private final String engineUri;
    private final String statementName;
    private final SchedulingServiceSPI spi;

    public SchedulingServiceAudit(String engineUri, String statementName, SchedulingServiceSPI spi) {
        this.engineUri = engineUri;
        this.statementName = statementName;
        this.spi = spi;
    }

    @Override
    public boolean isScheduled(ScheduleHandle handle) {
        return this.spi.isScheduled(handle);
    }

    @Override
    public ScheduleSet take(Set<String> statementId) {
        return this.spi.take(statementId);
    }

    @Override
    public void apply(ScheduleSet scheduleSet) {
        this.spi.apply(scheduleSet);
    }

    @Override
    public Long getNearestTimeHandle() {
        return this.spi.getNearestTimeHandle();
    }

    @Override
    public void visitSchedules(ScheduleVisitor visitor) {
        this.spi.visitSchedules(visitor);
    }

    @Override
    public void add(long afterMSec, ScheduleHandle handle, ScheduleSlot slot) throws ScheduleServiceException {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("after ");
            message.write(Long.toString(afterMSec));
            message.write(" handle ");
            this.printHandle(message, handle);
            AuditPath.auditLog(this.engineUri, this.statementName, AuditEnum.SCHEDULE, message.toString());
            this.modifyCreateProxy(handle);
        }
        this.spi.add(afterMSec, handle, slot);
    }

    @Override
    public void remove(ScheduleHandle handle, ScheduleSlot slot) throws ScheduleServiceException {
        if (AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("remove handle ");
            this.printHandle(message, handle);
            AuditPath.auditLog(this.engineUri, this.statementName, AuditEnum.SCHEDULE, message.toString());
        }
        this.spi.remove(handle, slot);
    }

    @Override
    public void setTime(long timestamp) {
        this.spi.setTime(timestamp);
    }

    @Override
    public void evaluate(Collection<ScheduleHandle> handles) {
        this.spi.evaluate(handles);
    }

    @Override
    public void destroy() {
        this.spi.destroy();
    }

    @Override
    public int getTimeHandleCount() {
        return this.spi.getTimeHandleCount();
    }

    @Override
    public Long getFurthestTimeHandle() {
        return this.spi.getFurthestTimeHandle();
    }

    @Override
    public int getScheduleHandleCount() {
        return this.spi.getScheduleHandleCount();
    }

    @Override
    public long getTime() {
        return this.spi.getTime();
    }

    private void printHandle(StringWriter message, ScheduleHandle handle) {
        if (handle instanceof EPStatementHandleCallback) {
            EPStatementHandleCallback callback = (EPStatementHandleCallback)handle;
            JavaClassHelper.writeInstance(message, callback.getScheduleCallback(), true);
        } else {
            JavaClassHelper.writeInstance(message, handle, true);
        }
    }

    private void modifyCreateProxy(ScheduleHandle handle) {
        if (!(handle instanceof EPStatementHandleCallback)) {
            return;
        }
        EPStatementHandleCallback callback = (EPStatementHandleCallback)handle;
        ScheduleHandleCallback sc = (ScheduleHandleCallback)ScheduleHandleCallbackProxy.newInstance(this.engineUri, this.statementName, callback.getScheduleCallback());
        callback.setScheduleCallback(sc);
    }
}

