/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeAction;
import com.espertech.esper.epl.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.epl.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.epl.spec.OnTriggerMergeDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeMatched;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalObserverFactoryNode;
import java.util.ArrayList;

public class StatementLifecycleSvcUtil {
    public static void walkStatement(StatementSpecRaw spec, ExprNodeSubselectDeclaredDotVisitor visitor) throws ExprValidationException {
        for (SelectClauseElementRaw raw : spec.getSelectClauseSpec().getSelectExprList()) {
            if (!(raw instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec rawExpr = (SelectClauseExprRawSpec)raw;
            rawExpr.getSelectExpression().accept(visitor);
        }
        if (spec.getFilterRootNode() != null) {
            spec.getFilterRootNode().accept(visitor);
        }
        if (spec.getUpdateDesc() != null) {
            if (spec.getUpdateDesc().getOptionalWhereClause() != null) {
                spec.getUpdateDesc().getOptionalWhereClause().accept(visitor);
            }
            for (OnTriggerSetAssignment assignment : spec.getUpdateDesc().getAssignments()) {
                assignment.getExpression().accept(visitor);
            }
        }
        if (spec.getOnTriggerDesc() != null) {
            StatementLifecycleSvcUtil.visitSubselectOnTrigger(spec.getOnTriggerDesc(), visitor);
        }
        for (StreamSpecRaw streamSpecRaw : spec.getStreamSpecs()) {
            if (!(streamSpecRaw instanceof PatternStreamSpecRaw)) continue;
            PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)streamSpecRaw;
            EvalNodeAnalysisResult analysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(patternStreamSpecRaw.getEvalFactoryNode());
            for (EvalFactoryNode evalNode : analysisResult.getActiveNodes()) {
                if (evalNode instanceof EvalFilterFactoryNode) {
                    EvalFilterFactoryNode filterNode = (EvalFilterFactoryNode)evalNode;
                    for (ExprNode filterExpr : filterNode.getRawFilterSpec().getFilterExpressions()) {
                        filterExpr.accept(visitor);
                    }
                    continue;
                }
                if (!(evalNode instanceof EvalObserverFactoryNode)) continue;
                int beforeCount = visitor.getSubselects().size();
                EvalObserverFactoryNode observerNode = (EvalObserverFactoryNode)evalNode;
                for (ExprNode param : observerNode.getPatternObserverSpec().getObjectParameters()) {
                    param.accept(visitor);
                }
                if (visitor.getSubselects().size() == beforeCount) continue;
                throw new ExprValidationException("Subselects are not allowed within pattern observer parameters, please consider using a variable instead");
            }
        }
        StatementLifecycleSvcUtil.walkStreamSpecs(spec, visitor);
    }

    public static void walkStreamSpecs(StatementSpecRaw spec, ExprNodeSubselectDeclaredDotVisitor visitor) {
        for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
            if (rawSpec instanceof FilterStreamSpecRaw) {
                FilterStreamSpecRaw raw = (FilterStreamSpecRaw)rawSpec;
                for (ExprNode filterExpr : raw.getRawFilterSpec().getFilterExpressions()) {
                    filterExpr.accept(visitor);
                }
            }
            if (!(rawSpec instanceof PatternStreamSpecRaw)) continue;
            PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)rawSpec;
            EvalNodeAnalysisResult analysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(patternStreamSpecRaw.getEvalFactoryNode());
            for (EvalFactoryNode evalNode : analysisResult.getActiveNodes()) {
                if (!(evalNode instanceof EvalFilterFactoryNode)) continue;
                EvalFilterFactoryNode filterNode = (EvalFilterFactoryNode)evalNode;
                for (ExprNode filterExpr : filterNode.getRawFilterSpec().getFilterExpressions()) {
                    filterExpr.accept(visitor);
                }
            }
        }
    }

    private static void visitSubselectOnTrigger(OnTriggerDesc onTriggerDesc, ExprNodeSubselectDeclaredDotVisitor visitor) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (!(onTriggerDesc instanceof OnTriggerWindowUpdateDesc)) break block12;
                        OnTriggerWindowUpdateDesc updates = (OnTriggerWindowUpdateDesc)onTriggerDesc;
                        for (OnTriggerSetAssignment assignment : updates.getAssignments()) {
                            assignment.getExpression().accept(visitor);
                        }
                        break block13;
                    }
                    if (!(onTriggerDesc instanceof OnTriggerSetDesc)) break block14;
                    OnTriggerSetDesc sets = (OnTriggerSetDesc)onTriggerDesc;
                    for (OnTriggerSetAssignment assignment : sets.getAssignments()) {
                        assignment.getExpression().accept(visitor);
                    }
                    break block13;
                }
                if (!(onTriggerDesc instanceof OnTriggerSplitStreamDesc)) break block15;
                OnTriggerSplitStreamDesc splits = (OnTriggerSplitStreamDesc)onTriggerDesc;
                for (OnTriggerSplitStream split : splits.getSplitStreams()) {
                    if (split.getWhereClause() != null) {
                        split.getWhereClause().accept(visitor);
                    }
                    if (split.getSelectClause().getSelectExprList() == null) continue;
                    for (SelectClauseElementRaw element : split.getSelectClause().getSelectExprList()) {
                        if (!(element instanceof SelectClauseExprRawSpec)) continue;
                        SelectClauseExprRawSpec selectExpr = (SelectClauseExprRawSpec)element;
                        selectExpr.getSelectExpression().accept(visitor);
                    }
                }
                break block13;
            }
            if (!(onTriggerDesc instanceof OnTriggerMergeDesc)) break block13;
            OnTriggerMergeDesc merge = (OnTriggerMergeDesc)onTriggerDesc;
            for (OnTriggerMergeMatched matched : merge.getItems()) {
                if (matched.getOptionalMatchCond() != null) {
                    matched.getOptionalMatchCond().accept(visitor);
                }
                for (OnTriggerMergeAction action : matched.getActions()) {
                    if (action.getOptionalWhereClause() != null) {
                        action.getOptionalWhereClause().accept(visitor);
                    }
                    if (action instanceof OnTriggerMergeActionUpdate) {
                        OnTriggerMergeActionUpdate update = (OnTriggerMergeActionUpdate)action;
                        for (OnTriggerSetAssignment assignment : update.getAssignments()) {
                            assignment.getExpression().accept(visitor);
                        }
                    }
                    if (!(action instanceof OnTriggerMergeActionInsert)) continue;
                    OnTriggerMergeActionInsert insert = (OnTriggerMergeActionInsert)action;
                    for (SelectClauseElementRaw element : insert.getSelectClause()) {
                        if (!(element instanceof SelectClauseExprRawSpec)) continue;
                        SelectClauseExprRawSpec selectExpr = (SelectClauseExprRawSpec)element;
                        selectExpr.getSelectExpression().accept(visitor);
                    }
                }
            }
        }
    }

    public static SelectClauseSpecCompiled compileSelectClause(SelectClauseSpecRaw spec) {
        ArrayList<SelectClauseElementCompiled> selectElements = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            SelectClauseElementRaw rawExpr;
            if (raw instanceof SelectClauseExprRawSpec) {
                rawExpr = (SelectClauseExprRawSpec)raw;
                selectElements.add(new SelectClauseExprCompiledSpec(((SelectClauseExprRawSpec)rawExpr).getSelectExpression(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseStreamRawSpec) {
                rawExpr = (SelectClauseStreamRawSpec)raw;
                selectElements.add(new SelectClauseStreamCompiledSpec(((SelectClauseStreamRawSpec)rawExpr).getStreamName(), ((SelectClauseStreamRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseElementWildcard) {
                SelectClauseElementWildcard wildcard = (SelectClauseElementWildcard)raw;
                selectElements.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element class : " + raw.getClass().getName());
        }
        return new SelectClauseSpecCompiled(selectElements.toArray(new SelectClauseElementCompiled[selectElements.size()]), spec.isDistinct());
    }
}

