/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.annotation.NoLock;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementAgentInstanceRWLockImpl;
import com.espertech.esper.core.service.StatementLockFactory;
import com.espertech.esper.core.service.StatementNoLockImpl;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import java.lang.annotation.Annotation;

public class StatementLockFactoryImpl
implements StatementLockFactory {
    private final boolean fairlocks;
    private final boolean disableLocking;

    public StatementLockFactoryImpl(boolean fairlocks, boolean disableLocking) {
        this.fairlocks = fairlocks;
        this.disableLocking = disableLocking;
    }

    @Override
    public StatementAgentInstanceLock getStatementLock(String statementName, String expressionText, Annotation[] annotations, boolean stateless) {
        boolean foundNoLock;
        boolean bl = foundNoLock = AnnotationUtil.findAnnotation(annotations, NoLock.class) != null;
        if (this.disableLocking || foundNoLock || stateless) {
            return new StatementNoLockImpl(statementName);
        }
        return new StatementAgentInstanceRWLockImpl(this.fairlocks);
    }
}

