/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import com.espertech.esper.core.start.EPPreparedExecuteMethodHelper;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.base.JoinSetFilter;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPPreparedExecuteMethodQuery
implements EPPreparedExecuteMethod {
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    private static final Log log = LogFactory.getLog(EPPreparedExecuteMethodQuery.class);
    private final StatementSpecCompiled statementSpec;
    private final ResultSetProcessor resultSetProcessor;
    private final NamedWindowProcessor[] processors;
    private final AgentInstanceContext agentInstanceContext;
    private final EPServicesContext services;
    private EventBeanReader eventBeanReader;
    private JoinSetComposerPrototype joinSetComposerPrototype;
    private final FilterSpecCompiled[] filters;

    public EPPreparedExecuteMethodQuery(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging) {
            queryPlanLog.info((Object)("Query plans for Fire-and-forget query '" + statementContext.getExpression() + "'"));
        }
        this.statementSpec = statementSpec;
        this.services = services;
        EPPreparedExecuteMethodHelper.validateFAFQuery(statementSpec);
        int numStreams = statementSpec.getStreamSpecs().length;
        EventType[] typesPerStream = new EventType[numStreams];
        String[] namesPerStream = new String[numStreams];
        this.processors = new NamedWindowProcessor[numStreams];
        this.agentInstanceContext = new AgentInstanceContext(statementContext, null, -1, null, null, statementContext.getDefaultAgentInstanceScriptContext());
        for (int i = 0; i < numStreams; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            String streamName = namedSpec.getWindowName();
            if (namedSpec.getOptionalStreamName() != null) {
                streamName = namedSpec.getOptionalStreamName();
            }
            namesPerStream[i] = streamName;
            this.processors[i] = services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            if (this.processors[i] == null) {
                throw new ExprValidationException("A named window by name '" + namedSpec.getWindowName() + "' does not exist");
            }
            typesPerStream[i] = this.processors[i].getTailView().getEventType();
        }
        this.filters = new FilterSpecCompiled[numStreams];
        if (statementSpec.getFilterRootNode() != null) {
            LinkedHashMap<String, Pair<EventType, String>> tagged = new LinkedHashMap<String, Pair<EventType, String>>();
            for (int i = 0; i < numStreams; ++i) {
                try {
                    StreamTypeServiceImpl types = new StreamTypeServiceImpl(typesPerStream, namesPerStream, new boolean[numStreams], services.getEngineURI(), false);
                    this.filters[i] = FilterSpecCompiler.makeFilterSpec(typesPerStream[i], namesPerStream[i], Collections.singletonList(statementSpec.getFilterRootNode()), null, tagged, tagged, types, null, statementContext, Collections.singleton(i));
                    continue;
                }
                catch (Exception ex) {
                    log.warn((Object)("Unexpected exception analyzing filter paths: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        boolean[] isIStreamOnly = new boolean[namesPerStream.length];
        Arrays.fill(isIStreamOnly, true);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(typesPerStream, namesPerStream, isIStreamOnly, services.getEngineURI(), true);
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, null);
        ResultSetProcessorFactoryDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(statementSpec, statementContext, typeService, null, new boolean[0], true, ContextPropertyRegistryImpl.EMPTY_REGISTRY, null);
        this.resultSetProcessor = EPStatementStartMethodHelperAssignExpr.getAssignResultSetProcessor(this.agentInstanceContext, resultSetProcessorPrototype);
        if (statementSpec.getSelectClauseSpec().isDistinct()) {
            if (this.resultSetProcessor.getResultEventType() instanceof EventTypeSPI) {
                this.eventBeanReader = ((EventTypeSPI)this.resultSetProcessor.getResultEventType()).getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(this.resultSetProcessor.getResultEventType());
            }
        }
        if (numStreams > 1) {
            StreamJoinAnalysisResult streamJoinAnalysisResult = new StreamJoinAnalysisResult(numStreams);
            Arrays.fill(streamJoinAnalysisResult.getNamedWindow(), true);
            for (int i = 0; i < numStreams; ++i) {
                NamedWindowProcessorInstance processorInstance = this.processors[i].getProcessorInstance(this.agentInstanceContext);
                if (this.processors[i].isVirtualDataWindow()) {
                    streamJoinAnalysisResult.getViewExternal()[i] = processorInstance.getRootViewInstance().getVirtualDataWindow();
                }
                String[][] uniqueIndexes = this.processors[i].getUniqueIndexes(processorInstance);
                streamJoinAnalysisResult.getUniqueKeys()[i] = uniqueIndexes;
            }
            boolean hasAggregations = !resultSetProcessorPrototype.getAggregationServiceFactoryDesc().getExpressions().isEmpty();
            this.joinSetComposerPrototype = JoinSetComposerPrototypeFactory.makeComposerPrototype(null, null, statementSpec.getOuterJoinDescList(), statementSpec.getFilterRootNode(), typesPerStream, namesPerStream, streamJoinAnalysisResult, queryPlanLogging, statementContext.getAnnotations(), new HistoricalViewableDesc(numStreams), this.agentInstanceContext, false, hasAggregations);
        }
        if (statementSpec.getOptionalContextName() != null && numStreams > 1) {
            throw new ExprValidationException("Joins in runtime queries for context partitions are not supported");
        }
    }

    @Override
    public EventType getEventType() {
        return this.resultSetProcessor.getResultEventType();
    }

    @Override
    public EPPreparedQueryResult execute(ContextPartitionSelector[] contextPartitionSelectors) {
        int numStreams = this.processors.length;
        if (contextPartitionSelectors != null && contextPartitionSelectors.length != numStreams) {
            throw new IllegalArgumentException("Number of context partition selectors does not match the number of named windows in the from-clause");
        }
        if (this.statementSpec.getOptionalContextName() == null) {
            Collection[] snapshots = new Collection[numStreams];
            for (int i = 0; i < numStreams; ++i) {
                ContextPartitionSelector selector = contextPartitionSelectors == null ? null : contextPartitionSelectors[i];
                snapshots[i] = this.getStreamFilterSnapshot(i, selector);
            }
            this.resultSetProcessor.clear();
            return this.process(snapshots);
        }
        ArrayList<ContextPartitionResult> contextPartitionResults = new ArrayList<ContextPartitionResult>();
        ContextPartitionSelector singleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
        Collection<Integer> agentInstanceIds = EPPreparedExecuteMethodHelper.getAgentInstanceIds(this.processors[0], singleSelector, this.services.getContextManagementService(), this.statementSpec.getOptionalContextName());
        for (int agentInstanceId : agentInstanceIds) {
            NamedWindowProcessorInstance processorInstance = this.processors[0].getProcessorInstance(agentInstanceId);
            if (processorInstance == null) continue;
            Collection<EventBean> coll = processorInstance.getTailViewInstance().snapshot(this.filters[0], this.statementSpec.getAnnotations());
            contextPartitionResults.add(new ContextPartitionResult(coll, processorInstance.getTailViewInstance().getAgentInstanceContext()));
        }
        ArrayDeque<EventBean[]> events = new ArrayDeque<EventBean[]>();
        for (ContextPartitionResult contextPartitionResult : contextPartitionResults) {
            Collection<EventBean> snapshot = contextPartitionResult.getEvents();
            if (this.statementSpec.getFilterRootNode() != null) {
                snapshot = this.getFiltered(snapshot, Collections.singletonList(this.statementSpec.getFilterRootNode()));
            }
            EventBean[] rows = snapshot.toArray(new EventBean[snapshot.size()]);
            this.resultSetProcessor.setAgentInstanceContext(contextPartitionResult.getContext());
            UniformPair<EventBean[]> results = this.resultSetProcessor.processViewResult(rows, null, true);
            if (results == null || results.getFirst() == null || results.getFirst().length <= 0) continue;
            events.add(results.getFirst());
        }
        return new EPPreparedQueryResult(this.resultSetProcessor.getResultEventType(), EventBeanUtility.flatten(events));
    }

    private Collection<EventBean> getStreamFilterSnapshot(int streamNum, ContextPartitionSelector contextPartitionSelector) {
        StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs()[streamNum];
        NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
        NamedWindowProcessor namedWindowProcessor = this.processors[streamNum];
        NamedWindowProcessorInstance processorInstance = namedWindowProcessor.getProcessorInstance(this.agentInstanceContext);
        if (processorInstance != null) {
            return this.getStreamSnapshotInstance(streamNum, namedSpec, processorInstance);
        }
        Collection<Integer> contextPartitions = EPPreparedExecuteMethodHelper.getAgentInstanceIds(namedWindowProcessor, contextPartitionSelector, this.services.getContextManagementService(), namedWindowProcessor.getContextName());
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        for (int agentInstanceId : contextPartitions) {
            processorInstance = namedWindowProcessor.getProcessorInstance(agentInstanceId);
            if (processorInstance == null) continue;
            Collection<EventBean> coll = processorInstance.getTailViewInstance().snapshot(this.filters[streamNum], this.statementSpec.getAnnotations());
            events.addAll(coll);
        }
        return events;
    }

    private Collection<EventBean> getStreamSnapshotInstance(int streamNum, NamedWindowConsumerStreamSpec namedSpec, NamedWindowProcessorInstance processorInstance) {
        Collection<EventBean> coll = processorInstance.getTailViewInstance().snapshot(this.filters[streamNum], this.statementSpec.getAnnotations());
        if (namedSpec.getFilterExpressions().size() != 0) {
            coll = this.getFiltered(coll, namedSpec.getFilterExpressions());
        }
        return coll;
    }

    private EPPreparedQueryResult process(Collection<EventBean>[] snapshots) {
        UniformPair<EventBean[]> results;
        int numStreams = this.processors.length;
        if (numStreams == 1) {
            if (this.statementSpec.getFilterRootNode() != null) {
                snapshots[0] = this.getFiltered(snapshots[0], Arrays.asList(this.statementSpec.getFilterRootNode()));
            }
            EventBean[] rows = snapshots[0].toArray(new EventBean[snapshots[0].size()]);
            results = this.resultSetProcessor.processViewResult(rows, null, true);
        } else {
            Viewable[] viewablePerStream = new Viewable[numStreams];
            for (int i = 0; i < numStreams; ++i) {
                NamedWindowProcessorInstance instance = this.processors[i].getProcessorInstance(this.agentInstanceContext);
                if (instance == null) {
                    throw new UnsupportedOperationException("Joins against named windows that are under context are not supported");
                }
                viewablePerStream[i] = instance.getTailViewInstance();
            }
            JoinSetComposerDesc joinSetComposerDesc = this.joinSetComposerPrototype.create(viewablePerStream, true);
            JoinSetComposer joinComposer = joinSetComposerDesc.getJoinSetComposer();
            JoinSetFilter joinFilter = joinSetComposerDesc.getPostJoinFilterEvaluator() != null ? new JoinSetFilter(joinSetComposerDesc.getPostJoinFilterEvaluator()) : null;
            EventBean[][] oldDataPerStream = new EventBean[numStreams][];
            EventBean[][] newDataPerStream = new EventBean[numStreams][];
            for (int i = 0; i < numStreams; ++i) {
                newDataPerStream[i] = snapshots[i].toArray(new EventBean[snapshots[i].size()]);
            }
            UniformPair<Set<MultiKey<EventBean>>> result = joinComposer.join(newDataPerStream, oldDataPerStream, this.agentInstanceContext);
            if (joinFilter != null) {
                joinFilter.process(result.getFirst(), null, this.agentInstanceContext);
            }
            results = this.resultSetProcessor.processJoinResult(result.getFirst(), null, true);
        }
        if (this.statementSpec.getSelectClauseSpec().isDistinct()) {
            results.setFirst(EventBeanUtility.getDistinctByProp(results.getFirst(), this.eventBeanReader));
        }
        return new EPPreparedQueryResult(this.resultSetProcessor.getResultEventType(), results.getFirst());
    }

    private Collection<EventBean> getFiltered(Collection<EventBean> snapshot, List<ExprNode> filterExpressions) {
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(Math.min(snapshot.size(), 16));
        ExprNodeUtility.applyFilterExpressionsIterable(snapshot, filterExpressions, this.agentInstanceContext, deque);
        return deque;
    }

    private static class ContextPartitionResult {
        private final Collection<EventBean> events;
        private final AgentInstanceContext context;

        private ContextPartitionResult(Collection<EventBean> events, AgentInstanceContext context) {
            this.events = events;
            this.context = context;
        }

        public Collection<EventBean> getEvents() {
            return this.events;
        }

        public AgentInstanceContext getContext() {
            return this.context;
        }
    }
}

