/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import com.espertech.esper.core.start.EPPreparedExecuteMethodHelper;
import com.espertech.esper.core.start.EPPreparedExecuteSingleStreamExec;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EPPreparedExecuteSingleStream
implements EPPreparedExecuteMethod {
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    private static final Log log = LogFactory.getLog(EPPreparedExecuteSingleStream.class);
    protected final StatementSpecCompiled statementSpec;
    protected final NamedWindowProcessor processor;
    protected final EPServicesContext services;
    protected final EPPreparedExecuteSingleStreamExec executor;
    protected final StatementContext statementContext;

    public abstract EPPreparedExecuteSingleStreamExec getExecutor(FilterSpecCompiled var1, String var2);

    public EPPreparedExecuteSingleStream(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        FilterSpecCompiled filter;
        boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging) {
            queryPlanLog.info((Object)("Query plans for Fire-and-forget query '" + statementContext.getExpression() + "'"));
        }
        this.statementSpec = statementSpec;
        this.services = services;
        this.statementContext = statementContext;
        EPPreparedExecuteMethodHelper.validateFAFQuery(statementSpec);
        StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[0];
        NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
        String aliasName = namedSpec.getWindowName();
        if (namedSpec.getOptionalStreamName() != null) {
            aliasName = namedSpec.getOptionalStreamName();
        }
        this.processor = services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
        if (this.processor == null) {
            throw new ExprValidationException("A named window by name '" + namedSpec.getWindowName() + "' does not exist");
        }
        EventType eventType = this.processor.getTailView().getEventType();
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{eventType}, new String[]{aliasName}, new boolean[]{true}, services.getEngineURI(), true);
        if (statementSpec.getFilterRootNode() != null) {
            FilterSpecCompiled filterCompiled;
            LinkedHashMap<String, Pair<EventType, String>> tagged = new LinkedHashMap<String, Pair<EventType, String>>();
            try {
                filterCompiled = FilterSpecCompiler.makeFilterSpec(eventType, aliasName, Collections.singletonList(statementSpec.getFilterRootNode()), null, tagged, tagged, typeService, null, statementContext, Collections.singleton(0));
            }
            catch (Exception ex) {
                log.warn((Object)("Unexpected exception analyzing filter paths: " + ex.getMessage()), (Throwable)ex);
                filterCompiled = null;
            }
            filter = filterCompiled;
        } else {
            filter = null;
        }
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, null);
        this.executor = this.getExecutor(filter, aliasName);
    }

    @Override
    public EventType getEventType() {
        return this.processor.getNamedWindowType();
    }

    @Override
    public EPPreparedQueryResult execute(ContextPartitionSelector[] contextPartitionSelectors) {
        NamedWindowProcessorInstance processorInstance;
        ContextPartitionSelector optionalSingleSelector;
        if (contextPartitionSelectors != null && contextPartitionSelectors.length != 1) {
            throw new IllegalArgumentException("Number of context partition selectors must be one");
        }
        ContextPartitionSelector contextPartitionSelector = optionalSingleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
        if (this.processor.getContextName() != null && this.statementSpec.getOptionalContextName() != null && !this.processor.getContextName().equals(this.statementSpec.getOptionalContextName())) {
            throw new EPException("Context for named window is '" + this.processor.getContextName() + "' and query specifies context '" + this.statementSpec.getOptionalContextName() + "'");
        }
        if (this.statementSpec.getOptionalContextName() == null && (processorInstance = this.processor.getProcessorInstanceNoContext()) != null) {
            EventBean[] rows = this.executor.execute(processorInstance);
            if (rows.length > 0) {
                this.dispatch();
            }
            return new EPPreparedQueryResult(this.processor.getNamedWindowType(), rows);
        }
        Collection<Integer> agentInstanceIds = EPPreparedExecuteMethodHelper.getAgentInstanceIds(this.processor, optionalSingleSelector, this.services.getContextManagementService(), this.processor.getContextName());
        if (agentInstanceIds.isEmpty()) {
            return new EPPreparedQueryResult(this.processor.getNamedWindowType(), CollectionUtil.EVENT_PER_STREAM_EMPTY);
        }
        if (agentInstanceIds.size() == 1) {
            int agentInstanceId = agentInstanceIds.iterator().next();
            NamedWindowProcessorInstance processorInstance2 = this.processor.getProcessorInstance(agentInstanceId);
            EventBean[] rows = this.executor.execute(processorInstance2);
            if (rows.length > 0) {
                this.dispatch();
            }
            return new EPPreparedQueryResult(this.processor.getNamedWindowType(), rows);
        }
        ArrayDeque<EventBean> allRows = new ArrayDeque<EventBean>();
        for (int agentInstanceId : agentInstanceIds) {
            NamedWindowProcessorInstance processorInstance3 = this.processor.getProcessorInstance(agentInstanceId);
            if (processorInstance3 == null) continue;
            EventBean[] rows = this.executor.execute(processorInstance3);
            allRows.addAll(Arrays.asList(rows));
        }
        if (allRows.size() > 0) {
            this.dispatch();
        }
        return new EPPreparedQueryResult(this.processor.getNamedWindowType(), allRows.toArray(new EventBean[allRows.size()]));
    }

    protected void dispatch() {
        this.services.getInternalEventEngineRouteDest().processThreadWorkQueue();
    }
}

