/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.core.context.factory.StatementAgentInstancePreload;
import com.espertech.esper.core.context.mgr.ContextManagedStatementSelectDesc;
import com.espertech.esper.core.context.stmt.AIRegistryAggregation;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.stmt.AIRegistryPrevious;
import com.espertech.esper.core.context.stmt.AIRegistryPrior;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactoryDesc;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodSelectDesc;
import com.espertech.esper.core.start.EPStatementStartMethodSelectUtil;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.expression.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprSubselectStrategy;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodSelect
extends EPStatementStartMethodBase {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodSelect.class);

    public EPStatementStartMethodSelect(StatementSpecCompiled statementSpec) {
        super(statementSpec);
    }

    @Override
    public EPStatementStartResult startInternal(final EPServicesContext services, final StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementDestroyMethod destroyStatementMethod;
        EPStatementStopMethod stopStatementMethod;
        Viewable finalViewable;
        HashMap<ExprPreviousNode, ExprPreviousEvalStrategy> previousStrategyInstances;
        Map<Object, Object> priorStrategyInstances;
        HashMap<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategyInstances;
        AggregationService aggregationService;
        final String contextName = this.statementSpec.getOptionalContextName();
        AgentInstanceContext defaultAgentInstanceContext = this.getDefaultAgentInstanceContext(statementContext);
        EPStatementStartMethodSelectDesc selectDesc = EPStatementStartMethodSelectUtil.prepare(this.statementSpec, services, statementContext, isRecoveringResilient, defaultAgentInstanceContext, this.isQueryPlanLogging(services), null, null, null);
        List<Object> preloadList = Collections.emptyList();
        if (this.statementSpec.getOptionalContextName() != null) {
            Object specificService;
            aggregationService = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceAggregationService();
            AIRegistryExpr aiRegistryExpr = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
            subselectStrategyInstances = new HashMap();
            for (Map.Entry<ExprSubselectNode, SubSelectStrategyFactoryDesc> entry : selectDesc.getSubSelectStrategyCollection().getSubqueries().entrySet()) {
                specificService = aiRegistryExpr.allocateSubselect(entry.getKey());
                entry.getKey().setStrategy((ExprSubselectStrategy)specificService);
                HashMap<ExprPriorNode, ExprPriorEvalStrategy> subselectPriorStrategies = new HashMap<ExprPriorNode, ExprPriorEvalStrategy>();
                for (ExprPriorNode subselectPrior : entry.getValue().getPriorNodesList()) {
                    AIRegistryPrior specificSubselectPriorService = aiRegistryExpr.allocatePrior(subselectPrior);
                    subselectPriorStrategies.put(subselectPrior, specificSubselectPriorService);
                }
                HashMap<ExprPreviousNode, ExprPreviousEvalStrategy> subselectPreviousStrategies = new HashMap<ExprPreviousNode, ExprPreviousEvalStrategy>();
                for (ExprPreviousNode subselectPrevious : entry.getValue().getPrevNodesList()) {
                    AIRegistryPrevious specificSubselectPreviousService = aiRegistryExpr.allocatePrevious(subselectPrevious);
                    subselectPreviousStrategies.put(subselectPrevious, specificSubselectPreviousService);
                }
                AIRegistryAggregation subselectAggregation = aiRegistryExpr.allocateSubselectAggregation(entry.getKey());
                SubSelectStrategyHolder strategyHolder = new SubSelectStrategyHolder((ExprSubselectStrategy)specificService, subselectAggregation, subselectPriorStrategies, subselectPreviousStrategies, null, null);
                subselectStrategyInstances.put(entry.getKey(), strategyHolder);
            }
            priorStrategyInstances = new HashMap();
            for (ExprPriorNode priorNode : selectDesc.getViewResourceDelegateUnverified().getPriorRequests()) {
                specificService = aiRegistryExpr.allocatePrior(priorNode);
                priorStrategyInstances.put(priorNode, specificService);
            }
            previousStrategyInstances = new HashMap();
            for (ExprPreviousNode previousNode : selectDesc.getViewResourceDelegateUnverified().getPreviousRequests()) {
                specificService = aiRegistryExpr.allocatePrevious(previousNode);
                previousStrategyInstances.put(previousNode, (ExprPreviousEvalStrategy)specificService);
            }
            ContextMergeView contextMergeView = new ContextMergeView(selectDesc.getResultSetProcessorPrototypeDesc().getResultSetProcessorFactory().getResultEventType());
            finalViewable = contextMergeView;
            ContextManagedStatementSelectDesc statement = new ContextManagedStatementSelectDesc(this.statementSpec, statementContext, contextMergeView, selectDesc.getStatementAgentInstanceFactorySelect(), selectDesc.getResultSetProcessorPrototypeDesc().getAggregationServiceFactoryDesc().getExpressions(), selectDesc.getSubSelectStrategyCollection());
            services.getContextManagementService().addStatement(contextName, statement, isRecoveringResilient);
            final EPStatementStopMethod selectStop = selectDesc.getStopMethod();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    services.getContextManagementService().stoppedStatement(contextName, statementContext.getStatementName(), statementContext.getStatementId());
                    selectStop.stop();
                }
            };
            destroyStatementMethod = new EPStatementDestroyMethod(){

                @Override
                public void destroy() {
                    services.getContextManagementService().destroyedStatement(contextName, statementContext.getStatementName(), statementContext.getStatementId());
                }
            };
        } else {
            StatementAgentInstanceFactorySelectResult resultOfStart = selectDesc.getStatementAgentInstanceFactorySelect().newContext(defaultAgentInstanceContext, isRecoveringResilient);
            finalViewable = resultOfStart.getFinalView();
            final EPStatementStopMethod ePStatementStopMethod = selectDesc.getStopMethod();
            final StopCallback startResultStop = resultOfStart.getStopCallback();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    StatementAgentInstanceUtil.stopSafe(startResultStop, statementContext);
                    ePStatementStopMethod.stop();
                }
            };
            destroyStatementMethod = null;
            aggregationService = resultOfStart.getOptionalAggegationService();
            subselectStrategyInstances = resultOfStart.getSubselectStrategies();
            priorStrategyInstances = resultOfStart.getPriorNodeStrategies();
            previousStrategyInstances = resultOfStart.getPreviousNodeStrategies();
            preloadList = resultOfStart.getPreloadList();
            if (statementContext.getExtensionServicesContext() != null) {
                statementContext.getExtensionServicesContext().startContextPartition(resultOfStart, 0);
            }
        }
        EPStatementStartMethodHelperAssignExpr.assignExpressionStrategies(selectDesc, aggregationService, subselectStrategyInstances, priorStrategyInstances, previousStrategyInstances);
        for (StatementAgentInstancePreload statementAgentInstancePreload : preloadList) {
            statementAgentInstancePreload.executePreload();
        }
        return new EPStatementStartResult(finalViewable, stopStatementMethod, destroyStatementMethod);
    }
}

