/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.client.hook.SQLColumnTypeConversion;
import com.espertech.esper.client.hook.SQLOutputRowConversion;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.activator.ViewableActivatorFactory;
import com.espertech.esper.core.context.activator.ViewableActivatorFilterProxy;
import com.espertech.esper.core.context.activator.ViewableActivatorNamedWindow;
import com.espertech.esper.core.context.activator.ViewableActivatorPattern;
import com.espertech.esper.core.context.activator.ViewableActivatorStreamReuseView;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelect;
import com.espertech.esper.core.context.subselect.SubSelectActivationCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperUtil;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.EPStatementStartMethodHelperViewResources;
import com.espertech.esper.core.start.EPStatementStartMethodSelectDesc;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.core.MethodPollingViewableFactory;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.SelectExprProcessorDeliveryCallback;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.core.ViewResourceDelegateVerified;
import com.espertech.esper.epl.db.DatabasePollingViewableFactory;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.view.OutputProcessViewCallback;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputProcessViewFactoryFactory;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.rowregex.EventRowRegexNFAViewFactory;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodSelectUtil {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodSelectUtil.class);

    public static EPStatementStartMethodSelectDesc prepare(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext, boolean recoveringResilient, AgentInstanceContext defaultAgentInstanceContext, boolean queryPlanLogging, ViewableActivatorFactory optionalViewableActivatorFactory, OutputProcessViewCallback optionalOutputProcessViewCallback, SelectExprProcessorDeliveryCallback selectExprProcessorDeliveryCallback) throws ExprValidationException {
        HistoricalEventViewable historicalEventViewable;
        LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        String contextName = statementSpec.getOptionalContextName();
        ContextPropertyRegistry contextPropertyRegistry = contextName != null ? services.getContextManagementService().getContextDescriptor(contextName).getContextPropertyRegistry() : null;
        String[] streamNames = EPStatementStartMethodHelperUtil.determineStreamNames(statementSpec.getStreamSpecs());
        int numStreams = streamNames.length;
        boolean isJoin = statementSpec.getStreamSpecs().length > 1;
        boolean hasContext = statementSpec.getOptionalContextName() != null;
        SubSelectActivationCollection subSelectStreamDesc = EPStatementStartMethodHelperSubselect.createSubSelectActivation(services, statementSpec, statementContext);
        ViewableActivator[] eventStreamParentViewableActivators = new ViewableActivator[numStreams];
        ViewFactoryChain[] unmaterializedViewChain = new ViewFactoryChain[numStreams];
        String[] eventTypeNames = new String[numStreams];
        boolean[] isNamedWindow = new boolean[numStreams];
        HistoricalEventViewable[] historicalEventViewables = new HistoricalEventViewable[numStreams];
        StreamJoinAnalysisResult joinAnalysisResult = EPStatementStartMethodSelectUtil.verifyJoinViews(statementSpec, statementContext.getNamedWindowService(), defaultAgentInstanceContext);
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext);
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                ViewableActivator activatorDeactivator;
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                eventTypeNames[i] = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
                boolean filterSubselectSameStream = EPStatementStartMethodHelperUtil.determineSubquerySameStream(statementSpec, filterStreamSpec);
                if (optionalViewableActivatorFactory != null) {
                    activatorDeactivator = optionalViewableActivatorFactory.createActivator(filterStreamSpec);
                    if (activatorDeactivator == null) {
                        throw new IllegalStateException("Viewable activate is null for " + filterStreamSpec.getFilterSpec().getFilterForEventType().getName());
                    }
                } else {
                    activatorDeactivator = !hasContext ? new ViewableActivatorStreamReuseView(services, statementContext, statementSpec, filterStreamSpec, isJoin, evaluatorContextStmt, filterSubselectSameStream) : new ViewableActivatorFilterProxy(services, filterStreamSpec.getFilterSpec(), statementSpec.getAnnotations(), false);
                }
                eventStreamParentViewableActivators[i] = activatorDeactivator;
                EventType resultEventType = filterStreamSpec.getFilterSpec().getResultEventType();
                unmaterializedViewChain[i] = services.getViewService().createFactories(i, resultEventType, streamSpec.getViewSpecs(), streamSpec.getOptions(), statementContext);
                continue;
            }
            if (streamSpec instanceof PatternStreamSpecCompiled) {
                PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
                boolean usedByChildViews = streamSpec.getViewSpecs().length > 0 || statementSpec.getInsertIntoDesc() != null;
                String patternTypeName = statementContext.getStatementId() + "_pattern_" + i;
                EventType eventType = services.getEventAdapterService().createSemiAnonymousMapType(patternTypeName, patternStreamSpec.getTaggedEventTypes(), patternStreamSpec.getArrayEventTypes(), usedByChildViews);
                unmaterializedViewChain[i] = services.getViewService().createFactories(i, eventType, streamSpec.getViewSpecs(), streamSpec.getOptions(), statementContext);
                EvalRootFactoryNode rootFactoryNode = services.getPatternNodeFactory().makeRootNode();
                rootFactoryNode.addChildNode(patternStreamSpec.getEvalFactoryNode());
                PatternContext patternContext = statementContext.getPatternContextFactory().createContext(statementContext, i, rootFactoryNode, patternStreamSpec.getMatchedEventMapMeta(), true);
                ViewableActivatorPattern patternActivator = new ViewableActivatorPattern(patternContext, rootFactoryNode, eventType, EPStatementStartMethodHelperUtil.isConsumingFilters(patternStreamSpec.getEvalFactoryNode()));
                eventStreamParentViewableActivators[i] = patternActivator;
                continue;
            }
            if (streamSpec instanceof DBStatementStreamSpec) {
                if (streamSpec.getViewSpecs().length > 0) {
                    throw new ExprValidationException("Historical data joins do not allow views onto the data, view '" + streamSpec.getViewSpecs()[0].getObjectNamespace() + ':' + streamSpec.getViewSpecs()[0].getObjectName() + "' is not valid in this context");
                }
                DBStatementStreamSpec sqlStreamSpec = (DBStatementStreamSpec)streamSpec;
                SQLColumnTypeConversion typeConversionHook = (SQLColumnTypeConversion)JavaClassHelper.getAnnotationHook(statementSpec.getAnnotations(), HookType.SQLCOL, SQLColumnTypeConversion.class, statementContext.getMethodResolutionService());
                SQLOutputRowConversion outputRowConversionHook = (SQLOutputRowConversion)JavaClassHelper.getAnnotationHook(statementSpec.getAnnotations(), HookType.SQLROW, SQLOutputRowConversion.class, statementContext.getMethodResolutionService());
                EPStatementAgentInstanceHandle epStatementAgentInstanceHandle = defaultAgentInstanceContext.getEpStatementAgentInstanceHandle();
                historicalEventViewables[i] = historicalEventViewable = DatabasePollingViewableFactory.createDBStatementView(statementContext.getStatementId(), i, sqlStreamSpec, services.getDatabaseRefService(), services.getEventAdapterService(), epStatementAgentInstanceHandle, typeConversionHook, outputRowConversionHook, statementContext.getConfigSnapshot().getEngineDefaults().getLogging().isEnableJDBC());
                unmaterializedViewChain[i] = new ViewFactoryChain(historicalEventViewable.getEventType(), new LinkedList<ViewFactory>());
                eventStreamParentViewableActivators[i] = new ViewableActivator(){

                    @Override
                    public ViewableActivationResult activate(AgentInstanceContext agentInstanceContext, boolean isSubselect, boolean isRecoveringResilient) {
                        return new ViewableActivationResult(historicalEventViewable, CollectionUtil.STOP_CALLBACK_NONE, null, null);
                    }
                };
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof MethodStreamSpec) {
                HistoricalEventViewable historicalEventViewable2;
                if (streamSpec.getViewSpecs().length > 0) {
                    throw new ExprValidationException("Method data joins do not allow views onto the data, view '" + streamSpec.getViewSpecs()[0].getObjectNamespace() + ':' + streamSpec.getViewSpecs()[0].getObjectName() + "' is not valid in this context");
                }
                MethodStreamSpec methodStreamSpec = (MethodStreamSpec)streamSpec;
                EPStatementAgentInstanceHandle epStatementAgentInstanceHandle = defaultAgentInstanceContext.getEpStatementAgentInstanceHandle();
                historicalEventViewables[i] = historicalEventViewable2 = MethodPollingViewableFactory.createPollMethodView(i, methodStreamSpec, services.getEventAdapterService(), epStatementAgentInstanceHandle, statementContext.getMethodResolutionService(), services.getEngineImportService(), statementContext.getSchedulingService(), statementContext.getScheduleBucket(), evaluatorContextStmt);
                unmaterializedViewChain[i] = new ViewFactoryChain(historicalEventViewable2.getEventType(), new LinkedList<ViewFactory>());
                eventStreamParentViewableActivators[i] = new ViewableActivator(){

                    @Override
                    public ViewableActivationResult activate(AgentInstanceContext agentInstanceContext, boolean isSubselect, boolean isRecoveringResilient) {
                        return new ViewableActivationResult(historicalEventViewable2, CollectionUtil.STOP_CALLBACK_NONE, null, null);
                    }
                };
                stopCallbacks.add(historicalEventViewable2);
                continue;
            }
            if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                NamedWindowProcessor processor = services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                EventType namedWindowType = processor.getTailView().getEventType();
                if (namedSpec.getOptPropertyEvaluator() != null) {
                    namedWindowType = namedSpec.getOptPropertyEvaluator().getFragmentEventType();
                }
                eventStreamParentViewableActivators[i] = new ViewableActivatorNamedWindow(processor, namedSpec.getFilterExpressions(), namedSpec.getOptPropertyEvaluator());
                unmaterializedViewChain[i] = services.getViewService().createFactories(i, namedWindowType, namedSpec.getViewSpecs(), namedSpec.getOptions(), statementContext);
                joinAnalysisResult.setNamedWindow(i);
                eventTypeNames[i] = namedSpec.getWindowName();
                isNamedWindow[i] = true;
                EPStatementStartMethodHelperValidate.validateNoDataWindowOnNamedWindow(unmaterializedViewChain[i].getViewFactoryChain());
                continue;
            }
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        if (statementSpec.getMatchRecognizeSpec() != null) {
            if (isJoin) {
                throw new ExprValidationException("Joins are not allowed when using match recognize");
            }
            boolean isUnbound = unmaterializedViewChain[0].getViewFactoryChain().isEmpty() && !(statementSpec.getStreamSpecs()[0] instanceof NamedWindowConsumerStreamSpec);
            AgentInstanceContext agentInstanceContext = defaultAgentInstanceContext;
            EventRowRegexNFAViewFactory factory = new EventRowRegexNFAViewFactory(unmaterializedViewChain[0], statementSpec.getMatchRecognizeSpec(), agentInstanceContext, isUnbound, statementSpec.getAnnotations());
            unmaterializedViewChain[0].getViewFactoryChain().add(factory);
            EPStatementStartMethodHelperAssignExpr.assignAggregations(factory.getAggregationService(), factory.getAggregationExpressions());
        }
        EventType[] streamEventTypes = new EventType[statementSpec.getStreamSpecs().length];
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            streamEventTypes[i] = unmaterializedViewChain[i].getEventType();
        }
        joinAnalysisResult.addUniquenessInfo(unmaterializedViewChain);
        SubSelectStrategyCollection subSelectStrategyCollection = EPStatementStartMethodHelperSubselect.planSubSelect(services, statementContext, queryPlanLogging, subSelectStreamDesc, streamNames, streamEventTypes, eventTypeNames, stopCallbacks, statementSpec.getAnnotations(), statementSpec.getDeclaredExpressions(), contextPropertyRegistry);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(streamEventTypes, streamNames, EPStatementStartMethodHelperUtil.getHasIStreamOnly(isNamedWindow, unmaterializedViewChain), services.getEngineURI(), false);
        ViewResourceDelegateUnverified viewResourceDelegateUnverified = new ViewResourceDelegateUnverified();
        HistoricalViewableDesc historicalViewableDesc = new HistoricalViewableDesc(numStreams);
        for (int stream = 0; stream < historicalEventViewables.length; ++stream) {
            historicalEventViewable = historicalEventViewables[stream];
            if (historicalEventViewable == null) continue;
            historicalEventViewable.validate(services.getEngineImportService(), typeService, statementContext.getMethodResolutionService(), statementContext.getTimeProvider(), statementContext.getVariableService(), evaluatorContextStmt, services.getConfigSnapshot(), services.getSchedulingService(), services.getEngineURI(), statementSpec.getSqlParameters(), statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations());
            historicalViewableDesc.setHistorical(stream, historicalEventViewable.getRequiredStreams());
            if (!historicalEventViewable.getRequiredStreams().contains(stream)) continue;
            throw new ExprValidationException("Parameters for historical stream " + stream + " indicate that the stream is subordinate to itself as stream parameters originate in the same stream");
        }
        ResultSetProcessorFactoryDesc resultSetProcessorPrototypeDesc = ResultSetProcessorFactoryFactory.getProcessorPrototype(statementSpec, statementContext, typeService, viewResourceDelegateUnverified, joinAnalysisResult.getUnidirectionalInd(), true, contextPropertyRegistry, selectExprProcessorDeliveryCallback);
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, viewResourceDelegateUnverified);
        ViewResourceDelegateVerified viewResourceDelegateVerified = EPStatementStartMethodHelperViewResources.verifyPreviousAndPriorRequirements(unmaterializedViewChain, viewResourceDelegateUnverified);
        JoinSetComposerPrototype joinSetComposerPrototype = null;
        if (numStreams > 1) {
            boolean selectsRemoveStream = statementSpec.getSelectStreamSelectorEnum().isSelectsRStream() || statementSpec.getOutputLimitSpec() != null;
            boolean hasAggregations = !resultSetProcessorPrototypeDesc.getAggregationServiceFactoryDesc().getExpressions().isEmpty();
            joinSetComposerPrototype = JoinSetComposerPrototypeFactory.makeComposerPrototype(statementContext.getStatementName(), statementContext.getStatementId(), statementSpec.getOuterJoinDescList(), statementSpec.getFilterRootNode(), typeService.getEventTypes(), streamNames, joinAnalysisResult, queryPlanLogging, statementContext.getAnnotations(), historicalViewableDesc, defaultAgentInstanceContext, selectsRemoveStream, hasAggregations);
        }
        OutputProcessViewFactory outputViewFactory = OutputProcessViewFactoryFactory.make(statementSpec, services.getInternalEventRouter(), statementContext, resultSetProcessorPrototypeDesc.getResultSetProcessorFactory().getResultEventType(), optionalOutputProcessViewCallback);
        StatementAgentInstanceFactorySelect factory = new StatementAgentInstanceFactorySelect(numStreams, eventStreamParentViewableActivators, statementContext, statementSpec, services, typeService, unmaterializedViewChain, resultSetProcessorPrototypeDesc, joinAnalysisResult, recoveringResilient, joinSetComposerPrototype, subSelectStrategyCollection, viewResourceDelegateVerified, outputViewFactory);
        EPStatementStopMethodImpl stopMethod = new EPStatementStopMethodImpl(statementContext, stopCallbacks);
        return new EPStatementStartMethodSelectDesc(factory, subSelectStrategyCollection, viewResourceDelegateUnverified, resultSetProcessorPrototypeDesc, stopMethod);
    }

    private static StreamJoinAnalysisResult verifyJoinViews(StatementSpecCompiled statementSpec, NamedWindowService namedWindowService, AgentInstanceContext defaultAgentInstanceContext) throws ExprValidationException {
        StreamSpecCompiled[] streamSpecs = statementSpec.getStreamSpecs();
        StreamJoinAnalysisResult analysisResult = new StreamJoinAnalysisResult(streamSpecs.length);
        if (streamSpecs.length < 2) {
            return analysisResult;
        }
        int unidirectionalStreamNumber = -1;
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec.getOptions().isUnidirectional()) {
                analysisResult.setUnidirectionalInd(i);
                if (unidirectionalStreamNumber != -1) {
                    throw new ExprValidationException("The unidirectional keyword can only apply to one stream in a join");
                }
                unidirectionalStreamNumber = i;
            }
            if (streamSpec.getViewSpecs().length > 0) {
                analysisResult.setHasChildViews(i);
            }
            if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
            NamedWindowConsumerStreamSpec nwSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            if (nwSpec.getOptPropertyEvaluator() != null && !streamSpec.getOptions().isUnidirectional()) {
                throw new ExprValidationException("Failed to validate named window use in join, contained-event is only allowed for named windows when marked as unidirectional");
            }
            analysisResult.setNamedWindow(i);
            NamedWindowProcessor processor = namedWindowService.getProcessor(nwSpec.getWindowName());
            NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(defaultAgentInstanceContext);
            String[][] uniqueIndexes = processor.getUniqueIndexes(processorInstance);
            analysisResult.getUniqueKeys()[i] = uniqueIndexes;
            if (!processor.isVirtualDataWindow()) continue;
            analysisResult.getViewExternal()[i] = processorInstance.getRootViewInstance().getVirtualDataWindow();
        }
        if (unidirectionalStreamNumber != -1 && analysisResult.getHasChildViews()[unidirectionalStreamNumber]) {
            throw new ExprValidationException("The unidirectional keyword requires that no views are declared onto the stream");
        }
        analysisResult.setUnidirectionalStreamNumber(unidirectionalStreamNumber);
        int countProviderNonpolling = 0;
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec instanceof MethodStreamSpec || streamSpec instanceof DBStatementStreamSpec) continue;
            ++countProviderNonpolling;
        }
        if (countProviderNonpolling == 1) {
            return analysisResult;
        }
        FilterSpecCompiled unidirectionalFilterSpec = null;
        FilterSpecCompiled lastFilterSpec = null;
        boolean pureSelfJoin = true;
        for (StreamSpecCompiled streamSpec : statementSpec.getStreamSpecs()) {
            if (!(streamSpec instanceof FilterStreamSpecCompiled)) {
                pureSelfJoin = false;
                continue;
            }
            FilterSpecCompiled filterSpec = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec();
            if (lastFilterSpec != null && !lastFilterSpec.equalsTypeAndFilter(filterSpec)) {
                pureSelfJoin = false;
            }
            if (streamSpec.getViewSpecs().length > 0) {
                pureSelfJoin = false;
            }
            lastFilterSpec = filterSpec;
            if (!streamSpec.getOptions().isUnidirectional()) continue;
            unidirectionalFilterSpec = filterSpec;
        }
        if (pureSelfJoin && unidirectionalFilterSpec == null) {
            analysisResult.setPureSelfJoin(true);
            return analysisResult;
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec.getViewSpecs().length > 0) continue;
            String name = streamSpec.getOptionalStreamName();
            if (name == null && streamSpec instanceof FilterStreamSpecCompiled) {
                name = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventTypeName();
            }
            if (name == null && streamSpec instanceof PatternStreamSpecCompiled) {
                name = "pattern event stream";
            }
            if (streamSpec.getOptions().isUnidirectional()) continue;
            if (unidirectionalFilterSpec != null && streamSpec instanceof FilterStreamSpecCompiled && ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().equalsTypeAndFilter(unidirectionalFilterSpec)) {
                analysisResult.setUnidirectionalNonDriving(i);
                continue;
            }
            if (!(streamSpec instanceof FilterStreamSpecCompiled) && !(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            throw new ExprValidationException("Joins require that at least one view is specified for each stream, no view was specified for " + name);
        }
        return analysisResult;
    }
}

