/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.thread;

import com.espertech.esper.core.service.EPRuntimeImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.thread.TimerUnit;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerUnitSingle
implements TimerUnit {
    private static final Log log = LogFactory.getLog(TimerUnitSingle.class);
    private final EPServicesContext services;
    private final EPRuntimeImpl runtime;
    private final EPStatementHandleCallback handleCallback;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public TimerUnitSingle(EPServicesContext services, EPRuntimeImpl runtime, EPStatementHandleCallback handleCallback, ExprEvaluatorContext exprEvaluatorContext) {
        this.services = services;
        this.runtime = runtime;
        this.handleCallback = handleCallback;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public void run() {
        try {
            EPRuntimeImpl.processStatementScheduleSingle(this.handleCallback, this.services, this.exprEvaluatorContext);
            this.runtime.dispatch();
            this.runtime.processThreadWorkQueue();
        }
        catch (RuntimeException e) {
            log.error((Object)("Unexpected error processing timer execution: " + e.getMessage()), (Throwable)e);
        }
    }
}

