/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.dataflow.annotations.DataFlowContext;
import com.espertech.esper.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.dataflow.annotations.DataFlowOperator;
import com.espertech.esper.dataflow.interfaces.DataFlowOpCloseContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializateContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializeResult;
import com.espertech.esper.dataflow.interfaces.DataFlowOpLifecycle;
import com.espertech.esper.dataflow.interfaces.DataFlowOpOpenContext;
import com.espertech.esper.dataflow.interfaces.EPDataFlowEmitter;
import com.espertech.esper.dataflow.util.GraphTypeDesc;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventBeanSPI;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@DataFlowOperator
public class Filter
implements DataFlowOpLifecycle {
    private static final Log log = LogFactory.getLog(Filter.class);
    @DataFlowOpParameter
    private ExprNode filter;
    private ExprEvaluator evaluator;
    private EventBeanSPI theEvent;
    private EventBean[] eventsPerStream = new EventBean[1];
    private boolean singleOutputPort;
    @DataFlowContext
    private EPDataFlowEmitter graphContext;

    @Override
    public DataFlowOpInitializeResult initialize(DataFlowOpInitializateContext prepareContext) throws Exception {
        if (prepareContext.getInputPorts().size() != 1) {
            throw new ExprValidationException("Filter requires single input port");
        }
        if (this.filter == null) {
            throw new ExprValidationException("Required parameter 'filter' providing the filter expression is not provided");
        }
        if (prepareContext.getOutputPorts().isEmpty() || prepareContext.getOutputPorts().size() > 2) {
            throw new IllegalArgumentException("Filter operator requires one or two output stream(s) but produces " + prepareContext.getOutputPorts().size() + " streams");
        }
        EventType eventType = prepareContext.getInputPorts().get(0).getTypeDesc().getEventType();
        this.singleOutputPort = prepareContext.getOutputPorts().size() == 1;
        ExprNode validated = ExprNodeUtility.validateSimpleGetSubtree(this.filter, prepareContext.getStatementContext(), eventType);
        this.evaluator = validated.getExprEvaluator();
        this.theEvent = prepareContext.getServicesContext().getEventAdapterService().getShellForType(eventType);
        this.eventsPerStream[0] = this.theEvent;
        GraphTypeDesc[] typesPerPort = new GraphTypeDesc[prepareContext.getOutputPorts().size()];
        for (int i = 0; i < typesPerPort.length; ++i) {
            typesPerPort[i] = new GraphTypeDesc(false, true, eventType);
        }
        return new DataFlowOpInitializeResult(typesPerPort);
    }

    public void onInput(Object row) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received row for filtering: " + Arrays.toString((Object[])row)));
        }
        if (!(row instanceof EventBean)) {
            this.theEvent.setUnderlying(row);
        } else {
            this.theEvent = (EventBeanSPI)row;
        }
        Boolean pass = (Boolean)this.evaluator.evaluate(this.eventsPerStream, true, null);
        if (pass != null && pass.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Submitting row " + Arrays.toString((Object[])row)));
            }
            if (this.singleOutputPort) {
                this.graphContext.submit(row);
            } else {
                this.graphContext.submitPort(0, row);
            }
        } else if (!this.singleOutputPort) {
            this.graphContext.submitPort(1, row);
        }
    }

    @Override
    public void open(DataFlowOpOpenContext openContext) {
    }

    @Override
    public void close(DataFlowOpCloseContext openContext) {
    }
}

