/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.ops;

import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.EventPropertyRenderer;
import com.espertech.esper.client.util.EventPropertyRendererContext;
import com.espertech.esper.client.util.JSONEventRenderer;
import com.espertech.esper.client.util.JSONRenderingOptions;
import com.espertech.esper.client.util.XMLEventRenderer;
import com.espertech.esper.client.util.XMLRenderingOptions;
import com.espertech.esper.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.dataflow.annotations.DataFlowOperator;
import com.espertech.esper.dataflow.interfaces.DataFlowOpCloseContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializateContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializeResult;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInputPort;
import com.espertech.esper.dataflow.interfaces.DataFlowOpLifecycle;
import com.espertech.esper.dataflow.interfaces.DataFlowOpOpenContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventBeanSPI;
import com.espertech.esper.event.EventBeanUtility;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@DataFlowOperator
public class LogSink
implements DataFlowOpLifecycle {
    private static final Log logme = LogFactory.getLog(LogSink.class);
    @DataFlowOpParameter
    private String title;
    @DataFlowOpParameter
    private String layout;
    @DataFlowOpParameter
    private String format;
    @DataFlowOpParameter
    private boolean log = true;
    @DataFlowOpParameter
    private boolean linefeed = true;
    private String dataflowName;
    private String dataFlowInstanceId;
    private ConsoleOpRenderer renderer;
    private EventBeanSPI[] shellPerStream;

    @Override
    public DataFlowOpInitializeResult initialize(DataFlowOpInitializateContext context) throws Exception {
        if (!context.getOutputPorts().isEmpty()) {
            throw new IllegalArgumentException("LogSink operator does not provide an output stream");
        }
        this.dataflowName = context.getDataflowName();
        this.dataFlowInstanceId = context.getDataflowInstanceId();
        this.shellPerStream = new EventBeanSPI[context.getInputPorts().size()];
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : context.getInputPorts().entrySet()) {
            EventType eventType = entry.getValue().getTypeDesc().getEventType();
            if (eventType == null) continue;
            this.shellPerStream[entry.getKey().intValue()] = context.getStatementContext().getEventAdapterService().getShellForType(eventType);
        }
        if (this.format == null) {
            this.renderer = new ConsoleOpRendererSummary();
        } else {
            try {
                LogSinkOutputFormat formatEnum = LogSinkOutputFormat.valueOf(this.format.trim().toLowerCase());
                this.renderer = formatEnum == LogSinkOutputFormat.summary ? new ConsoleOpRendererSummary() : new ConsoleOpRendererXmlJSon(formatEnum, context.getEngine().getEPRuntime());
            }
            catch (RuntimeException ex) {
                throw new ExprValidationException("Format '" + this.format + "' is not supported, expecting any of " + Arrays.toString((Object[])LogSinkOutputFormat.values()));
            }
        }
        return null;
    }

    @Override
    public void open(DataFlowOpOpenContext openContext) {
    }

    @Override
    public void close(DataFlowOpCloseContext openContext) {
    }

    public void onInput(int port, Object theEvent) {
        String line;
        if (this.layout == null) {
            StringWriter writer = new StringWriter();
            writer.write("[");
            writer.write(this.dataflowName);
            writer.write("] ");
            if (this.title != null) {
                writer.write("[");
                writer.write(this.title);
                writer.write("] ");
            }
            if (this.dataFlowInstanceId != null) {
                writer.write("[");
                writer.write(this.dataFlowInstanceId);
                writer.write("] ");
            }
            writer.write("[port ");
            writer.write(Integer.toString(port));
            writer.write("] ");
            this.getEventOut(port, theEvent, writer);
            line = writer.toString();
        } else {
            String result = this.layout.replace("%df", this.dataflowName).replace("%p", Integer.toString(port));
            if (this.dataFlowInstanceId != null) {
                result = result.replace("%i", this.dataFlowInstanceId);
            }
            if (this.title != null) {
                result = result.replace("%t", this.title);
            }
            StringWriter writer = new StringWriter();
            this.getEventOut(port, theEvent, writer);
            line = result = result.replace("%e", writer.toString());
        }
        if (!this.linefeed) {
            line = line.replaceAll("\n", "").replaceAll("\r", "");
        }
        if (this.log) {
            logme.info((Object)line);
        } else {
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEventOut(int port, Object theEvent, StringWriter writer) {
        if (theEvent instanceof EventBean) {
            this.renderer.render((EventBean)theEvent, writer);
            return;
        }
        if (this.shellPerStream[port] != null) {
            LogSink logSink = this;
            synchronized (logSink) {
                this.shellPerStream[port].setUnderlying(theEvent);
                this.renderer.render(this.shellPerStream[port], writer);
            }
            return;
        }
        writer.write("Unrecognized underlying: ");
        writer.write(theEvent.toString());
    }

    public static class ConsoleOpEventPropertyRenderer
    implements EventPropertyRenderer {
        public static ConsoleOpEventPropertyRenderer INSTANCE = new ConsoleOpEventPropertyRenderer();

        @Override
        public void render(EventPropertyRendererContext context) {
            if (context.getPropertyValue() instanceof Object[]) {
                context.getStringBuilder().append(Arrays.toString((Object[])context.getPropertyValue()));
            } else {
                context.getDefaultRenderer().render(context.getPropertyValue(), context.getStringBuilder());
            }
        }
    }

    public static class RenderingOptions {
        private static XMLRenderingOptions xmlOptions = new XMLRenderingOptions();
        private static JSONRenderingOptions jsonOptions;

        public static XMLRenderingOptions getXmlOptions() {
            return xmlOptions;
        }

        public static void setXmlOptions(XMLRenderingOptions xmlOptions) {
            RenderingOptions.xmlOptions = xmlOptions;
        }

        public static JSONRenderingOptions getJsonOptions() {
            return jsonOptions;
        }

        public static void setJsonOptions(JSONRenderingOptions jsonOptions) {
            RenderingOptions.jsonOptions = jsonOptions;
        }

        static {
            xmlOptions.setPreventLooping(true);
            xmlOptions.setRenderer(ConsoleOpEventPropertyRenderer.INSTANCE);
            jsonOptions = new JSONRenderingOptions();
            jsonOptions.setPreventLooping(true);
            jsonOptions.setRenderer(ConsoleOpEventPropertyRenderer.INSTANCE);
        }
    }

    public static class ConsoleOpRendererXmlJSon
    implements ConsoleOpRenderer {
        private final LogSinkOutputFormat format;
        private final EPRuntime runtime;
        private final Map<EventType, JSONEventRenderer> jsonRendererCache = new HashMap<EventType, JSONEventRenderer>();
        private final Map<EventType, XMLEventRenderer> xmlRendererCache = new HashMap<EventType, XMLEventRenderer>();

        public ConsoleOpRendererXmlJSon(LogSinkOutputFormat format, EPRuntime runtime) {
            this.format = format;
            this.runtime = runtime;
        }

        @Override
        public void render(EventBean theEvent, StringWriter writer) {
            String result;
            if (this.format == LogSinkOutputFormat.json) {
                JSONEventRenderer renderer = this.jsonRendererCache.get(theEvent.getEventType());
                if (renderer == null) {
                    renderer = this.getJsonRenderer(theEvent.getEventType());
                    this.jsonRendererCache.put(theEvent.getEventType(), renderer);
                }
                result = renderer.render(theEvent.getEventType().getName(), theEvent);
            } else {
                XMLEventRenderer renderer = this.xmlRendererCache.get(theEvent.getEventType());
                if (renderer == null) {
                    renderer = this.getXmlRenderer(theEvent.getEventType());
                    this.xmlRendererCache.put(theEvent.getEventType(), renderer);
                }
                result = renderer.render(theEvent.getEventType().getName(), theEvent);
            }
            writer.append(result);
        }

        protected JSONEventRenderer getJsonRenderer(EventType eventType) {
            return this.runtime.getEventRenderer().getJSONRenderer(eventType, RenderingOptions.getJsonOptions());
        }

        protected XMLEventRenderer getXmlRenderer(EventType eventType) {
            return this.runtime.getEventRenderer().getXMLRenderer(eventType, RenderingOptions.getXmlOptions());
        }
    }

    public static class ConsoleOpRendererSummary
    implements ConsoleOpRenderer {
        @Override
        public void render(EventBean theEvent, StringWriter writer) {
            EventBeanUtility.summarize(theEvent, writer);
        }
    }

    public static interface ConsoleOpRenderer {
        public void render(EventBean var1, StringWriter var2);
    }

    public static enum LogSinkOutputFormat {
        json,
        xml,
        summary;

    }
}

