/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.util;

import com.espertech.esper.client.dataflow.EPDataFlowSignal;
import com.espertech.esper.dataflow.annotations.DataFlowOperator;
import com.espertech.esper.dataflow.interfaces.EPDataFlowSignalHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@DataFlowOperator
public class DefaultSupportCaptureOp<T>
implements EPDataFlowSignalHandler,
Future<Object[]> {
    private List<List<T>> received = new ArrayList<List<T>>();
    private List<T> current = new ArrayList<T>();
    private CountDownLatch numRowLatch;

    public DefaultSupportCaptureOp() {
        this(0);
    }

    public DefaultSupportCaptureOp(int latchedNumRows) {
        this.numRowLatch = new CountDownLatch(latchedNumRows);
    }

    public synchronized void onInput(T event) {
        this.current.add(event);
        if (this.numRowLatch != null) {
            this.numRowLatch.countDown();
        }
    }

    @Override
    public void onSignal(EPDataFlowSignal signal) {
        this.received.add(this.current);
        this.current = new ArrayList<T>();
    }

    public synchronized List<List<T>> getAndReset() {
        List<List<T>> resultEvents = this.received;
        this.received = new ArrayList<List<T>>();
        this.current.clear();
        return resultEvents;
    }

    public synchronized Object[] getCurrent() {
        return this.current.toArray();
    }

    public synchronized Object[] getCurrentAndReset() {
        Object[] currentArray = this.current.toArray();
        this.current.clear();
        return currentArray;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDone() {
        return this.numRowLatch.getCount() <= 0L;
    }

    @Override
    public Object[] get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    @Override
    public Object[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean result = this.numRowLatch.await(timeout, unit);
        if (!result) {
            throw new TimeoutException("latch timed out");
        }
        return this.getCurrent();
    }

    public Object[] getPunctuated() throws InterruptedException, ExecutionException, TimeoutException {
        boolean result = this.numRowLatch.await(1L, TimeUnit.SECONDS);
        if (!result) {
            throw new TimeoutException("latch timed out");
        }
        return this.received.get(0).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInvocation(long msecWait, int numberOfNewEvents) {
        long startTime = System.currentTimeMillis();
        while (true) {
            DefaultSupportCaptureOp defaultSupportCaptureOp = this;
            synchronized (defaultSupportCaptureOp) {
                if (System.currentTimeMillis() - startTime > msecWait) {
                    throw new RuntimeException("No events or less then the number of expected events received, expected " + numberOfNewEvents + " received " + this.current.size());
                }
                if (this.current.size() >= numberOfNewEvents) {
                    return;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

