/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.util;

import com.espertech.esper.dataflow.util.LogicalChannel;
import com.espertech.esper.dataflow.util.LogicalChannelBinding;
import com.espertech.esper.dataflow.util.LogicalChannelProducingPortCompiled;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogicalChannelUtil {
    public static List<LogicalChannelBinding> getBindingsConsuming(int producerOpNum, List<LogicalChannelBinding> bindings) {
        ArrayList<LogicalChannelBinding> result = new ArrayList<LogicalChannelBinding>();
        for (LogicalChannelBinding binding : bindings) {
            if (binding.getLogicalChannel().getOutputPort().getProducingOpNum() != producerOpNum) continue;
            result.add(binding);
        }
        return result;
    }

    public static String printChannels(List<LogicalChannel> channels) {
        StringWriter writer = new StringWriter();
        writer.write("\n");
        for (LogicalChannel channel : channels) {
            writer.write(channel.toString() + "\n");
        }
        return writer.toString();
    }

    public static List<LogicalChannelProducingPortCompiled> getOutputPortByStreamName(Set<Integer> incomingOpNums, String[] inputStreamNames, Map<Integer, List<LogicalChannelProducingPortCompiled>> compiledOutputPorts) {
        ArrayList<LogicalChannelProducingPortCompiled> ports = new ArrayList<LogicalChannelProducingPortCompiled>();
        for (int operator : incomingOpNums) {
            List<LogicalChannelProducingPortCompiled> opPorts = compiledOutputPorts.get(operator);
            if (opPorts == null) continue;
            for (LogicalChannelProducingPortCompiled opPort : opPorts) {
                for (String streamName : inputStreamNames) {
                    if (!opPort.getStreamName().equals(streamName)) continue;
                    ports.add(opPort);
                }
            }
        }
        return ports;
    }
}

